/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.constraints.validatorresolution;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import javax.validation.Constraint;
import javax.validation.ConstraintTarget;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.Payload;
import javax.validation.constraintvalidation.SupportedValidationTarget;
import javax.validation.constraintvalidation.ValidationTarget;

@Documented
@Constraint(validatedBy={GenericValidator.class, CrossParameterValidator.class})
@Target(value={ElementType.METHOD, ElementType.CONSTRUCTOR, ElementType.TYPE, ElementType.FIELD})
@Retention(value=RetentionPolicy.RUNTIME)
public @interface GenericAndCrossParameterConstraint {
    public String message() default "default message";

    public Class<?>[] groups() default {};

    public Class<? extends Payload>[] payload() default {};

    public ConstraintTarget validationAppliesTo() default ConstraintTarget.IMPLICIT;

    @SupportedValidationTarget(value={ValidationTarget.PARAMETERS})
    public static class CrossParameterValidator
    implements ConstraintValidator<GenericAndCrossParameterConstraint, Object> {
        public void initialize(GenericAndCrossParameterConstraint parameters) {
        }

        public boolean isValid(Object object, ConstraintValidatorContext constraintValidatorContext) {
            constraintValidatorContext.disableDefaultConstraintViolation();
            constraintValidatorContext.buildConstraintViolationWithTemplate("violation created by cross-parameter validator").addConstraintViolation();
            return false;
        }
    }

    @SupportedValidationTarget(value={ValidationTarget.ANNOTATED_ELEMENT})
    public static class GenericValidator
    implements ConstraintValidator<GenericAndCrossParameterConstraint, Object> {
        public void initialize(GenericAndCrossParameterConstraint parameters) {
        }

        public boolean isValid(Object object, ConstraintValidatorContext constraintValidatorContext) {
            constraintValidatorContext.disableDefaultConstraintViolation();
            constraintValidatorContext.buildConstraintViolationWithTemplate("violation created by generic validator").addConstraintViolation();
            return false;
        }
    }
}

