/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.xmlconfiguration.constraintdeclaration;

import java.util.Set;
import javax.validation.Configuration;
import javax.validation.Validator;
import javax.validation.groups.Default;
import javax.validation.metadata.BeanDescriptor;
import org.hibernate.beanvalidation.tck.tests.xmlconfiguration.constraintdeclaration.Optional;
import org.hibernate.beanvalidation.tck.tests.xmlconfiguration.constraintdeclaration.Package;
import org.hibernate.beanvalidation.tck.tests.xmlconfiguration.constraintdeclaration.PrePosting;
import org.hibernate.beanvalidation.tck.tests.xmlconfiguration.constraintdeclaration.ValidPackage;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="1.1.0")
public class ConfigurationViaXmlAndAnnotationsTest
extends Arquillian {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClass(ConfigurationViaXmlAndAnnotationsTest.class)).withClasses(Optional.class, Package.class, PrePosting.class, ValidPackage.class)).withValidationXml("validation-ConfigurationViaXmlAndAnnotationsTest.xml")).withResource("package-constraints-ConfigurationViaXmlAndAnnotationsTest.xml")).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="7.1.1", id="e"), @SpecAssertion(section="7.1.1", id="a")})
    public void testEntityConfiguredViaAnnotationsAndXml() {
        Validator validator = TestUtil.getValidatorUnderTest();
        BeanDescriptor beanDescriptor = validator.getConstraintsForClass(Package.class);
        Assert.assertTrue((boolean)beanDescriptor.isBeanConstrained(), (String)"The bean should be constrained");
        Assert.assertEquals((int)beanDescriptor.getConstraintsForProperty("maxWeight").getConstraintDescriptors().size(), (int)2, (String)"With xml configuration there should be two constraints.");
        Configuration<?> config = TestUtil.getConfigurationUnderTest();
        config.ignoreXmlConfiguration();
        validator = config.buildValidatorFactory().getValidator();
        beanDescriptor = validator.getConstraintsForClass(Package.class);
        Assert.assertTrue((boolean)beanDescriptor.isBeanConstrained(), (String)"Without xml there should be only one constraint.");
        Assert.assertEquals((int)beanDescriptor.getConstraintsForProperty("maxWeight").getConstraintDescriptors().size(), (int)1, (String)"Without xml there should be only one constraint.");
    }

    @Test
    @SpecAssertion(section="7.1.1.1", id="e")
    public void testDefaultGroupDefinitionDefinedInEntityApplies() {
        Validator validator = TestUtil.getValidatorUnderTest();
        Package p = new Package();
        p.setMaxWeight(30);
        Set violations = validator.validate((Object)p, new Class[]{Default.class});
        TestUtil.assertCorrectNumberOfViolations(violations, 1);
        TestUtil.assertCorrectConstraintViolationMessages(violations, "ValidPackage defined as annotation");
    }
}

