/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.metadata;

import java.util.Map;
import java.util.Set;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.validation.groups.Default;
import javax.validation.metadata.ConstraintDescriptor;
import org.hibernate.beanvalidation.tck.tests.metadata.Man;
import org.hibernate.beanvalidation.tck.tests.metadata.NotEmpty;
import org.hibernate.beanvalidation.tck.tests.metadata.Order;
import org.hibernate.beanvalidation.tck.tests.metadata.Person;
import org.hibernate.beanvalidation.tck.tests.metadata.Severity;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="1.1.0")
public class ConstraintDescriptorTest
extends Arquillian {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClass(ConstraintDescriptorTest.class)).withClasses(Order.class, Person.class, Man.class, Severity.class, NotEmpty.class)).build();
    }

    @Test
    @SpecAssertion(section="5.5", id="k")
    public void testReportAsSingleViolation() {
        ConstraintDescriptor<?> descriptor = this.getConstraintDescriptor(Order.class, "orderNumber");
        Assert.assertFalse((boolean)descriptor.isReportAsSingleViolation());
        descriptor = this.getConstraintDescriptor(Person.class, "firstName");
        Assert.assertTrue((boolean)descriptor.isReportAsSingleViolation());
    }

    @Test
    @SpecAssertion(section="5.5", id="l")
    public void testEmptyComposingConstraints() {
        ConstraintDescriptor<?> descriptor = this.getConstraintDescriptor(Order.class, "orderNumber");
        Assert.assertTrue((boolean)descriptor.getComposingConstraints().isEmpty());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="5.5", id="a"), @SpecAssertion(section="5.5", id="c")})
    public void testAnnotationAndMapParametersReflectParameterOverriding() {
        ConstraintDescriptor<?> descriptor = this.getConstraintDescriptor(Person.class, "firstName");
        Set composingDescriptors = descriptor.getComposingConstraints();
        Assert.assertEquals((int)composingDescriptors.size(), (int)2, (String)"Wrong number of composing constraints");
        boolean hasSize = false;
        for (ConstraintDescriptor desc : composingDescriptors) {
            if (desc.getAnnotation().annotationType().equals(Size.class)) {
                hasSize = true;
                Size sizeAnn = (Size)desc.getAnnotation();
                Assert.assertEquals((int)sizeAnn.min(), (int)5, (String)"The min parameter should reflect the overridden parameter");
                Assert.assertEquals(desc.getAttributes().get("min"), (Object)5, (String)"The min parameter should reflect the overridden parameter");
                continue;
            }
            if (desc.getAnnotation().annotationType().equals(NotNull.class)) continue;
            Assert.fail((String)"Unexpected annotation.");
        }
        Assert.assertTrue((boolean)hasSize, (String)"Size composed annotation not found");
    }

    @Test
    @SpecAssertion(section="5.5", id="b")
    public void testGetAttributesFromConstraintDescriptor() {
        ConstraintDescriptor<?> descriptor = this.getConstraintDescriptor(Order.class, "orderNumber");
        Map attributes = descriptor.getAttributes();
        Assert.assertTrue((boolean)attributes.containsKey("message"));
        Assert.assertTrue((boolean)attributes.containsKey("groups"));
    }

    @Test
    @SpecAssertion(section="5.5", id="d")
    public void testGetGroups() {
        ConstraintDescriptor<?> descriptor = this.getConstraintDescriptor(Person.class, "firstName");
        Set groups = descriptor.getGroups();
        Assert.assertTrue((groups.size() == 1 ? 1 : 0) != 0);
        Assert.assertEquals(groups.iterator().next(), Person.PersonValidation.class, (String)"Wrong group");
    }

    @Test
    @SpecAssertion(section="5.5", id="d")
    public void testGetGroupsOnInterface() {
        ConstraintDescriptor<?> descriptor = this.getConstraintDescriptor(Person.class, "lastName");
        Set groups = descriptor.getGroups();
        Assert.assertTrue((groups.size() == 1 ? 1 : 0) != 0);
        Assert.assertEquals(groups.iterator().next(), Default.class, (String)"Wrong group");
    }

    @Test
    @SpecAssertion(section="5.5", id="d")
    public void testGetGroupsWithImplicitGroup() {
        ConstraintDescriptor<?> descriptor = this.getConstraintDescriptor(Man.class, "lastName");
        Set groups = descriptor.getGroups();
        Assert.assertTrue((groups.size() == 2 ? 1 : 0) != 0);
        for (Class group : groups) {
            if (group.equals(Default.class) || group.equals(Person.class)) continue;
            Assert.fail((String)"Invalid group.");
        }
    }

    @Test
    @SpecAssertion(section="5.5", id="e")
    public void testDefaultGroupIsReturnedIfNoGroupSpecifiedInDeclaration() {
        ConstraintDescriptor<?> descriptor = this.getConstraintDescriptor(Order.class, "orderNumber");
        Set groups = descriptor.getGroups();
        Assert.assertTrue((groups.size() == 1 ? 1 : 0) != 0);
        Assert.assertEquals(groups.iterator().next(), Default.class, (String)"Wrong group");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="5.5", id="f"), @SpecAssertion(section="5.5", id="l")})
    public void testComposingConstraints() {
        ConstraintDescriptor<?> descriptor = this.getConstraintDescriptor(Person.class, "firstName");
        Set composingDescriptors = descriptor.getComposingConstraints();
        Assert.assertEquals((int)composingDescriptors.size(), (int)2, (String)"Wrong number of composing constraints");
        for (ConstraintDescriptor desc : composingDescriptors) {
            Assert.assertTrue((desc.getGroups().size() == 1 ? 1 : 0) != 0);
            Assert.assertEquals(desc.getGroups().iterator().next(), Person.PersonValidation.class, (String)"Wrong group");
        }
    }

    @Test
    @SpecAssertion(section="5.5", id="g")
    public void testPayload() {
        ConstraintDescriptor<?> descriptor = this.getConstraintDescriptor(Person.class, "firstName");
        Set payload = descriptor.getPayload();
        Assert.assertTrue((payload.size() == 1 ? 1 : 0) != 0);
        Assert.assertEquals(payload.iterator().next(), Severity.Info.class, (String)"Wrong payload");
        descriptor = this.getConstraintDescriptor(Order.class, "orderNumber");
        payload = descriptor.getPayload();
        Assert.assertTrue((payload != null ? 1 : 0) != 0);
        Assert.assertTrue((payload.size() == 0 ? 1 : 0) != 0);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="5.5", id="h"), @SpecAssertion(section="5.5", id="i")})
    public void testComposingConstraintsPayload() {
        ConstraintDescriptor<?> descriptor = this.getConstraintDescriptor(Person.class, "firstName");
        Set composingDescriptors = descriptor.getComposingConstraints();
        Assert.assertEquals((int)composingDescriptors.size(), (int)2, (String)"Wrong number of composing constraints");
        for (ConstraintDescriptor desc : composingDescriptors) {
            Assert.assertTrue((desc.getGroups().size() == 1 ? 1 : 0) != 0);
            Assert.assertEquals(desc.getPayload().iterator().next(), Severity.Info.class, (String)"Wrong payload");
        }
    }

    private ConstraintDescriptor<?> getConstraintDescriptor(Class<?> clazz, String property) {
        Set<ConstraintDescriptor<?>> descriptors = TestUtil.getConstraintDescriptorsFor(clazz, property);
        Assert.assertTrue((descriptors.size() == 1 ? 1 : 0) != 0, (String)"There should only by one descriptor.");
        return descriptors.iterator().next();
    }
}

