/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.constraints.inheritance;

import java.lang.annotation.Annotation;
import javax.validation.Validator;
import javax.validation.constraints.NotNull;
import javax.validation.metadata.BeanDescriptor;
import javax.validation.metadata.ConstraintDescriptor;
import javax.validation.metadata.PropertyDescriptor;
import org.hibernate.beanvalidation.tck.tests.constraints.inheritance.Bar;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="1.1.0")
public class ConstraintInheritanceTest
extends Arquillian {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(ConstraintInheritanceTest.class)).build();
    }

    @Test
    @SpecAssertion(section="3.3", id="b")
    public void testConstraintsOnSuperClassAreInherited() {
        String propertyName;
        Validator validator = TestUtil.getValidatorUnderTest();
        BeanDescriptor beanDescriptor = validator.getConstraintsForClass(Bar.class);
        Assert.assertTrue((beanDescriptor.getConstraintsForProperty(propertyName = "foo") != null ? 1 : 0) != 0);
        PropertyDescriptor propDescriptor = beanDescriptor.getConstraintsForProperty(propertyName);
        Annotation constraintAnnotation = ((ConstraintDescriptor)propDescriptor.getConstraintDescriptors().iterator().next()).getAnnotation();
        Assert.assertTrue((constraintAnnotation.annotationType() == NotNull.class ? 1 : 0) != 0);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="3.3", id="a"), @SpecAssertion(section="3.3", id="b")})
    public void testConstraintsOnInterfaceAreInherited() {
        String propertyName;
        Validator validator = TestUtil.getValidatorUnderTest();
        BeanDescriptor beanDescriptor = validator.getConstraintsForClass(Bar.class);
        Assert.assertTrue((beanDescriptor.getConstraintsForProperty(propertyName = "fubar") != null ? 1 : 0) != 0);
        PropertyDescriptor propDescriptor = beanDescriptor.getConstraintsForProperty(propertyName);
        Annotation constraintAnnotation = ((ConstraintDescriptor)propDescriptor.getConstraintDescriptors().iterator().next()).getAnnotation();
        Assert.assertTrue((constraintAnnotation.annotationType() == NotNull.class ? 1 : 0) != 0);
    }
}

