/*
 * Decompiled with CFR 0.152.
 */
package org.hertsstack.broker;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import io.grpc.stub.StreamObserver;
import java.util.concurrent.TimeUnit;
import org.hertsstack.broker.ReactiveStreamingCache;

public class ReactiveStreamingCacheImpl<T>
implements ReactiveStreamingCache<T> {
    private final Cache<String, T> receivers = CacheBuilder.newBuilder().expireAfterWrite(10L, TimeUnit.MINUTES).build();
    private final Cache<String, StreamObserver<Object>> observers = CacheBuilder.newBuilder().expireAfterWrite(10L, TimeUnit.MINUTES).build();
    private final Cache<String, String> clientId = CacheBuilder.newBuilder().expireAfterAccess(30L, TimeUnit.DAYS).build();
    private static ReactiveStreamingCacheImpl thisClass;

    private ReactiveStreamingCacheImpl() {
    }

    public static <T> ReactiveStreamingCache<T> getInstance() {
        if (thisClass != null) {
            return thisClass;
        }
        thisClass = new ReactiveStreamingCacheImpl<T>();
        return thisClass;
    }

    @Override
    public void setObserver(String clientId, StreamObserver<Object> observer) {
        this.observers.put((Object)clientId, observer);
    }

    @Override
    public StreamObserver<Object> getObserver(String clientId) {
        return (StreamObserver)this.observers.getIfPresent((Object)clientId);
    }

    @Override
    public boolean removeObserver(String clientId) {
        this.observers.invalidate((Object)clientId);
        return true;
    }

    @Override
    public void setClientId(String clientId) {
        this.clientId.put((Object)clientId, (Object)clientId);
    }

    @Override
    public String getClientId(String clientId) {
        return (String)this.clientId.getIfPresent((Object)clientId);
    }

    @Override
    public String[] getClientIds() {
        return this.clientId.asMap().keySet().toArray(new String[0]);
    }

    @Override
    public void setHertsReceiver(String clientId, T receiver) {
        this.receivers.put((Object)clientId, receiver);
    }

    @Override
    public T getHertsReceiver(String clientId) {
        return (T)this.receivers.getIfPresent((Object)clientId);
    }
}

