/*
 * Decompiled with CFR 0.152.
 */
package herddb.utils;

import herddb.utils.SizeAwareObject;
import java.nio.charset.StandardCharsets;

public final class Sized<O extends Comparable<O>>
implements SizeAwareObject,
Comparable<Sized<O>> {
    private static final long DEFAULT_SIZE = 100L;
    public final O dummy;
    public final long size;

    public static <X extends Comparable<X>> Sized<X> valueOf(X x) {
        return new Sized<X>(x, 100L);
    }

    public static Sized<Integer> valueOf(Integer x) {
        return new Sized<Integer>(x, 4L);
    }

    public static Sized<Long> valueOf(Long x) {
        return new Sized<Long>(x, 8L);
    }

    public static Sized<String> valueOf(String x) {
        return new Sized<String>(x, x.getBytes(StandardCharsets.UTF_16BE).length);
    }

    private Sized(O dummy, long size) {
        this.dummy = dummy;
        this.size = size;
    }

    @Override
    public long getEstimatedSize() {
        return this.size;
    }

    @Override
    public int compareTo(Sized<O> o) {
        return this.dummy.compareTo(o.dummy);
    }

    public String toString() {
        return this.dummy.toString();
    }

    public int hashCode() {
        return this.dummy.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Sized) {
            return this.dummy.equals(((Sized)obj).dummy);
        }
        return false;
    }
}

