/*
 * Decompiled with CFR 0.152.
 */
package herddb.utils;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.InputStream;

@SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
public final class SimpleByteArrayInputStream
extends InputStream {
    private final byte[] buf;
    private final int end;
    private int pos;

    public SimpleByteArrayInputStream(byte[] buf) {
        this.buf = buf;
        this.pos = 0;
        this.end = buf.length;
    }

    public SimpleByteArrayInputStream(byte[] buf, int offset, int length) {
        this.buf = buf;
        this.pos = offset;
        this.end = offset + length;
    }

    @Override
    public int read() {
        return this.pos < this.end ? this.buf[this.pos++] & 0xFF : -1;
    }

    @Override
    public int read(byte[] b, int off, int len) {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (this.pos >= this.end) {
            return -1;
        }
        int avail = this.end - this.pos;
        if (len > avail) {
            len = avail;
        }
        if (len <= 0) {
            return 0;
        }
        System.arraycopy(this.buf, this.pos, b, off, len);
        this.pos += len;
        return len;
    }

    @Override
    public int available() {
        return this.end - this.pos;
    }
}

