/*
 * Decompiled with CFR 0.152.
 */
package herddb.utils;

import herddb.core.HerdDBInternalException;
import herddb.utils.Bytes;
import herddb.utils.RawString;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public interface SQLRecordPredicateFunctions {
    public static boolean toBoolean(Object result) {
        if (result == null) {
            return false;
        }
        if (result instanceof Boolean) {
            return (Boolean)result;
        }
        return "true".equalsIgnoreCase(result.toString());
    }

    public static int compareNullTo(Object b) {
        if (b == null) {
            return 0;
        }
        return 1;
    }

    public static CompareResult compareConsiderNull(Object a, Object b) {
        if (a == null || b == null) {
            return CompareResult.NULL;
        }
        if (a instanceof RawString) {
            if (b instanceof RawString) {
                return CompareResult.fromInt(((RawString)a).compareTo((RawString)b));
            }
            if (b instanceof String) {
                return CompareResult.fromInt(((RawString)a).compareToString((String)b));
            }
        }
        if (a instanceof String && b instanceof RawString) {
            return CompareResult.fromInt(-((RawString)b).compareToString((String)a));
        }
        if (a instanceof Integer) {
            if (b instanceof Integer) {
                return CompareResult.fromInt((Integer)a - (Integer)b);
            }
            if (b instanceof Long) {
                long delta = (long)((Integer)a).intValue() - (Long)b;
                return CompareResult.fromLong(delta);
            }
        }
        if (a instanceof Long) {
            if (b instanceof Long) {
                long delta = (Long)a - (Long)b;
                return CompareResult.fromLong(delta);
            }
            if (b instanceof Date) {
                long delta = (Long)a - ((Date)b).getTime();
                return CompareResult.fromLong(delta);
            }
        }
        if (a instanceof Number && b instanceof Number) {
            return CompareResult.fromInt(Double.compare(((Number)a).doubleValue(), ((Number)b).doubleValue()));
        }
        if (a instanceof Date) {
            if (b instanceof Date) {
                long delta = ((Date)a).getTime() - ((Date)b).getTime();
                return CompareResult.fromInt(delta == 0L ? 0 : (delta > 0L ? 1 : -1));
            }
            if (b instanceof Long) {
                long delta = ((Date)a).getTime() - (Long)b;
                return CompareResult.fromInt(delta == 0L ? 0 : (delta > 0L ? 1 : -1));
            }
        }
        if (a instanceof Comparable && b instanceof Comparable && a.getClass() == b.getClass()) {
            return CompareResult.fromInt(((Comparable)a).compareTo(b));
        }
        if (a instanceof byte[] && b instanceof byte[]) {
            return CompareResult.fromInt(Bytes.compare((byte[])a, (byte[])b));
        }
        if (a instanceof float[] && b instanceof float[]) {
            return CompareResult.fromInt(SQLRecordPredicateFunctions.compareFloatArrays((float[])a, (float[])b));
        }
        throw new IllegalArgumentException("uncomparable objects " + a.getClass() + " ('" + a + "') vs " + b.getClass() + " ('" + b + "')");
    }

    public static int compareFloatArrays(float[] arr1, float[] arr2) {
        int minLength = Math.min(arr1.length, arr2.length);
        for (int i = 0; i < minLength; ++i) {
            int comparison = Float.compare(arr1[i], arr2[i]);
            if (comparison == 0) continue;
            return comparison;
        }
        return Integer.compare(arr1.length, arr2.length);
    }

    public static int compare(Object a, Object b) {
        if (a == null) {
            if (b == null) {
                return 0;
            }
            return 1;
        }
        if (b == null) {
            return -1;
        }
        if (a instanceof RawString) {
            if (b instanceof RawString) {
                return ((RawString)a).compareTo((RawString)b);
            }
            if (b instanceof String) {
                return ((RawString)a).compareToString((String)b);
            }
        }
        if (a instanceof String && b instanceof RawString) {
            return -((RawString)b).compareToString((String)a);
        }
        if (a instanceof Integer) {
            if (b instanceof Integer) {
                return (Integer)a - (Integer)b;
            }
            if (b instanceof Long) {
                long delta = (long)((Integer)a).intValue() - (Long)b;
                return delta == 0L ? 0 : (delta > 0L ? 1 : -1);
            }
        }
        if (a instanceof Long) {
            if (b instanceof Long) {
                long delta = (Long)a - (Long)b;
                return delta == 0L ? 0 : (delta > 0L ? 1 : -1);
            }
            if (b instanceof Date) {
                long delta = (Long)a - ((Date)b).getTime();
                return delta == 0L ? 0 : (delta > 0L ? 1 : -1);
            }
        }
        if (a instanceof Number && b instanceof Number) {
            return Double.compare(((Number)a).doubleValue(), ((Number)b).doubleValue());
        }
        if (a instanceof Date) {
            if (b instanceof Date) {
                long delta = ((Date)a).getTime() - ((Date)b).getTime();
                return delta == 0L ? 0 : (delta > 0L ? 1 : -1);
            }
            if (b instanceof Long) {
                long delta = ((Date)a).getTime() - (Long)b;
                return delta == 0L ? 0 : (delta > 0L ? 1 : -1);
            }
        }
        if (a instanceof Comparable && b instanceof Comparable && a.getClass() == b.getClass()) {
            return ((Comparable)a).compareTo(b);
        }
        if (a instanceof byte[] && b instanceof byte[]) {
            return Bytes.compare((byte[])a, (byte[])b);
        }
        throw new IllegalArgumentException("uncomparable objects " + a.getClass() + " ('" + a + "') vs " + b.getClass() + " ('" + b + "')");
    }

    public static Object add(Object a, Object b) throws IllegalArgumentException {
        if (a == null && b == null) {
            return null;
        }
        if (a == null) {
            a = 0;
        }
        if (b == null) {
            b = 0;
        }
        if (a instanceof Long && b instanceof Long) {
            return (Long)a + (Long)b;
        }
        if (a instanceof Integer && b instanceof Integer) {
            return (long)((Integer)a + (Integer)b);
        }
        if (a instanceof Integer && b instanceof Long) {
            return (long)((Integer)a).intValue() + (Long)b;
        }
        if (a instanceof Long && b instanceof Integer) {
            return (Long)a + (long)((Integer)b).intValue();
        }
        if (a instanceof Number && b instanceof Number) {
            return ((Number)a).doubleValue() + ((Number)b).doubleValue();
        }
        if (a instanceof Timestamp && b instanceof Long) {
            return new Timestamp(((Timestamp)a).getTime() + (Long)b);
        }
        throw new IllegalArgumentException("cannot add " + a + " and " + b);
    }

    public static Object modulo(Object a, Object b) throws IllegalArgumentException {
        if (a == null && b == null) {
            return null;
        }
        if (a == null) {
            a = 0;
        }
        if (b == null) {
            b = 0;
        }
        if (a instanceof Long && b instanceof Long) {
            return (Long)a % (Long)b;
        }
        if (a instanceof Integer && b instanceof Integer) {
            return (long)((Integer)a % (Integer)b);
        }
        if (a instanceof Integer && b instanceof Long) {
            return (long)((Integer)a).intValue() % (Long)b;
        }
        if (a instanceof Long && b instanceof Integer) {
            return (Long)a % (long)((Integer)b).intValue();
        }
        if (a instanceof Number && b instanceof Number) {
            return ((Number)a).doubleValue() % ((Number)b).doubleValue();
        }
        if (a instanceof Timestamp && b instanceof Long) {
            return new Timestamp(((Timestamp)a).getTime() % (Long)b);
        }
        throw new IllegalArgumentException("cannot perform modulo on " + a + " and " + b);
    }

    public static Object subtract(Object a, Object b) throws IllegalArgumentException {
        if (a == null && b == null) {
            return null;
        }
        if (a == null) {
            a = 0;
        }
        if (b == null) {
            b = 0;
        }
        if (a instanceof Long && b instanceof Long) {
            return (Long)a - (Long)b;
        }
        if (a instanceof Integer && b instanceof Integer) {
            return (long)((Integer)a - (Integer)b);
        }
        if (a instanceof Integer && b instanceof Long) {
            return (long)((Integer)a).intValue() - (Long)b;
        }
        if (a instanceof Long && b instanceof Integer) {
            return (Long)a - (long)((Integer)b).intValue();
        }
        if (a instanceof Number && b instanceof Number) {
            return ((Number)a).doubleValue() - ((Number)b).doubleValue();
        }
        if (a instanceof Timestamp && b instanceof Timestamp) {
            return ((Timestamp)a).getTime() - ((Timestamp)b).getTime();
        }
        throw new IllegalArgumentException("cannot subtract " + a + " and " + b);
    }

    public static Object multiply(Object a, Object b) throws IllegalArgumentException {
        if (a == null && b == null) {
            return null;
        }
        if (a == null) {
            a = 0;
        }
        if (b == null) {
            b = 0;
        }
        if (a instanceof Long && b instanceof Long) {
            return (Long)a * (Long)b;
        }
        if (a instanceof Integer && b instanceof Integer) {
            return (long)((Integer)a * (Integer)b);
        }
        if (a instanceof Integer && b instanceof Long) {
            return (long)((Integer)a).intValue() * (Long)b;
        }
        if (a instanceof Long && b instanceof Integer) {
            return (Long)a * (long)((Integer)b).intValue();
        }
        if (a instanceof Number && b instanceof Number) {
            return ((Number)a).doubleValue() * ((Number)b).doubleValue();
        }
        throw new IllegalArgumentException("cannot multiply " + a + " and " + b);
    }

    public static Object divide(Object a, Object b) throws IllegalArgumentException {
        if (a == null && b == null) {
            return null;
        }
        if (a == null) {
            a = 0;
        }
        if (b == null) {
            b = 0;
        }
        if (a instanceof Number && b instanceof Number) {
            return ((Number)a).doubleValue() / ((Number)b).doubleValue();
        }
        throw new IllegalArgumentException("cannot divide " + a + " and " + b);
    }

    public static boolean objectEquals(Object a, Object b) {
        if (a == null || b == null) {
            return a == b;
        }
        if (a instanceof RawString) {
            return a.equals(b);
        }
        if (b instanceof RawString) {
            return b.equals(a);
        }
        if (a instanceof Number && b instanceof Number) {
            return ((Number)a).doubleValue() == ((Number)b).doubleValue();
        }
        if (a instanceof Date && b instanceof Date) {
            return ((Date)a).getTime() == ((Date)b).getTime();
        }
        if (a instanceof Boolean && Boolean.parseBoolean(b.toString()) == (Boolean)a) {
            return true;
        }
        if (b instanceof Boolean && Boolean.parseBoolean(a.toString()) == (Boolean)b) {
            return true;
        }
        return Objects.equals(a, b);
    }

    public static boolean objectNotEquals(Object a, Object b) {
        if (a == null || b == null) {
            return false;
        }
        return !SQLRecordPredicateFunctions.objectEquals(a, b);
    }

    public static Pattern compileLikePattern(String b, char escapeChar) throws HerdDBInternalException {
        StringBuilder builder = new StringBuilder(b.length() + 18);
        builder.append("\\Q");
        int limit = b.length();
        boolean escaping = false;
        block6: for (int idx = 0; idx < limit; ++idx) {
            char ch = b.charAt(idx);
            if (ch == escapeChar) {
                escaping = true;
                continue;
            }
            if (escaping) {
                builder.append(ch);
                escaping = false;
                continue;
            }
            switch (ch) {
                case '%': {
                    builder.append("\\E.*\\Q");
                    continue block6;
                }
                case '_': {
                    builder.append("\\E.{1}\\Q");
                    continue block6;
                }
                default: {
                    builder.append(ch);
                }
            }
        }
        builder.append("\\E");
        String like = builder.toString();
        try {
            return Pattern.compile(like, 32);
        }
        catch (IllegalArgumentException err) {
            throw new HerdDBInternalException("Cannot compile LIKE expression '" + b + "': " + err);
        }
    }

    public static boolean like(Object a, Object b, char escape) {
        if (a == null || b == null) {
            return false;
        }
        Pattern pattern = SQLRecordPredicateFunctions.compileLikePattern(b.toString(), escape);
        return SQLRecordPredicateFunctions.matches(a, pattern);
    }

    public static boolean matches(Object a, Pattern pattern) {
        if (a == null) {
            return false;
        }
        Matcher matcher = pattern.matcher(a.toString());
        return matcher.matches();
    }

    public static enum CompareResult {
        GREATER,
        MINOR,
        EQUALS,
        NULL;


        public static CompareResult fromInt(int i) {
            if (i == 0) {
                return EQUALS;
            }
            if (i > 0) {
                return GREATER;
            }
            return MINOR;
        }

        public static CompareResult fromLong(long i) {
            if (i == 0L) {
                return EQUALS;
            }
            if (i > 0L) {
                return GREATER;
            }
            return MINOR;
        }
    }
}

