/*
 * Decompiled with CFR 0.152.
 */
package herddb.utils;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import herddb.utils.CompareBytesUtils;
import io.netty.util.Recycler;
import java.nio.charset.StandardCharsets;

@SuppressFBWarnings(value={"EI_EXPOSE_REP"})
public class RawString
implements Comparable<RawString> {
    private final Recycler.Handle<RawString> handle;
    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    private byte[] data;
    private int offset;
    private int length;
    private String string;
    private int hashcode;
    public static final RawString EMPTY = RawString.newUnpooledRawString(new byte[0], 0, 0);
    private static final Recycler<RawString> RECYCLER = new Recycler<RawString>(){

        protected RawString newObject(Recycler.Handle<RawString> handle) {
            return new RawString(handle);
        }
    };
    private static final byte[] TRUE = "true".getBytes(StandardCharsets.UTF_8);
    private static final byte[] FALSE = "false".getBytes(StandardCharsets.UTF_8);

    public RawString(Recycler.Handle<RawString> handle) {
        this.handle = handle;
    }

    public static RawString newPooledRawString(byte[] data, int offset, int length, String string) {
        RawString res = (RawString)RECYCLER.get();
        res.data = data;
        res.offset = offset;
        res.length = length;
        res.string = string;
        res.hashcode = -1;
        return res;
    }

    public static RawString newPooledRawString(byte[] data, int offset, int length) {
        RawString res = (RawString)RECYCLER.get();
        res.data = data;
        res.offset = offset;
        res.length = length;
        res.string = null;
        res.hashcode = -1;
        return res;
    }

    public static RawString newUnpooledRawString(byte[] data, int offset, int length) {
        RawString res = new RawString(null);
        res.data = data;
        res.offset = offset;
        res.length = length;
        res.string = null;
        res.hashcode = -1;
        return res;
    }

    public static RawString newUnpooledRawString(byte[] data, int offset, int length, String string) {
        RawString res = new RawString(null);
        res.data = data;
        res.offset = offset;
        res.length = length;
        res.string = string;
        res.hashcode = -1;
        return res;
    }

    public static RawString of(String string) {
        if (string.isEmpty()) {
            return EMPTY;
        }
        byte[] bytes = string.getBytes(StandardCharsets.UTF_8);
        return RawString.newUnpooledRawString(bytes, 0, bytes.length, string);
    }

    public void recycle() {
        if (this.handle != null) {
            this.data = null;
            this.string = null;
            this.handle.recycle((Object)this);
        }
    }

    public int hashCode() {
        if (this.hashcode == -1) {
            this.hashcode = CompareBytesUtils.hashCode(this.data, this.offset, this.length);
        }
        return this.hashcode;
    }

    @SuppressFBWarnings(value={"EQ_CHECK_FOR_OPERAND_NOT_COMPATIBLE_WITH_THIS"})
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof RawString) {
            RawString other = (RawString)obj;
            return this.hashCode() == other.hashCode() && CompareBytesUtils.arraysEquals(this.data, this.offset, this.offset + this.length, other.data, other.offset, other.length + other.offset);
        }
        if (obj instanceof Boolean) {
            boolean b = (Boolean)obj;
            return b ? CompareBytesUtils.arraysEquals(this.data, this.offset, this.length + this.offset, TRUE, 0, 4) : CompareBytesUtils.arraysEquals(this.data, this.offset, this.length + this.offset, FALSE, 0, 5);
        }
        String otherString = obj.toString();
        byte[] other_data = otherString.getBytes(StandardCharsets.UTF_8);
        return CompareBytesUtils.arraysEquals(this.data, this.offset, this.length + this.offset, other_data, 0, other_data.length);
    }

    public String toString() {
        String _string = this.string;
        if (_string != null) {
            return _string;
        }
        this.string = new String(this.data, this.offset, this.length, StandardCharsets.UTF_8);
        return this.string;
    }

    @Override
    public int compareTo(RawString o) {
        return RawString.compareRaw(this.data, this.offset, this.length, o.data, o.offset, o.length);
    }

    public int compareToString(String o) {
        return RawString.compareRaw(this.data, this.offset, this.length, o);
    }

    public static int compareRaw(byte[] left, int offset, int leftlen, byte[] right, int offsetright, int lenright) {
        return CompareBytesUtils.compare(left, offset, leftlen + offset, right, offsetright, lenright + offsetright);
    }

    public static int compareRaw(byte[] left, int offset, int leftlen, RawString other) {
        return CompareBytesUtils.compare(left, offset, leftlen + offset, other.data, other.offset, other.length);
    }

    public static int compareRaw(byte[] left, int offset, int leftlen, String other) {
        byte[] right = other.getBytes(StandardCharsets.UTF_8);
        return CompareBytesUtils.compare(left, offset, leftlen + offset, right, 0, right.length);
    }

    public byte[] getData() {
        return this.data;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLength() {
        return this.length;
    }

    public byte[] toByteArray() {
        if (this.offset == 0 && this.length == this.data.length) {
            return this.data;
        }
        byte[] copy = new byte[this.length];
        System.arraycopy(this.data, this.offset, copy, 0, this.length);
        return copy;
    }
}

