/*
 * Decompiled with CFR 0.152.
 */
package herddb.utils;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import herddb.utils.AbstractDataAccessor;
import herddb.utils.DataAccessor;
import java.util.function.BiConsumer;

@SuppressFBWarnings(value={"EI_EXPOSE_REP", "EI_EXPOSE_REP2"})
public class ProjectedDataAccessor
extends AbstractDataAccessor {
    private final String[] fieldNames;
    private final DataAccessor wrapped;

    public ProjectedDataAccessor(String[] fieldNames, DataAccessor wrapped) {
        this.fieldNames = fieldNames;
        this.wrapped = wrapped;
    }

    @Override
    public Object get(String property) {
        return this.wrapped.get(property);
    }

    @Override
    public String[] getFieldNames() {
        return this.fieldNames;
    }

    @Override
    public void forEach(BiConsumer<String, Object> consumer) {
        for (String fieldName : this.fieldNames) {
            Object value = this.wrapped.get(fieldName);
            consumer.accept(fieldName, value);
        }
    }

    @Override
    public Object get(int index) {
        String fieldName = this.fieldNames[index];
        return this.wrapped.get(fieldName);
    }

    @Override
    public Object[] getValues() {
        Object[] data = new Object[this.fieldNames.length];
        for (int i = 0; i < this.fieldNames.length; ++i) {
            data[i] = this.wrapped.get(this.fieldNames[i]);
        }
        return data;
    }

    public DataAccessor getWrapped() {
        return this.wrapped;
    }
}

