/*
 * Decompiled with CFR 0.152.
 */
package herddb.utils;

import herddb.utils.OpenFileUtils;
import io.netty.util.internal.PlatformDependent;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;

public class ODirectFileInputStream
extends InputStream {
    private final ByteBuffer originalBuffer;
    private final ByteBuffer block;
    private final FileChannel fc;
    private final int alignment;
    private final int fetchSize;
    private final int batchBlocks;
    private int readBlocks;
    private static final int EOF = -1;
    private boolean eof;

    public ODirectFileInputStream(Path path) throws IOException {
        this(path, 1);
    }

    public ODirectFileInputStream(Path path, int batchBlocks) throws IOException {
        this.fc = OpenFileUtils.openFileChannelWithO_DIRECT(path, StandardOpenOption.READ);
        this.batchBlocks = batchBlocks;
        try {
            this.alignment = (int)OpenFileUtils.getBlockSize(path);
        }
        catch (IOException err) {
            this.fc.close();
            throw err;
        }
        this.fetchSize = this.alignment * batchBlocks;
        this.originalBuffer = ByteBuffer.allocateDirect(this.fetchSize + this.fetchSize);
        this.block = OpenFileUtils.alignedSlice(this.originalBuffer, this.alignment);
        this.eof = false;
        ((Buffer)this.block).position(0);
        ((Buffer)this.block).limit(this.alignment);
        ((Buffer)this.block).flip();
    }

    public int getAlignment() {
        return this.alignment;
    }

    public int getReadBlocks() {
        return this.readBlocks;
    }

    public int getBatchBlocks() {
        return this.batchBlocks;
    }

    public FileChannel getFileChannel() {
        return this.fc;
    }

    @Override
    public int read() throws IOException {
        if (this.block.remaining() == 0) {
            if (this.eof) {
                return -1;
            }
            this.fill();
            if (this.eof && !this.block.hasRemaining()) {
                return -1;
            }
        }
        return this.block.get() & 0xFF;
    }

    private void fill() throws IOException {
        ((Buffer)this.block).position(0);
        ((Buffer)this.block).limit(this.fetchSize);
        int read = this.fc.read(this.block);
        ((Buffer)this.block).flip();
        if (read > -1) {
            this.readBlocks += this.batchBlocks;
        }
        if (read < this.fetchSize) {
            this.eof = true;
        }
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int buflen;
        if ((off | len | off + len | b.length - (off + len)) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        for (int read = 0; read < len; read += buflen) {
            if (this.eof && !this.block.hasRemaining()) {
                if (read > 0) {
                    return read;
                }
                return -1;
            }
            int remaining = this.block.remaining();
            if (remaining < 1) {
                this.fill();
                remaining = this.block.remaining();
            }
            buflen = Math.min(len - read, remaining);
            this.block.get(b, off + read, buflen);
        }
        return len;
    }

    @Override
    public int available() throws IOException {
        return this.block.remaining();
    }

    @Override
    public void close() throws IOException {
        this.fc.close();
        PlatformDependent.freeDirectBuffer((ByteBuffer)this.originalBuffer);
    }
}

