/*
 * Decompiled with CFR 0.152.
 */
package herddb.utils;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import herddb.utils.AbstractDataAccessor;
import java.util.Map;
import java.util.function.BiConsumer;

@SuppressFBWarnings(value={"EI_EXPOSE_REP2", "EI_EXPOSE_REP"})
public class MapDataAccessor
extends AbstractDataAccessor {
    private final Map<String, Object> map;
    private final String[] fieldNames;

    public MapDataAccessor(Map<String, Object> map, String[] fieldNames) {
        this.map = map;
        this.fieldNames = fieldNames;
    }

    @Override
    public String[] getFieldNames() {
        return this.fieldNames;
    }

    @Override
    public void forEach(BiConsumer<String, Object> consumer) {
        for (String columnName : this.fieldNames) {
            Object value = this.map.get(columnName);
            if (value == null) continue;
            consumer.accept(columnName, value);
        }
    }

    @Override
    public Object get(String property) {
        return this.map.get(property);
    }

    @Override
    public Map<String, Object> toMap() {
        return this.map;
    }
}

