/*
 * Decompiled with CFR 0.152.
 */
package herddb.utils;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.EnumSet;
import java.util.Set;

public class ManagedFile
implements AutoCloseable {
    private final FileChannel channel;
    private final OutputStream stream;
    private final boolean requirefsync;
    private static final Set<StandardOpenOption> DEFAULT_OPTIONS_SET = EnumSet.of(StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);
    private static final StandardOpenOption[] DEFAULT_OPTIONS = DEFAULT_OPTIONS_SET.toArray(new StandardOpenOption[DEFAULT_OPTIONS_SET.size()]);

    private ManagedFile(FileChannel channel, boolean requirefsync) {
        this.channel = channel;
        this.stream = Channels.newOutputStream(channel);
        this.requirefsync = requirefsync;
    }

    public static ManagedFile open(Path path, boolean requirefsync) throws IOException {
        return ManagedFile.open(FileChannel.open(path, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE), requirefsync);
    }

    public static ManagedFile open(Path path, boolean requirefsync, StandardOpenOption ... options) throws IOException {
        return ManagedFile.open(FileChannel.open(path, options == null || options.length < 1 ? DEFAULT_OPTIONS : options), requirefsync);
    }

    public static ManagedFile open(Path path, boolean requirefsync, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        return ManagedFile.open(FileChannel.open(path, options == null || options.size() < 1 ? DEFAULT_OPTIONS_SET : options, attrs), requirefsync);
    }

    public static ManagedFile open(FileChannel channel, boolean requirefsync) throws IOException {
        return new ManagedFile(channel, requirefsync);
    }

    public void sync() throws IOException {
        if (!this.requirefsync) {
            return;
        }
        this.channel.force(false);
    }

    public void sync(boolean metaData) throws IOException {
        if (!this.requirefsync) {
            return;
        }
        this.channel.force(metaData);
    }

    public OutputStream getOutputStream() {
        return this.stream;
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
    }
}

