/*
 * Decompiled with CFR 0.152.
 */
package herddb.utils;

public abstract class InstrumentationUtils {
    private static Listener[] listeners = new Listener[0];

    private InstrumentationUtils() {
    }

    public static void instrument(String id, Object ... args) {
        try {
            for (Listener l : listeners) {
                l.run(id, args);
            }
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public static void addListener(Listener l) {
        Listener[] copy = new Listener[listeners.length + 1];
        System.arraycopy(listeners, 0, copy, 0, listeners.length);
        copy[copy.length - 1] = l;
        listeners = copy;
    }

    public static void clear() {
        listeners = new Listener[0];
    }

    public static interface Listener {
        public void run(String var1, Object ... var2);
    }
}

