/*
 * Decompiled with CFR 0.152.
 */
package herddb.utils;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import herddb.utils.Bytes;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ExtendedDataInputStream
extends DataInputStream {
    private boolean eof;
    private static final byte[] EMPTY_ARRAY = new byte[0];

    public ExtendedDataInputStream(InputStream in) {
        super(in);
    }

    public int readVInt() throws IOException {
        return this.readVInt(this.readByte());
    }

    protected int readVInt(byte first) throws IOException {
        byte b = first;
        int i = b & 0x7F;
        if ((b & 0x80) != 0) {
            b = this.readByte();
            i |= (b & 0x7F) << 7;
            if ((b & 0x80) != 0) {
                b = this.readByte();
                i |= (b & 0x7F) << 14;
                if ((b & 0x80) != 0) {
                    b = this.readByte();
                    i |= (b & 0x7F) << 21;
                    if ((b & 0x80) != 0) {
                        b = this.readByte();
                        i |= (b & 0x7F) << 28;
                    }
                }
            }
        }
        return i;
    }

    public boolean isEof() {
        return this.eof;
    }

    public int readVIntNoEOFException() throws IOException {
        int ch = this.in.read();
        if (ch < 0) {
            this.eof = true;
            return -1;
        }
        return this.readVInt((byte)ch);
    }

    public long readVLong() throws IOException {
        return this.readVLong(false);
    }

    private long readVLong(boolean allowNegative) throws IOException {
        byte b = this.readByte();
        if (b >= 0) {
            return b;
        }
        long i = (long)b & 0x7FL;
        b = this.readByte();
        i |= ((long)b & 0x7FL) << 7;
        if (b >= 0) {
            return i;
        }
        b = this.readByte();
        i |= ((long)b & 0x7FL) << 14;
        if (b >= 0) {
            return i;
        }
        b = this.readByte();
        i |= ((long)b & 0x7FL) << 21;
        if (b >= 0) {
            return i;
        }
        b = this.readByte();
        i |= ((long)b & 0x7FL) << 28;
        if (b >= 0) {
            return i;
        }
        b = this.readByte();
        i |= ((long)b & 0x7FL) << 35;
        if (b >= 0) {
            return i;
        }
        b = this.readByte();
        i |= ((long)b & 0x7FL) << 42;
        if (b >= 0) {
            return i;
        }
        b = this.readByte();
        i |= ((long)b & 0x7FL) << 49;
        if (b >= 0) {
            return i;
        }
        b = this.readByte();
        i |= ((long)b & 0x7FL) << 56;
        if (b >= 0) {
            return i;
        }
        if (allowNegative) {
            b = this.readByte();
            i |= ((long)b & 0x7FL) << 63;
            if (b == 0 || b == 1) {
                return i;
            }
            throw new IOException("Invalid vLong detected (more than 64 bits)");
        }
        throw new IOException("Invalid vLong detected (negative values disallowed)");
    }

    public int readZInt() throws IOException {
        int i = this.readVInt();
        return i >>> 1 ^ -(i & 1);
    }

    public long readZLong() throws IOException {
        long l = this.readVLong();
        return l >>> 1 ^ -(l & 1L);
    }

    public Bytes readBytes() throws IOException {
        return Bytes.from_nullable_array(this.readArray());
    }

    public byte[] readArray() throws IOException {
        int len = this.readVInt();
        if (len == 0) {
            return EMPTY_ARRAY;
        }
        if (len == -1) {
            return null;
        }
        byte[] res = new byte[len];
        this.readFully(res);
        return res;
    }

    @SuppressFBWarnings(value={"SR_NOT_CHECKED"})
    public void skipArray() throws IOException {
        int len = this.readVInt();
        if (len == 0) {
            return;
        }
        this.skip(len);
    }

    @SuppressFBWarnings(value={"SR_NOT_CHECKED"})
    public void skipInt() throws IOException {
        this.skip(4L);
    }

    @SuppressFBWarnings(value={"SR_NOT_CHECKED"})
    public void skipLong() throws IOException {
        this.skip(8L);
    }

    @SuppressFBWarnings(value={"SR_NOT_CHECKED"})
    public void skipDouble() throws IOException {
        this.skip(8L);
    }

    @SuppressFBWarnings(value={"SR_NOT_CHECKED"})
    public void skipBoolean() throws IOException {
        this.skip(1L);
    }
}

