/*
 * Decompiled with CFR 0.152.
 */
package herddb.utils;

import herddb.core.HerdDBInternalException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;

public class BatchOrderedExecutor<T>
implements Consumer<T> {
    private ArrayList<T> batch;
    private final int batchsize;
    private int partialcount = 0;
    private final Executor<T> executor;
    private final Comparator<T> bufferComparator;

    public BatchOrderedExecutor(int batchsize, Executor<T> executor, Comparator<T> bufferComparator) {
        this.batchsize = batchsize;
        this.batch = new ArrayList();
        this.executor = executor;
        this.bufferComparator = bufferComparator;
    }

    @Override
    public void accept(T object) {
        this.batch.add(object);
        if (++this.partialcount == this.batchsize) {
            try {
                this.batch.sort(this.bufferComparator);
                this.executor.execute(this.batch);
            }
            finally {
                this.batch.clear();
                this.partialcount = 0;
            }
        }
    }

    public void finish() throws HerdDBInternalException {
        block6: {
            try {
                if (this.batch.isEmpty()) break block6;
                try {
                    this.batch.sort(this.bufferComparator);
                    this.executor.execute(this.batch);
                }
                finally {
                    this.batch.clear();
                    this.partialcount = 0;
                }
            }
            finally {
                this.batch = null;
            }
        }
    }

    public static interface Executor<V> {
        public void execute(List<V> var1) throws HerdDBInternalException;
    }
}

