/*
 * Decompiled with CFR 0.152.
 */
package herddb.core;

import herddb.core.Page;
import herddb.core.PageReplacementPolicy;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class RandomPageReplacementPolicy
implements PageReplacementPolicy {
    private final PlainMetadata[] pages;
    private final Map<PlainMetadata, Integer> positions;
    private final Random random;
    private final Lock lock = new ReentrantLock();

    public RandomPageReplacementPolicy(int size) {
        this(size, new Random());
    }

    public RandomPageReplacementPolicy(int size, Random random) {
        this.random = random;
        this.pages = new PlainMetadata[size];
        this.positions = new HashMap<PlainMetadata, Integer>(size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PlainMetadata add(Page<?> page) {
        PlainMetadata metadata = new PlainMetadata(page);
        page.metadata = metadata;
        this.lock.lock();
        try {
            int count = this.positions.size();
            if (count < this.pages.length) {
                this.pages[count] = metadata;
                this.positions.put(metadata, count);
                PlainMetadata plainMetadata = null;
                return plainMetadata;
            }
            int position = this.random.nextInt(count);
            PlainMetadata old = this.pages[position];
            this.positions.remove(old);
            this.pages[position] = metadata;
            this.positions.put(metadata, position);
            PlainMetadata plainMetadata = old;
            return plainMetadata;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PlainMetadata pop() {
        this.lock.lock();
        try {
            int count = this.positions.size();
            int position = this.random.nextInt(count);
            PlainMetadata old = this.pages[position];
            this.positions.remove(old);
            if (count > 0) {
                PlainMetadata moving;
                this.pages[position] = moving = this.pages[count - 1];
                this.positions.put(moving, position);
            }
            PlainMetadata plainMetadata = old;
            return plainMetadata;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int size() {
        return this.positions.size();
    }

    @Override
    public int capacity() {
        return this.pages.length;
    }

    @Override
    public <P extends Page<?>> void remove(Collection<P> pages) {
        for (Page page : pages) {
            this.remove(page);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Page<?> page) {
        PlainMetadata metadata = (PlainMetadata)page.metadata;
        this.lock.lock();
        try {
            Integer position = this.positions.remove(metadata);
            if (position == null) {
                boolean bl = false;
                return bl;
            }
            int count = this.positions.size();
            if (position == count) {
                this.pages[count] = null;
            } else {
                PlainMetadata moving;
                this.pages[position.intValue()] = moving = this.pages[count];
                this.pages[count] = null;
                this.positions.put(moving, position);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void clear() {
        this.lock.lock();
        try {
            this.positions.clear();
            for (int i = 0; i < this.pages.length; ++i) {
                this.pages[i] = null;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void pageHit(Page<?> page) {
    }

    private static class PlainMetadata
    extends Page.Metadata {
        private final int hashcode;

        public PlainMetadata(Page<?> datapage) {
            this((Page.Owner)datapage.owner, datapage.pageId);
        }

        public PlainMetadata(Page.Owner owner, long pageId) {
            super(owner, pageId);
            this.hashcode = Objects.hash(owner, pageId);
        }

        public int hashCode() {
            return this.hashcode;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof PlainMetadata)) {
                return false;
            }
            PlainMetadata other = (PlainMetadata)obj;
            if (this.owner == null ? other.owner != null : !this.owner.equals(other.owner)) {
                return false;
            }
            return this.pageId == other.pageId;
        }

        public String toString() {
            return "PlainMetadata {pageId=" + this.pageId + ", owner=" + this.owner + '}';
        }
    }
}

