/*
 * Decompiled with CFR 0.152.
 */
package org.hdiv.web.multipart;

import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.hdiv.config.multipart.exception.HdivMultipartException;
import org.hdiv.web.multipart.MultipartHttpServletRequestWrapper;
import org.springframework.web.multipart.MultipartException;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.support.StandardServletMultipartResolver;
import org.springframework.web.util.WebUtils;

public class HdivStandardServletMultipartResolver
extends StandardServletMultipartResolver {
    public boolean isMultipart(HttpServletRequest request) {
        HdivMultipartException multipartException = (HdivMultipartException)request.getAttribute("org.hdiv.exception.HDIVMultipartException");
        if (multipartException != null) {
            Exception orig = multipartException.getOriginal();
            if (orig instanceof MultipartException) {
                throw (MultipartException)((Object)orig);
            }
            throw new MultipartException("Could not parse multipart servlet request", (Throwable)orig);
        }
        return super.isMultipart(request);
    }

    public MultipartHttpServletRequest resolveMultipart(HttpServletRequest request) throws MultipartException {
        MultipartHttpServletRequest multipartHttpServletRequest = (MultipartHttpServletRequest)WebUtils.getNativeRequest((ServletRequest)request, MultipartHttpServletRequest.class);
        if (multipartHttpServletRequest != null) {
            return new MultipartHttpServletRequestWrapper(request, multipartHttpServletRequest);
        }
        return super.resolveMultipart(request);
    }
}

