/*
 * Decompiled with CFR 0.152.
 */
package org.hdiv.config.multipart;

import java.util.Enumeration;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hdiv.config.multipart.IMultipartConfig;
import org.hdiv.config.multipart.exception.HdivMultipartException;
import org.hdiv.filter.RequestWrapper;
import org.hdiv.web.multipart.HdivCommonsMultipartResolver;
import org.hdiv.web.multipart.HdivStandardServletMultipartResolver;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.multipart.MultipartException;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.MultipartResolver;
import org.springframework.web.servlet.FrameworkServlet;
import org.springframework.web.util.WebUtils;

public class SpringMVCMultipartConfig
implements IMultipartConfig {
    private static Log log = LogFactory.getLog(SpringMVCMultipartConfig.class);
    private static final String MULTIPART_RESOLVER_BEAN_NAME = "multipartResolver";
    private WebApplicationContext webApplicationContext;

    public HttpServletRequest handleMultipartRequest(RequestWrapper request, ServletContext servletContext) throws HdivMultipartException {
        MultipartResolver multipartResolver = this.lookupMultipartResolver(servletContext);
        if (multipartResolver == null) {
            return request;
        }
        if (!(multipartResolver instanceof HdivCommonsMultipartResolver) && !(multipartResolver instanceof HdivStandardServletMultipartResolver)) {
            throw new IllegalStateException("In order to enable HDIV multipart processing, MultipartResolver must be of " + HdivCommonsMultipartResolver.class.getName() + " or " + HdivStandardServletMultipartResolver.class.getName() + " type.");
        }
        MultipartHttpServletRequest processedRequest = null;
        try {
            processedRequest = multipartResolver.resolveMultipart((HttpServletRequest)request.getRequest());
        }
        catch (MultipartException e) {
            throw new HdivMultipartException((Exception)((Object)e));
        }
        request.setRequest((ServletRequest)processedRequest);
        return request;
    }

    public void cleanupMultipart(HttpServletRequest request) {
        MultipartHttpServletRequest req;
        MultipartResolver multipartResolver = this.lookupMultipartResolver(request.getSession().getServletContext());
        if (multipartResolver != null && (req = (MultipartHttpServletRequest)WebUtils.getNativeRequest((ServletRequest)request, MultipartHttpServletRequest.class)) != null) {
            multipartResolver.cleanupMultipart(req);
        }
    }

    protected MultipartResolver lookupMultipartResolver(ServletContext servletContext) {
        MultipartResolver resolver = null;
        if (this.webApplicationContext == null) {
            this.webApplicationContext = WebApplicationContextUtils.getWebApplicationContext((ServletContext)servletContext);
        }
        try {
            resolver = (MultipartResolver)this.webApplicationContext.getBean(MULTIPART_RESOLVER_BEAN_NAME, MultipartResolver.class);
            if (resolver != null) {
                return resolver;
            }
        }
        catch (NoSuchBeanDefinitionException ex) {
            // empty catch block
        }
        if (resolver == null) {
            Enumeration e = servletContext.getAttributeNames();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                if (!name.startsWith(FrameworkServlet.SERVLET_CONTEXT_PREFIX)) continue;
                this.webApplicationContext = WebApplicationContextUtils.getWebApplicationContext((ServletContext)servletContext, (String)name);
                break;
            }
        }
        if (this.webApplicationContext != null) {
            try {
                resolver = (MultipartResolver)this.webApplicationContext.getBean(MULTIPART_RESOLVER_BEAN_NAME, MultipartResolver.class);
            }
            catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
                // empty catch block
            }
        }
        if (log.isDebugEnabled() && resolver == null) {
            log.debug((Object)"Cant find MultipartResolver on any context.");
        }
        return resolver;
    }
}

