/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.api.jaxrs.influx.query.parse.definition;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.antlr.v4.runtime.misc.NotNull;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.hawkular.metrics.api.jaxrs.influx.InfluxTimeUnit;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.InfluxQueryBaseListener;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.InfluxQueryParser;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.definition.AggregatedColumnDefinitionBuilder;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.definition.AndBooleanExpression;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.definition.BooleanExpression;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.definition.ColumnDefinition;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.definition.ColumnDefinitionBuilder;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.definition.DateOperand;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.definition.DoubleFunctionArgument;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.definition.DoubleOperand;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.definition.EqBooleanExpression;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.definition.FromClause;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.definition.FunctionArgument;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.definition.GroupByClause;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.definition.GtBooleanExpression;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.definition.LimitClause;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.definition.LongFunctionArgument;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.definition.LongOperand;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.definition.LtBooleanExpression;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.definition.MomentOperand;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.definition.NameFunctionArgument;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.definition.NameOperand;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.definition.NeqBooleanExpression;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.definition.Operand;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.definition.OrBooleanExpression;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.definition.RawColumnDefinitionBuilder;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.definition.SelectQueryDefinitions;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.definition.SelectQueryDefinitionsBuilder;
import org.hawkular.metrics.api.jaxrs.influx.query.parse.definition.StringFunctionArgument;
import org.joda.time.Instant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;
import org.joda.time.format.DateTimeParser;

public class SelectQueryDefinitionsParser
extends InfluxQueryBaseListener {
    private static final DateTimeFormatter DATE_FORMATTER;
    private SelectQueryDefinitionsBuilder definitionsBuilder = new SelectQueryDefinitionsBuilder();
    private String prefix;
    private String name;
    private String alias;
    private String function;
    private List<ColumnDefinition> columnDefinitions;
    private RawColumnDefinitionBuilder rawColumnDefinitionBuilder;
    private AggregatedColumnDefinitionBuilder aggregatedColumnDefinitionBuilder;
    private List<FunctionArgument> functionArguments;
    private Deque<BooleanExpression> booleanExpressionQueue;
    private Deque<Operand> operandQueue;

    public void enterColumnDefinitionList(@NotNull InfluxQueryParser.ColumnDefinitionListContext ctx) {
        this.columnDefinitions = new ArrayList((ctx.getChildCount() + 1) / 2);
    }

    public void exitColumnDefinitionList(@NotNull InfluxQueryParser.ColumnDefinitionListContext ctx) {
        this.definitionsBuilder.setColumnDefinitions(this.columnDefinitions);
    }

    public void enterColumnDefinition(@NotNull InfluxQueryParser.ColumnDefinitionContext ctx) {
        this.alias = null;
        this.removeColumnDefinitionBuilder();
    }

    public void exitColumnDefinition(@NotNull InfluxQueryParser.ColumnDefinitionContext ctx) {
        ColumnDefinitionBuilder columnDefinitionBuilder = this.getColumnDefinitionBuilder();
        columnDefinitionBuilder.setAlias(this.alias);
        this.columnDefinitions.add(columnDefinitionBuilder.createColumnDefinition());
        this.alias = null;
        this.removeColumnDefinitionBuilder();
    }

    public void enterRawColumnDefinition(@NotNull InfluxQueryParser.RawColumnDefinitionContext ctx) {
        this.rawColumnDefinitionBuilder = new RawColumnDefinitionBuilder();
        this.prefix = null;
        this.name = null;
    }

    public void exitRawColumnDefinition(@NotNull InfluxQueryParser.RawColumnDefinitionContext ctx) {
        this.rawColumnDefinitionBuilder.setPrefix(this.prefix);
        this.rawColumnDefinitionBuilder.setName(this.name);
        this.prefix = null;
        this.name = null;
    }

    public void enterAggregatedColumnDefinition(@NotNull InfluxQueryParser.AggregatedColumnDefinitionContext ctx) {
        this.aggregatedColumnDefinitionBuilder = new AggregatedColumnDefinitionBuilder();
        this.function = null;
        this.functionArguments = null;
    }

    public void exitAggregatedColumnDefinition(@NotNull InfluxQueryParser.AggregatedColumnDefinitionContext ctx) {
        this.aggregatedColumnDefinitionBuilder.setAggregationFunction(this.function);
        this.aggregatedColumnDefinitionBuilder.setAggregationFunctionArguments(this.functionArguments);
        this.function = null;
        this.functionArguments = null;
    }

    public void enterFromClause(@NotNull InfluxQueryParser.FromClauseContext ctx) {
        this.name = null;
        this.alias = null;
    }

    public void exitFromClause(@NotNull InfluxQueryParser.FromClauseContext ctx) {
        this.definitionsBuilder.setFromClause(new FromClause(this.name, this.alias));
        this.name = null;
        this.alias = null;
    }

    public void exitGroupByClause(@NotNull InfluxQueryParser.GroupByClauseContext ctx) {
        String bucketType = ctx.ID().getText();
        String timespan = ctx.TIMESPAN().getText();
        long bucketSize = Long.parseLong(timespan.substring(0, timespan.length() - 1));
        char unitId = timespan.charAt(timespan.length() - 1);
        InfluxTimeUnit bucketSizeUnit = InfluxTimeUnit.findById((String)String.valueOf(unitId));
        if (bucketSizeUnit == null) {
            throw new RuntimeException("Unknown time unit: " + unitId);
        }
        this.definitionsBuilder.setGroupByClause(new GroupByClause(bucketType, bucketSize, bucketSizeUnit));
    }

    public void enterWhereClause(@NotNull InfluxQueryParser.WhereClauseContext ctx) {
        this.booleanExpressionQueue = new ArrayDeque(10);
        this.operandQueue = new ArrayDeque(10);
    }

    public void exitWhereClause(@NotNull InfluxQueryParser.WhereClauseContext ctx) {
        this.definitionsBuilder.setWhereClause((BooleanExpression)this.booleanExpressionQueue.removeLast());
    }

    public void exitOrderAsc(@NotNull InfluxQueryParser.OrderAscContext ctx) {
        this.definitionsBuilder.setOrderDesc(false);
    }

    public void exitEqExpression(@NotNull InfluxQueryParser.EqExpressionContext ctx) {
        Operand rightOperand = (Operand)this.operandQueue.removeLast();
        Operand leftOperand = (Operand)this.operandQueue.removeLast();
        this.booleanExpressionQueue.addLast(new EqBooleanExpression(leftOperand, rightOperand));
    }

    public void exitGtExpression(@NotNull InfluxQueryParser.GtExpressionContext ctx) {
        Operand rightOperand = (Operand)this.operandQueue.removeLast();
        Operand leftOperand = (Operand)this.operandQueue.removeLast();
        this.booleanExpressionQueue.addLast(new GtBooleanExpression(leftOperand, rightOperand));
    }

    public void exitLtExpression(@NotNull InfluxQueryParser.LtExpressionContext ctx) {
        Operand rightOperand = (Operand)this.operandQueue.removeLast();
        Operand leftOperand = (Operand)this.operandQueue.removeLast();
        this.booleanExpressionQueue.addLast(new LtBooleanExpression(leftOperand, rightOperand));
    }

    public void exitNeqExpression(@NotNull InfluxQueryParser.NeqExpressionContext ctx) {
        Operand rightOperand = (Operand)this.operandQueue.removeLast();
        Operand leftOperand = (Operand)this.operandQueue.removeLast();
        this.booleanExpressionQueue.addLast(new NeqBooleanExpression(leftOperand, rightOperand));
    }

    public void exitAndExpression(@NotNull InfluxQueryParser.AndExpressionContext ctx) {
        BooleanExpression rightExpression = (BooleanExpression)this.booleanExpressionQueue.removeLast();
        BooleanExpression leftExpression = (BooleanExpression)this.booleanExpressionQueue.removeLast();
        this.booleanExpressionQueue.addLast(new AndBooleanExpression(leftExpression, rightExpression));
    }

    public void exitOrExpression(@NotNull InfluxQueryParser.OrExpressionContext ctx) {
        BooleanExpression rightExpression = (BooleanExpression)this.booleanExpressionQueue.removeLast();
        BooleanExpression leftExpression = (BooleanExpression)this.booleanExpressionQueue.removeLast();
        this.booleanExpressionQueue.addLast(new OrBooleanExpression(leftExpression, rightExpression));
    }

    public void enterNameOperand(@NotNull InfluxQueryParser.NameOperandContext ctx) {
        this.prefix = null;
        this.name = null;
    }

    public void exitNameOperand(@NotNull InfluxQueryParser.NameOperandContext ctx) {
        this.operandQueue.addLast(new NameOperand(this.prefix, this.name));
        this.prefix = null;
        this.name = null;
    }

    public void exitAbsoluteMomentOperand(InfluxQueryParser.AbsoluteMomentOperandContext ctx) {
        String timespan = ctx.TIMESPAN().getText();
        long amount = Long.parseLong(timespan.substring(0, timespan.length() - 1));
        char unitId = timespan.charAt(timespan.length() - 1);
        InfluxTimeUnit unit = InfluxTimeUnit.findById((String)String.valueOf(unitId));
        if (unit == null) {
            throw new RuntimeException("Unknown time unit: " + unitId);
        }
        this.operandQueue.addLast(new DateOperand(new Instant(unit.convertTo(TimeUnit.MILLISECONDS, amount))));
    }

    public void exitPastMomentOperand(@NotNull InfluxQueryParser.PastMomentOperandContext ctx) {
        InfluxTimeUnit timeshiftUnit;
        long timeshift;
        String functionName = ctx.ID().getText();
        TerminalNode intNode = ctx.INT();
        if (intNode == null) {
            String timespan = ctx.TIMESPAN().getText();
            timeshift = Long.parseLong(timespan.substring(0, timespan.length() - 1));
            char unitId = timespan.charAt(timespan.length() - 1);
            timeshiftUnit = InfluxTimeUnit.findById((String)String.valueOf(unitId));
            if (timeshiftUnit == null) {
                throw new RuntimeException("Unknown time unit: " + unitId);
            }
        } else {
            timeshift = Long.parseLong(intNode.getText());
            timeshiftUnit = InfluxTimeUnit.MICROSECONDS;
        }
        this.operandQueue.addLast(new MomentOperand(functionName, -1L * timeshift, timeshiftUnit));
    }

    public void exitFutureMomentOperand(@NotNull InfluxQueryParser.FutureMomentOperandContext ctx) {
        InfluxTimeUnit timeshiftUnit;
        long timeshift;
        String functionName = ctx.ID().getText();
        TerminalNode intNode = ctx.INT();
        if (intNode == null) {
            String timespan = ctx.TIMESPAN().getText();
            timeshift = Long.parseLong(timespan.substring(0, timespan.length() - 1));
            char unitId = timespan.charAt(timespan.length() - 1);
            timeshiftUnit = InfluxTimeUnit.findById((String)String.valueOf(unitId));
            if (timeshiftUnit == null) {
                throw new RuntimeException("Unknown time unit: " + unitId);
            }
        } else {
            timeshift = Long.parseLong(intNode.getText());
            timeshiftUnit = InfluxTimeUnit.MICROSECONDS;
        }
        this.operandQueue.addLast(new MomentOperand(functionName, timeshift, timeshiftUnit));
    }

    public void exitPresentMomentOperand(@NotNull InfluxQueryParser.PresentMomentOperandContext ctx) {
        String functionName = ctx.ID().getText();
        this.operandQueue.addLast(new MomentOperand(functionName, 0L, InfluxTimeUnit.SECONDS));
    }

    public void exitDateOperand(@NotNull InfluxQueryParser.DateOperandContext ctx) {
        String dateString = ctx.DATE_STRING().getText();
        dateString = dateString.substring(1, dateString.length() - 1);
        this.operandQueue.addLast(new DateOperand(Instant.parse((String)dateString, (DateTimeFormatter)DATE_FORMATTER)));
    }

    public void exitLongOperand(@NotNull InfluxQueryParser.LongOperandContext ctx) {
        long value = Long.parseLong(ctx.INT().getText());
        if (ctx.DASH() != null) {
            value = -1L * value;
        }
        this.operandQueue.addLast(new LongOperand(value));
    }

    public void exitDoubleOperand(@NotNull InfluxQueryParser.DoubleOperandContext ctx) {
        double value = Double.parseDouble(ctx.FLOAT().getText());
        if (ctx.DASH() != null) {
            value = -1.0 * value;
        }
        this.operandQueue.addLast(new DoubleOperand(value));
    }

    public void exitLimitClause(@NotNull InfluxQueryParser.LimitClauseContext ctx) {
        int limit = Integer.parseInt(ctx.INT().getText());
        this.definitionsBuilder.setLimitClause(new LimitClause(limit));
    }

    public void exitPrefix(@NotNull InfluxQueryParser.PrefixContext ctx) {
        this.prefix = ctx.ID().getText();
    }

    public void exitIdName(@NotNull InfluxQueryParser.IdNameContext ctx) {
        this.name = ctx.ID().getText();
    }

    public void exitStringName(@NotNull InfluxQueryParser.StringNameContext ctx) {
        String doubleQuotedString = ctx.DOUBLE_QUOTED_STRING().getText();
        this.name = doubleQuotedString.substring(1, doubleQuotedString.length() - 1);
    }

    public void exitAlias(@NotNull InfluxQueryParser.AliasContext ctx) {
        this.alias = ctx.ID().getText();
    }

    public void exitFunctionCall(@NotNull InfluxQueryParser.FunctionCallContext ctx) {
        this.function = ctx.ID().getText();
    }

    public void enterFunctionArgumentList(@NotNull InfluxQueryParser.FunctionArgumentListContext ctx) {
        this.functionArguments = new ArrayList((ctx.getChildCount() + 1) / 2);
    }

    public void enterNameFunctionArgument(@NotNull InfluxQueryParser.NameFunctionArgumentContext ctx) {
        this.prefix = null;
        this.name = null;
    }

    public void exitStringFunctionArgument(@NotNull InfluxQueryParser.StringFunctionArgumentContext ctx) {
        String singleQuotedString = ctx.SINGLE_QUOTED_STRING().getText();
        String value = singleQuotedString.substring(1, singleQuotedString.length() - 1);
        this.functionArguments.add(new StringFunctionArgument(value));
    }

    public void exitNameFunctionArgument(@NotNull InfluxQueryParser.NameFunctionArgumentContext ctx) {
        NameFunctionArgument functionArgument = new NameFunctionArgument(this.prefix, this.name);
        this.functionArguments.add(functionArgument);
        this.prefix = null;
        this.name = null;
    }

    public void exitDoubleFunctionArgument(@NotNull InfluxQueryParser.DoubleFunctionArgumentContext ctx) {
        double value = Double.parseDouble(ctx.FLOAT().getText());
        if (ctx.DASH() != null) {
            value = -1.0 * value;
        }
        this.functionArguments.add(new DoubleFunctionArgument(value));
    }

    public void exitLongFunctionArgument(@NotNull InfluxQueryParser.LongFunctionArgumentContext ctx) {
        long value = Long.parseLong(ctx.INT().getText());
        if (ctx.DASH() != null) {
            value = -1L * value;
        }
        this.functionArguments.add(new LongFunctionArgument(value));
    }

    private ColumnDefinitionBuilder getColumnDefinitionBuilder() {
        return this.rawColumnDefinitionBuilder != null ? this.rawColumnDefinitionBuilder : this.aggregatedColumnDefinitionBuilder;
    }

    private void removeColumnDefinitionBuilder() {
        this.rawColumnDefinitionBuilder = null;
        this.aggregatedColumnDefinitionBuilder = null;
    }

    public SelectQueryDefinitions getSelectQueryDefinitions() {
        return this.definitionsBuilder.createSelectQueryDefinitions();
    }

    static {
        DateTimeParser millisParser = new DateTimeFormatterBuilder().appendLiteral('.').append(DateTimeFormat.forPattern((String)"SSS")).toParser();
        DateTimeParser timeParser = new DateTimeFormatterBuilder().appendLiteral(' ').append(DateTimeFormat.forPattern((String)"HH")).appendLiteral(':').append(DateTimeFormat.forPattern((String)"mm")).appendLiteral(':').append(DateTimeFormat.forPattern((String)"ss")).appendOptional(millisParser).toParser();
        DATE_FORMATTER = new DateTimeFormatterBuilder().append(DateTimeFormat.forPattern((String)"yyyy")).appendLiteral('-').append(DateTimeFormat.forPattern((String)"MM")).appendLiteral('-').append(DateTimeFormat.forPattern((String)"dd")).appendOptional(timeParser).toFormatter().withZoneUTC();
    }
}

