/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.api.jaxrs.influx.prettyprint;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.Provider;
import javax.ws.rs.ext.WriterInterceptor;
import javax.ws.rs.ext.WriterInterceptorContext;
import org.hawkular.metrics.api.jaxrs.influx.prettyprint.PrettyFilter;

@Provider
public class PrettyInterceptor
implements WriterInterceptor {
    private final ObjectMapper mapper = new ObjectMapper();

    public PrettyInterceptor() {
        this.mapper.configure(SerializationFeature.INDENT_OUTPUT, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void aroundWriteTo(WriterInterceptorContext context) throws IOException, WebApplicationException {
        if (context.getProperty(PrettyFilter.PRETTY_PRINT) != Boolean.TRUE || !MediaType.APPLICATION_JSON_TYPE.equals((Object)context.getMediaType())) {
            context.proceed();
            return;
        }
        context.getHeaders().remove((Object)"Content-Length");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        OutputStream old = context.getOutputStream();
        try {
            context.setOutputStream((OutputStream)baos);
            context.proceed();
            JsonNode jsonNode = (JsonNode)this.mapper.readValue(baos.toByteArray(), JsonNode.class);
            this.mapper.writeValue(old, (Object)jsonNode);
        }
        finally {
            context.setOutputStream(old);
        }
    }
}

