/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.api.jaxrs.handler;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.hawkular.metrics.api.jaxrs.handler.observer.MetricCreatedObserver;
import org.hawkular.metrics.api.jaxrs.handler.observer.ResultSetObserver;
import org.hawkular.metrics.api.jaxrs.model.ApiError;
import org.hawkular.metrics.api.jaxrs.model.Counter;
import org.hawkular.metrics.api.jaxrs.model.CounterDataPoint;
import org.hawkular.metrics.api.jaxrs.model.GaugeDataPoint;
import org.hawkular.metrics.api.jaxrs.model.MetricDefinition;
import org.hawkular.metrics.api.jaxrs.param.BucketConfig;
import org.hawkular.metrics.api.jaxrs.param.Duration;
import org.hawkular.metrics.api.jaxrs.param.Percentiles;
import org.hawkular.metrics.api.jaxrs.param.Tags;
import org.hawkular.metrics.api.jaxrs.param.TimeRange;
import org.hawkular.metrics.api.jaxrs.util.ApiUtils;
import org.hawkular.metrics.core.api.Buckets;
import org.hawkular.metrics.core.api.Metric;
import org.hawkular.metrics.core.api.MetricId;
import org.hawkular.metrics.core.api.MetricType;
import org.hawkular.metrics.core.api.MetricsService;
import org.hawkular.metrics.core.api.NumericBucketPoint;
import rx.Observable;
import rx.Observer;

@Path(value="/counters")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Api(tags={"Counter"})
public class CounterHandler {
    @Inject
    private MetricsService metricsService;
    @HeaderParam(value="Hawkular-Tenant")
    private String tenantId;

    @POST
    @Path(value="/")
    @ApiOperation(value="Create counter metric. This operation also causes the rate to be calculated and persisted periodically after raw count data is persisted.", notes="Clients are not required to explicitly create a metric before storing data. Doing so however allows clients to prevent naming collisions and to specify tags and data retention.")
    @ApiResponses(value={@ApiResponse(code=201, message="Metric created successfully"), @ApiResponse(code=400, message="Missing or invalid payload", response=ApiError.class), @ApiResponse(code=409, message="Counter metric with given id already exists", response=ApiError.class), @ApiResponse(code=500, message="Metric creation failed due to an unexpected error", response=ApiError.class)})
    public void createCounter(@Suspended AsyncResponse asyncResponse, @ApiParam(required=true) MetricDefinition metricDefinition, @Context UriInfo uriInfo) {
        if (metricDefinition.getType() != null && MetricType.COUNTER != metricDefinition.getType()) {
            asyncResponse.resume((Object)ApiUtils.badRequest((ApiError)new ApiError("MetricDefinition type does not match " + MetricType.COUNTER.getText())));
        }
        Metric metric = new Metric(new MetricId(this.tenantId, MetricType.COUNTER, metricDefinition.getId()), metricDefinition.getTags(), metricDefinition.getDataRetention());
        URI location = uriInfo.getBaseUriBuilder().path("/counters/{id}").build(new Object[]{metric.getId().getName()});
        this.metricsService.createMetric(metric).subscribe((Observer)new MetricCreatedObserver(asyncResponse, location));
    }

    @GET
    @Path(value="/{id}")
    @ApiOperation(value="Retrieve a counter definition", response=MetricDefinition.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Metric's definition was successfully retrieved."), @ApiResponse(code=204, message="Query was successful, but no metrics definition is set."), @ApiResponse(code=500, message="Unexpected error occurred while fetching metric's definition.", response=ApiError.class)})
    public void getCounter(@Suspended AsyncResponse asyncResponse, @PathParam(value="id") String id) {
        this.metricsService.findMetric(new MetricId(this.tenantId, MetricType.COUNTER, id)).map(MetricDefinition::new).map(metricDef -> Response.ok((Object)metricDef).build()).switchIfEmpty(Observable.just((Object)ApiUtils.noContent())).subscribe(arg_0 -> ((AsyncResponse)asyncResponse).resume(arg_0), t -> asyncResponse.resume((Object)ApiUtils.serverError((Throwable)t)));
    }

    @GET
    @Path(value="/{id}/tags")
    @ApiOperation(value="Retrieve tags associated with the metric definition.", response=Map.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Metric's tags were successfully retrieved."), @ApiResponse(code=204, message="Query was successful, but no metrics were found."), @ApiResponse(code=500, message="Unexpected error occurred while fetching metric's tags.", response=ApiError.class)})
    public void getMetricTags(@Suspended AsyncResponse asyncResponse, @PathParam(value="id") String id) {
        this.metricsService.getMetricTags(new MetricId(this.tenantId, MetricType.COUNTER, id)).subscribe(optional -> asyncResponse.resume((Object)ApiUtils.valueToResponse((Optional)optional)), t -> asyncResponse.resume((Object)ApiUtils.serverError((Throwable)t)));
    }

    @PUT
    @Path(value="/{id}/tags")
    @ApiOperation(value="Update tags associated with the metric definition.")
    @ApiResponses(value={@ApiResponse(code=200, message="Metric's tags were successfully updated."), @ApiResponse(code=500, message="Unexpected error occurred while updating metric's tags.", response=ApiError.class)})
    public void updateMetricTags(@Suspended AsyncResponse asyncResponse, @PathParam(value="id") String id, @ApiParam(required=true) Map<String, String> tags) {
        Metric metric = new Metric(new MetricId(this.tenantId, MetricType.COUNTER, id));
        this.metricsService.addTags(metric, tags).subscribe((Observer)new ResultSetObserver(asyncResponse));
    }

    @DELETE
    @Path(value="/{id}/tags/{tags}")
    @ApiOperation(value="Delete tags associated with the metric definition.")
    @ApiResponses(value={@ApiResponse(code=200, message="Metric's tags were successfully deleted."), @ApiResponse(code=400, message="Invalid tags", response=ApiError.class), @ApiResponse(code=500, message="Unexpected error occurred while trying to delete metric's tags.", response=ApiError.class)})
    public void deleteMetricTags(@Suspended AsyncResponse asyncResponse, @PathParam(value="id") String id, @ApiParam(value="Tag list") @PathParam(value="tags") Tags tags) {
        Metric metric = new Metric(new MetricId(this.tenantId, MetricType.COUNTER, id));
        this.metricsService.deleteTags(metric, tags.getTags()).subscribe((Observer)new ResultSetObserver(asyncResponse));
    }

    @POST
    @Path(value="/data")
    @ApiOperation(value="Add data points for multiple counters")
    @ApiResponses(value={@ApiResponse(code=200, message="Adding data points succeeded."), @ApiResponse(code=400, message="Missing or invalid payload", response=ApiError.class), @ApiResponse(code=500, message="Unexpected error happened while storing the data points", response=ApiError.class)})
    public void addData(@Suspended AsyncResponse asyncResponse, @ApiParam(value="List of metrics", required=true) List<Counter> counters) {
        Observable metrics = Counter.toObservable((String)this.tenantId, counters);
        Observable observable = this.metricsService.addDataPoints(MetricType.COUNTER, metrics);
        observable.subscribe((Observer)new ResultSetObserver(asyncResponse));
    }

    @POST
    @Path(value="/{id}/data")
    @ApiOperation(value="Add data for a single counter")
    @ApiResponses(value={@ApiResponse(code=200, message="Adding data succeeded."), @ApiResponse(code=400, message="Missing or invalid payload", response=ApiError.class), @ApiResponse(code=500, message="Unexpected error happened while storing the data", response=ApiError.class)})
    public void addData(@Suspended AsyncResponse asyncResponse, @PathParam(value="id") String id, @ApiParam(value="List of data points containing timestamp and value", required=true) List<CounterDataPoint> data) {
        Observable metrics = CounterDataPoint.toObservable((String)this.tenantId, (String)id, data);
        Observable observable = this.metricsService.addDataPoints(MetricType.COUNTER, metrics);
        observable.subscribe((Observer)new ResultSetObserver(asyncResponse));
    }

    @GET
    @Path(value="/{id}/data")
    @ApiOperation(value="Retrieve counter data points.", notes="When buckets or bucketDuration query parameter is used, the time range between start and end will be divided in buckets of equal duration, and metric statistics will be computed for each bucket.", response=CounterDataPoint.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=200, message="Successfully fetched metric data."), @ApiResponse(code=204, message="No metric data was found."), @ApiResponse(code=400, message="buckets or bucketDuration parameter is invalid, or both are used.", response=ApiError.class), @ApiResponse(code=500, message="Unexpected error occurred while fetching metric data.", response=ApiError.class)})
    public void findCounterData(@Suspended AsyncResponse asyncResponse, @PathParam(value="id") String id, @ApiParam(value="Defaults to now - 8 hours") @QueryParam(value="start") Long start, @ApiParam(value="Defaults to now") @QueryParam(value="end") Long end, @ApiParam(value="Total number of buckets") @QueryParam(value="buckets") Integer bucketsCount, @ApiParam(value="Bucket duration") @QueryParam(value="bucketDuration") Duration bucketDuration, @ApiParam(value="Percentiles to calculate") @QueryParam(value="percentiles") Percentiles percentiles) {
        TimeRange timeRange = new TimeRange(start, end);
        if (!timeRange.isValid()) {
            asyncResponse.resume((Object)ApiUtils.badRequest((ApiError)new ApiError(timeRange.getProblem())));
            return;
        }
        BucketConfig bucketConfig = new BucketConfig(bucketsCount, bucketDuration, timeRange);
        if (!bucketConfig.isValid()) {
            asyncResponse.resume((Object)ApiUtils.badRequest((ApiError)new ApiError(bucketConfig.getProblem())));
            return;
        }
        MetricId metricId = new MetricId(this.tenantId, MetricType.COUNTER, id);
        Buckets buckets = bucketConfig.getBuckets();
        if (buckets == null) {
            this.metricsService.findDataPoints(metricId, timeRange.getStart(), timeRange.getEnd()).map(CounterDataPoint::new).toList().map(ApiUtils::collectionToResponse).subscribe(arg_0 -> ((AsyncResponse)asyncResponse).resume(arg_0), t -> asyncResponse.resume((Object)ApiUtils.serverError((Throwable)t)));
        } else {
            if (percentiles == null) {
                percentiles = new Percentiles(Collections.emptyList());
            }
            this.metricsService.findCounterStats(metricId, timeRange.getStart(), timeRange.getEnd(), buckets, percentiles.getPercentiles()).map(ApiUtils::collectionToResponse).subscribe(arg_0 -> ((AsyncResponse)asyncResponse).resume(arg_0), t -> asyncResponse.resume((Object)ApiUtils.serverError((Throwable)t)));
        }
    }

    @GET
    @Path(value="/{id}/rate")
    @ApiOperation(value="Retrieve counter rate data points.", notes="When buckets or bucketDuration query parameter is used, the time range between start and end will be divided in buckets of equal duration, and metric statistics will be computed for each bucket. Reset events are detected and data points that immediately follow such events are filtered out prior to calculating the rates. This avoid misleading or inaccurate rates when resets occur.", response=GaugeDataPoint.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=200, message="Successfully fetched metric data."), @ApiResponse(code=204, message="No metric data was found."), @ApiResponse(code=400, message="buckets or bucketDuration parameter is invalid, or both are used.", response=ApiError.class), @ApiResponse(code=500, message="Unexpected error occurred while fetching metric data.", response=ApiError.class)})
    public void findRate(@Suspended AsyncResponse asyncResponse, @PathParam(value="id") String id, @ApiParam(value="Defaults to now - 8 hours") @QueryParam(value="start") Long start, @ApiParam(value="Defaults to now") @QueryParam(value="end") Long end, @ApiParam(value="Total number of buckets") @QueryParam(value="buckets") Integer bucketsCount, @ApiParam(value="Bucket duration") @QueryParam(value="bucketDuration") Duration bucketDuration, @ApiParam(value="Percentiles to calculate") @QueryParam(value="percentiles") Percentiles percentiles) {
        TimeRange timeRange = new TimeRange(start, end);
        if (!timeRange.isValid()) {
            asyncResponse.resume((Object)ApiUtils.badRequest((ApiError)new ApiError(timeRange.getProblem())));
            return;
        }
        BucketConfig bucketConfig = new BucketConfig(bucketsCount, bucketDuration, timeRange);
        if (!bucketConfig.isValid()) {
            asyncResponse.resume((Object)ApiUtils.badRequest((ApiError)new ApiError(bucketConfig.getProblem())));
            return;
        }
        MetricId metricId = new MetricId(this.tenantId, MetricType.COUNTER, id);
        Buckets buckets = bucketConfig.getBuckets();
        if (buckets == null) {
            this.metricsService.findRateData(metricId, timeRange.getStart(), timeRange.getEnd()).map(GaugeDataPoint::new).toList().map(ApiUtils::collectionToResponse).subscribe(arg_0 -> ((AsyncResponse)asyncResponse).resume(arg_0), t -> asyncResponse.resume((Object)ApiUtils.serverError((Throwable)t)));
        } else {
            if (percentiles == null) {
                percentiles = new Percentiles(Collections.emptyList());
            }
            this.metricsService.findRateStats(metricId, timeRange.getStart(), timeRange.getEnd(), buckets, percentiles.getPercentiles()).map(ApiUtils::collectionToResponse).subscribe(arg_0 -> ((AsyncResponse)asyncResponse).resume(arg_0), t -> asyncResponse.resume((Object)ApiUtils.serverError((Throwable)t)));
        }
    }

    @GET
    @Path(value="/data")
    @ApiOperation(value="Fetches data points from one or more metrics that are determined using either a tags filter or a list of metric names. The time range between start and end is divided into buckets of equal size (i.e., duration) using either the buckets or bucketDuration parameter. Functions   are applied tothe data points in each bucket to produce statistics or aggregated metrics.", response=NumericBucketPoint.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=200, message="Successfully fetched metric data."), @ApiResponse(code=204, message="No metric data was found."), @ApiResponse(code=400, message="The tags parameter is required. Either the buckets or the bucketDuration parameter is required but not both.", response=ApiError.class), @ApiResponse(code=500, message="Unexpected error occurred while fetching metric data.", response=ApiError.class)})
    public void findCounterDataStats(@Suspended AsyncResponse asyncResponse, @ApiParam(value="Defaults to now - 8 hours") @QueryParam(value="start") Long start, @ApiParam(value="Defaults to now") @QueryParam(value="end") Long end, @ApiParam(value="Total number of buckets") @QueryParam(value="buckets") Integer bucketsCount, @ApiParam(value="Bucket duration") @QueryParam(value="bucketDuration") Duration bucketDuration, @ApiParam(value="Percentiles to calculate") @QueryParam(value="percentiles") Percentiles percentiles, @ApiParam(value="List of tags filters", required=false) @QueryParam(value="tags") Tags tags, @ApiParam(value="List of metric names", required=false) @QueryParam(value="metrics") List<String> metricNames, @ApiParam(value="Downsample method (if true then sum of stacked individual stats; defaults to false)", required=false) @DefaultValue(value="false") @QueryParam(value="stacked") Boolean stacked) {
        TimeRange timeRange = new TimeRange(start, end);
        if (!timeRange.isValid()) {
            asyncResponse.resume((Object)ApiUtils.badRequest((ApiError)new ApiError(timeRange.getProblem())));
            return;
        }
        BucketConfig bucketConfig = new BucketConfig(bucketsCount, bucketDuration, timeRange);
        if (bucketConfig.isEmpty()) {
            asyncResponse.resume((Object)ApiUtils.badRequest((ApiError)new ApiError("Either the buckets or bucketsDuration parameter must be used")));
            return;
        }
        if (!bucketConfig.isValid()) {
            asyncResponse.resume((Object)ApiUtils.badRequest((ApiError)new ApiError(bucketConfig.getProblem())));
            return;
        }
        if (metricNames.isEmpty() && (tags == null || tags.getTags().isEmpty())) {
            asyncResponse.resume((Object)ApiUtils.badRequest((ApiError)new ApiError("Either metrics or tags parameter must be used")));
            return;
        }
        if (!metricNames.isEmpty() && tags != null && !tags.getTags().isEmpty()) {
            asyncResponse.resume((Object)ApiUtils.badRequest((ApiError)new ApiError("Cannot use both the metrics and tags parameters")));
            return;
        }
        if (percentiles == null) {
            percentiles = new Percentiles(Collections.emptyList());
        }
        if (metricNames.isEmpty()) {
            this.metricsService.findNumericStats(this.tenantId, MetricType.COUNTER, tags.getTags(), timeRange.getStart(), timeRange.getEnd(), bucketConfig.getBuckets(), percentiles.getPercentiles(), stacked.booleanValue()).map(ApiUtils::collectionToResponse).subscribe(arg_0 -> ((AsyncResponse)asyncResponse).resume(arg_0), t -> asyncResponse.resume((Object)ApiUtils.serverError((Throwable)t)));
        } else {
            this.metricsService.findNumericStats(this.tenantId, MetricType.COUNTER, metricNames, timeRange.getStart(), timeRange.getEnd(), bucketConfig.getBuckets(), percentiles.getPercentiles(), stacked.booleanValue()).map(ApiUtils::collectionToResponse).subscribe(arg_0 -> ((AsyncResponse)asyncResponse).resume(arg_0), t -> asyncResponse.resume((Object)ApiUtils.serverError((Throwable)t)));
        }
    }

    @GET
    @Path(value="/data/rate")
    @ApiOperation(value="Fetches data points from one or more metrics that are determined using either a tags filter or a list of metric names. The time range between start and end is divided into buckets of equal size (i.e., duration) using either the buckets or bucketDuration parameter. Functions are applied to the data points in each bucket to produce statistics or aggregated metrics.", response=NumericBucketPoint.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=200, message="Successfully fetched metric data."), @ApiResponse(code=204, message="No metric data was found."), @ApiResponse(code=400, message="The tags parameter is required. Either the buckets or the bucketDuration parameter is required but not both.", response=ApiError.class), @ApiResponse(code=500, message="Unexpected error occurred while fetching metric data.", response=ApiError.class)})
    public void findCounterRateDataStats(@Suspended AsyncResponse asyncResponse, @ApiParam(value="Defaults to now - 8 hours") @QueryParam(value="start") Long start, @ApiParam(value="Defaults to now") @QueryParam(value="end") Long end, @ApiParam(value="Total number of buckets") @QueryParam(value="buckets") Integer bucketsCount, @ApiParam(value="Bucket duration") @QueryParam(value="bucketDuration") Duration bucketDuration, @ApiParam(value="Percentiles to calculate") @QueryParam(value="percentiles") Percentiles percentiles, @ApiParam(value="List of tags filters", required=false) @QueryParam(value="tags") Tags tags, @ApiParam(value="List of metric names", required=false) @QueryParam(value="metrics") List<String> metricNames, @ApiParam(value="Downsample method (if true then sum of stacked individual stats; defaults to false)", required=false) @DefaultValue(value="false") @QueryParam(value="stacked") Boolean stacked) {
        TimeRange timeRange = new TimeRange(start, end);
        if (!timeRange.isValid()) {
            asyncResponse.resume((Object)ApiUtils.badRequest((ApiError)new ApiError(timeRange.getProblem())));
            return;
        }
        BucketConfig bucketConfig = new BucketConfig(bucketsCount, bucketDuration, timeRange);
        if (bucketConfig.isEmpty()) {
            asyncResponse.resume((Object)ApiUtils.badRequest((ApiError)new ApiError("Either the buckets or bucketsDuration parameter must be used")));
            return;
        }
        if (!bucketConfig.isValid()) {
            asyncResponse.resume((Object)ApiUtils.badRequest((ApiError)new ApiError(bucketConfig.getProblem())));
            return;
        }
        if (metricNames.isEmpty() && (tags == null || tags.getTags().isEmpty())) {
            asyncResponse.resume((Object)ApiUtils.badRequest((ApiError)new ApiError("Either metrics or tags parameter must be used")));
            return;
        }
        if (!metricNames.isEmpty() && tags != null && !tags.getTags().isEmpty()) {
            asyncResponse.resume((Object)ApiUtils.badRequest((ApiError)new ApiError("Cannot use both the metrics and tags parameters")));
            return;
        }
        if (percentiles == null) {
            percentiles = new Percentiles(Collections.emptyList());
        }
        if (metricNames.isEmpty()) {
            this.metricsService.findNumericStats(this.tenantId, MetricType.COUNTER_RATE, tags.getTags(), timeRange.getStart(), timeRange.getEnd(), bucketConfig.getBuckets(), percentiles.getPercentiles(), stacked.booleanValue()).map(ApiUtils::collectionToResponse).subscribe(arg_0 -> ((AsyncResponse)asyncResponse).resume(arg_0), t -> asyncResponse.resume((Object)ApiUtils.serverError((Throwable)t)));
        } else {
            this.metricsService.findNumericStats(this.tenantId, MetricType.COUNTER_RATE, metricNames, timeRange.getStart(), timeRange.getEnd(), bucketConfig.getBuckets(), percentiles.getPercentiles(), stacked.booleanValue()).map(ApiUtils::collectionToResponse).subscribe(arg_0 -> ((AsyncResponse)asyncResponse).resume(arg_0), t -> asyncResponse.resume((Object)ApiUtils.serverError((Throwable)t)));
        }
    }
}

