/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.api.jaxrs.handler;

import com.google.common.collect.ImmutableList;
import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Response;
import org.hawkular.metrics.api.jaxrs.ApiError;
import org.hawkular.metrics.api.jaxrs.param.Tags;
import org.hawkular.metrics.api.jaxrs.request.MetricDefinition;
import org.hawkular.metrics.api.jaxrs.request.MixedMetricsRequest;
import org.hawkular.metrics.api.jaxrs.util.ApiUtils;
import org.hawkular.metrics.core.api.MetricType;
import org.hawkular.metrics.core.api.MetricsService;
import rx.Observable;
import rx.schedulers.Schedulers;

@Path(value="/metrics")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Api(value="", description="Metrics related REST interface")
public class MetricHandler {
    @Inject
    private MetricsService metricsService;
    @HeaderParam(value="Hawkular-Tenant")
    private String tenantId;

    @GET
    @Path(value="/")
    @ApiOperation(value="Find tenant's metric definitions.", notes="Does not include any metric values. ", response=List.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=200, message="Successfully retrieved at least one metric definition."), @ApiResponse(code=204, message="No metrics found."), @ApiResponse(code=400, message="Invalid type parameter type.", response=ApiError.class), @ApiResponse(code=500, message="Failed to retrieve metrics due to unexpected error.", response=ApiError.class)})
    public void findMetrics(@Suspended AsyncResponse asyncResponse, @ApiParam(value="Queried metric type", required=false, allowableValues="[gauge, availability, counter]") @QueryParam(value="type") MetricType metricType, @ApiParam(value="List of tags filters", required=false) @QueryParam(value="tags") Tags tags) {
        if (metricType != null && !MetricType.userTypes().contains(metricType)) {
            asyncResponse.resume((Object)ApiUtils.badRequest((ApiError)new ApiError("Incorrect type param " + metricType.toString())));
            return;
        }
        Observable metricObservable = tags == null ? this.metricsService.findMetrics(this.tenantId, metricType) : this.metricsService.findMetricsWithFilters(this.tenantId, tags.getTags(), metricType);
        metricObservable.map(MetricDefinition::new).toList().map(ApiUtils::collectionToResponse).subscribe(arg_0 -> ((AsyncResponse)asyncResponse).resume(arg_0), t -> {
            if (t instanceof PatternSyntaxException) {
                asyncResponse.resume((Object)ApiUtils.badRequest((Throwable)t));
            } else {
                asyncResponse.resume((Object)ApiUtils.serverError((Throwable)t));
            }
        });
    }

    @POST
    @Path(value="/data")
    @ApiOperation(value="Add data for multiple metrics in a single call.")
    @ApiResponses(value={@ApiResponse(code=200, message="Adding data succeeded."), @ApiResponse(code=400, message="Missing or invalid payload.", response=ApiError.class), @ApiResponse(code=500, message="Unexpected error happened while storing the data", response=ApiError.class)})
    public void addMetricsData(@Suspended AsyncResponse asyncResponse, @ApiParam(value="List of metrics", required=true) MixedMetricsRequest metricsRequest) {
        List gauges = metricsRequest.getGauges();
        List counters = metricsRequest.getCounters();
        List availabilities = metricsRequest.getAvailabilities();
        if (!(gauges != null && !gauges.isEmpty() || availabilities != null && !availabilities.isEmpty() || counters != null && !counters.isEmpty())) {
            asyncResponse.resume((Object)ApiUtils.emptyPayload());
            return;
        }
        ArrayList<Observable> observables = new ArrayList<Observable>();
        if (gauges != null && !gauges.isEmpty()) {
            gauges = ImmutableList.copyOf((Collection)gauges);
            observables.add(this.metricsService.addGaugeData(ApiUtils.requestToGauges((String)this.tenantId, (List)gauges).subscribeOn(Schedulers.computation())));
        }
        if (counters != null && !counters.isEmpty()) {
            counters = ImmutableList.copyOf((Collection)counters);
            observables.add(this.metricsService.addCounterData(ApiUtils.requestToCounters((String)this.tenantId, (List)counters).subscribeOn(Schedulers.computation())));
        }
        if (availabilities != null && !availabilities.isEmpty()) {
            availabilities = ImmutableList.copyOf((Collection)availabilities);
            observables.add(this.metricsService.addAvailabilityData(ApiUtils.requestToAvailabilities((String)this.tenantId, (List)ImmutableList.copyOf((Collection)availabilities)).subscribeOn(Schedulers.computation())));
        }
        Observable.merge(observables).subscribe(aVoid -> {}, t -> asyncResponse.resume((Object)ApiUtils.serverError((Throwable)t)), () -> asyncResponse.resume((Object)Response.ok().build()));
    }
}

