/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.api.jaxrs.config;

import com.google.common.base.Preconditions;

public enum ConfigurationKey {
    CASSANDRA_NODES("hawkular-metrics.cassandra-nodes", "127.0.0.1", "CASSANDRA_NODES", false),
    CASSANDRA_CQL_PORT("hawkular-metrics.cassandra-cql-port", "9042", "CASSANDRA_CQL_PORT", false),
    CASSANDRA_KEYSPACE("cassandra.keyspace", "hawkular_metrics", null, false),
    CASSANDRA_RESETDB("cassandra.resetdb", null, null, true),
    CASSANDRA_USESSL("hawkular-metrics.cassandra-use-ssl", "false", "CASSANDRA_USESSL", false),
    WAIT_FOR_SERVICE("hawkular.metrics.waitForService", null, null, true),
    USE_VIRTUAL_CLOCK("hawkular.metrics.use-virtual-clock", "false", "USE_VIRTUAL_CLOCK", false);

    private final String name;
    private final String env;
    private final String defaultValue;
    private final boolean flag;

    private ConfigurationKey(String name, String defaultValue, String env, boolean flag) {
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)"name is null");
        Preconditions.checkArgument((!flag || defaultValue == null ? 1 : 0) != 0, (Object)"Config flags can't have a default value");
        this.name = name;
        this.env = env;
        this.defaultValue = defaultValue;
        this.flag = flag;
    }

    public String toString() {
        return this.name;
    }

    public String defaultValue() {
        return this.defaultValue;
    }

    public String toEnvString() {
        return this.env;
    }

    public boolean isFlag() {
        return this.flag;
    }
}

