/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.api.jaxrs.util;

import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import org.hawkular.metrics.api.jaxrs.util.SchemaVersionCheckException;
import org.jboss.logging.Logger;

public class SchemaVersionChecker {
    private static final Logger logger = Logger.getLogger(SchemaVersionChecker.class);

    public void waitForSchemaUpdates(Session session, String keyspace, String version, long delay, int maxRetries) throws InterruptedException {
        String configId = "org.hawkular.metrics";
        String configName = "version";
        PreparedStatement getVersion = null;
        for (int retries = 0; maxRetries > retries; ++retries) {
            try {
                ResultSet resultSet;
                if (getVersion == null) {
                    getVersion = session.prepare("SELECT value FROM " + keyspace + ".sys_config WHERE config_id = ? AND name = ?");
                }
                if (!(resultSet = session.execute((Statement)getVersion.bind(new Object[]{configId, configName}))).isExhausted() && version.equals(resultSet.one().getString(0))) {
                    logger.infof("Hawkular Metrics is up to date at version %s", (Object)version);
                    return;
                }
            }
            catch (Exception e) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Version check failed", (Throwable)e);
                } else {
                    logger.infof("Version check failed: %s", (Object)e.getMessage());
                }
                logger.infof("Trying again in %d ms", (Object)delay);
            }
            Thread.sleep(delay);
        }
        throw new SchemaVersionCheckException("Version check unsuccessful after " + maxRetries + " attempts");
    }
}

