/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.api.jaxrs.filter;

import java.io.IOException;
import javax.inject.Inject;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.Provider;
import org.hawkular.metrics.api.jaxrs.config.Configurable;
import org.hawkular.metrics.api.jaxrs.config.ConfigurationKey;
import org.hawkular.metrics.api.jaxrs.config.ConfigurationProperty;

@Provider
public class CacheControlFilter
implements ContainerResponseFilter {
    @Inject
    @Configurable
    @ConfigurationProperty(value=ConfigurationKey.CACHE_CONTROL_HEADER)
    String cacheControl;

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        if (this.cacheControl != null) {
            MultivaluedMap responseHeaders = responseContext.getHeaders();
            responseHeaders.add((Object)"Cache-Control", (Object)this.cacheControl);
            responseHeaders.add((Object)"Vary", (Object)"Origin,Accept-Encoding");
        }
    }
}

