/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.api.jaxrs.dropwizard;

import com.codahale.metrics.Timer;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import org.hawkular.metrics.api.jaxrs.dropwizard.HTTPMethod;
import org.hawkular.metrics.api.jaxrs.dropwizard.RESTMetaData;
import org.hawkular.metrics.api.jaxrs.util.MetricRegistryProvider;
import org.hawkular.metrics.core.dropwizard.HawkularMetricRegistry;
import org.hawkular.metrics.core.dropwizard.MetaData;
import org.hawkular.metrics.core.dropwizard.MetricNameService;
import org.jboss.logging.Logger;
import rx.Observable;

@ApplicationScoped
public class RESTMetrics {
    private static Logger logger = Logger.getLogger(RESTMetrics.class);
    private MetricNameService metricNameService;
    @Inject
    BeanManager beanManager;

    public void setMetricNameService(MetricNameService metricNameService) {
        this.metricNameService = metricNameService;
    }

    public void initMetrics() throws IOException {
        String hostname = this.metricNameService.getHostName();
        Observable.from((Iterable)this.beanManager.getBeans(Object.class, new Annotation[]{new /* Unavailable Anonymous Inner Class!! */})).map(Bean::getBeanClass).filter(arg_0 -> this.isRESTHandler(arg_0)).flatMap(c -> Observable.from((Object[])c.getMethods())).filter(arg_0 -> this.isRESTHandlerMethod(arg_0)).subscribe(method -> {
            HTTPMethod httpMethod = this.getHttpMethod(method);
            String uri = this.getURI(method);
            if (this.isWrite(method, uri)) {
                this.register(RESTMetaData.forWrite((HTTPMethod)httpMethod, (String)uri, (String)hostname));
            } else {
                this.register(RESTMetaData.forRead((HTTPMethod)httpMethod, (String)uri, (String)hostname));
            }
        }, t -> logger.warn((Object)"Failed to register meta data for REST metrics", t), () -> {});
    }

    private boolean isRESTHandler(Class clazz) {
        return clazz.getName().startsWith("org.hawkular.metrics") && (clazz.isAnnotationPresent(Path.class) || Arrays.stream(clazz.getMethods()).anyMatch(method -> method.isAnnotationPresent(Path.class)));
    }

    private boolean isRESTHandlerMethod(Method method) {
        return method.isAnnotationPresent(GET.class) || method.isAnnotationPresent(POST.class) || method.isAnnotationPresent(PUT.class) || method.isAnnotationPresent(DELETE.class) || method.isAnnotationPresent(HEAD.class) || method.isAnnotationPresent(OPTIONS.class);
    }

    private boolean isWrite(Method m, String uri) {
        return m.isAnnotationPresent(DELETE.class) || m.isAnnotationPresent(PUT.class) || m.isAnnotationPresent(POST.class) && !uri.endsWith("query");
    }

    private HTTPMethod getHttpMethod(Method m) {
        if (m.isAnnotationPresent(GET.class)) {
            return HTTPMethod.GET;
        }
        if (m.isAnnotationPresent(POST.class)) {
            return HTTPMethod.POST;
        }
        if (m.isAnnotationPresent(PUT.class)) {
            return HTTPMethod.PUT;
        }
        if (m.isAnnotationPresent(DELETE.class)) {
            return HTTPMethod.DELETE;
        }
        if (m.isAnnotationPresent(HEAD.class)) {
            return HTTPMethod.HEAD;
        }
        return HTTPMethod.OPTIONS;
    }

    private String getURI(Method method) {
        Path classLevelURI = method.getDeclaringClass().getAnnotation(Path.class);
        Path methodLevelURI = method.getAnnotation(Path.class);
        StringBuilder uri = new StringBuilder();
        if (classLevelURI != null) {
            uri.append(classLevelURI.value());
        }
        if (methodLevelURI != null) {
            uri.append(methodLevelURI.value());
        }
        if (uri.charAt(0) == '/') {
            uri.deleteCharAt(0);
        }
        return uri.toString();
    }

    private void register(RESTMetaData metaData) {
        logger.debugf("Registering meta data for %s ", (Object)metaData.getRESTMetricName().getName());
        HawkularMetricRegistry registry = MetricRegistryProvider.INSTANCE.getMetricRegistry();
        registry.registerMetaData((MetaData)metaData);
    }

    public Timer getTimer(String metricName) {
        return MetricRegistryProvider.INSTANCE.getMetricRegistry().timer(metricName);
    }
}

