/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.api.jaxrs.handler;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import java.util.Collection;
import java.util.Collections;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import org.hawkular.metrics.api.jaxrs.handler.CounterHandler;
import org.hawkular.metrics.core.api.Counter;
import org.hawkular.metrics.core.api.MetricsService;

@Path(value="/counters")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Api(value="", description="Availability metrics interface")
public class CounterHandler {
    @Inject
    private MetricsService metricsService;
    @HeaderParam(value="Hawkular-Tenant")
    private String tenantId;

    @POST
    @Path(value="/")
    @ApiOperation(value="List of counter definitions", hidden=true)
    public void updateCountersForGroups(@Suspended AsyncResponse asyncResponse, Collection<Counter> counters) {
        ListenableFuture future = this.metricsService.updateCounters(counters);
        Futures.addCallback((ListenableFuture)future, (FutureCallback)new NoDataCallback(asyncResponse));
    }

    @POST
    @Path(value="/{group}")
    @ApiOperation(value="Update multiple counters in a single counter group", hidden=true)
    public void updateCounterForGroup(@Suspended AsyncResponse asyncResponse, @PathParam(value="group") String group, Collection<Counter> counters) {
        for (Counter counter : counters) {
            counter.setGroup(group);
        }
        ListenableFuture future = this.metricsService.updateCounters(counters);
        Futures.addCallback((ListenableFuture)future, (FutureCallback)new NoDataCallback(asyncResponse));
    }

    @POST
    @Path(value="/{group}/{counter}")
    @ApiOperation(value="Increase value of a counter", hidden=true)
    public void updateCounter(@Suspended AsyncResponse asyncResponse, @PathParam(value="group") String group, @PathParam(value="counter") String counter) {
        ListenableFuture future = this.metricsService.updateCounter(new Counter("test", group, counter, 1L));
        Futures.addCallback((ListenableFuture)future, (FutureCallback)new NoDataCallback(asyncResponse));
    }

    @POST
    @Path(value="/{group}/{counter}/{value}")
    @ApiOperation(value="Update value of a counter", hidden=true)
    public void updateCounter(@Suspended AsyncResponse asyncResponse, @PathParam(value="group") String group, @PathParam(value="counter") String counter, @PathParam(value="value") Long value) {
        ListenableFuture future = this.metricsService.updateCounter(new Counter("test", group, counter, value.longValue()));
        Futures.addCallback((ListenableFuture)future, (FutureCallback)new NoDataCallback(asyncResponse));
    }

    @GET
    @Path(value="/{group}")
    @ApiOperation(value="Retrieve a list of counter values in this group", hidden=true, response=Counter.class, responseContainer="List")
    @Produces(value={"application/json"})
    public void getCountersForGroup(@Suspended AsyncResponse asyncResponse, @PathParam(value="group") String group) {
        ListenableFuture future = this.metricsService.findCounters(group);
        Futures.addCallback((ListenableFuture)future, (FutureCallback)new SimpleDataCallback(asyncResponse));
    }

    @GET
    @Path(value="/{group}/{counter}")
    @ApiOperation(value="Retrieve value of a counter", hidden=true, response=Counter.class, responseContainer="List")
    public void getCounter(@Suspended AsyncResponse asyncResponse, @PathParam(value="group") String group, @PathParam(value="counter") String counter) {
        ListenableFuture future = this.metricsService.findCounters(group, Collections.singletonList(counter));
        Futures.addCallback((ListenableFuture)future, (FutureCallback)new /* Unavailable Anonymous Inner Class!! */);
    }
}

