/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.api.jaxrs.handler;

import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.hawkular.metrics.api.jaxrs.ApiError;
import org.hawkular.metrics.api.jaxrs.handler.observer.MetricCreatedObserver;
import org.hawkular.metrics.api.jaxrs.handler.observer.ResultSetObserver;
import org.hawkular.metrics.api.jaxrs.param.Duration;
import org.hawkular.metrics.api.jaxrs.param.Tags;
import org.hawkular.metrics.api.jaxrs.request.TagRequest;
import org.hawkular.metrics.api.jaxrs.util.ApiUtils;
import org.hawkular.metrics.core.api.Availability;
import org.hawkular.metrics.core.api.AvailabilityData;
import org.hawkular.metrics.core.api.BucketedOutput;
import org.hawkular.metrics.core.api.Buckets;
import org.hawkular.metrics.core.api.Metric;
import org.hawkular.metrics.core.api.MetricId;
import org.hawkular.metrics.core.api.MetricType;
import org.hawkular.metrics.core.api.MetricsService;
import rx.Observable;
import rx.Observer;

@Path(value="/availability")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Api(value="", description="Availability metrics interface")
public class AvailabilityHandler {
    private static final long EIGHT_HOURS = TimeUnit.MILLISECONDS.convert(8L, TimeUnit.HOURS);
    @Inject
    private MetricsService metricsService;
    @HeaderParam(value="Hawkular-Tenant")
    private String tenantId;

    @POST
    @Path(value="/")
    @ApiOperation(value="Create availability metric definition. Same notes as creating gauge metric apply.")
    @ApiResponses(value={@ApiResponse(code=201, message="Metric definition created successfully"), @ApiResponse(code=400, message="Missing or invalid payload", response=ApiError.class), @ApiResponse(code=409, message="Availability metric with given id already exists", response=ApiError.class), @ApiResponse(code=500, message="Metric definition creation failed due to an unexpected error", response=ApiError.class)})
    public void createAvailabilityMetric(@Suspended AsyncResponse asyncResponse, @ApiParam(required=true) Availability metric, @Context UriInfo uriInfo) {
        if (metric == null) {
            asyncResponse.resume((Object)ApiUtils.emptyPayload());
            return;
        }
        metric.setTenantId(this.tenantId);
        URI location = uriInfo.getBaseUriBuilder().path("/availability/{id}").build(new Object[]{metric.getId().getName()});
        this.metricsService.createMetric((Metric)metric).subscribe((Observer)new MetricCreatedObserver(asyncResponse, location));
    }

    @GET
    @Path(value="/{id}")
    @ApiOperation(value="Retrieve single metric definition.", response=Metric.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Metric's definition was successfully retrieved."), @ApiResponse(code=204, message="Query was successful, but no metrics definition is set."), @ApiResponse(code=500, message="Unexpected error occurred while fetching metric's definition.", response=ApiError.class)})
    public void getAvailabilityMetric(@Suspended AsyncResponse asyncResponse, @HeaderParam(value="tenantId") String tenantId, @PathParam(value="id") String id) {
        this.metricsService.findMetric(tenantId, MetricType.AVAILABILITY, new MetricId(id)).subscribe(optional -> asyncResponse.resume((Object)ApiUtils.valueToResponse((Optional)optional)), t -> asyncResponse.resume((Object)ApiUtils.serverError((Throwable)t)));
    }

    @GET
    @Path(value="/{id}/tags")
    @ApiOperation(value="Retrieve tags associated with the metric definition.", response=String.class, responseContainer="Map")
    @ApiResponses(value={@ApiResponse(code=200, message="Metric's tags were successfully retrieved."), @ApiResponse(code=204, message="Query was successful, but no metrics were found."), @ApiResponse(code=500, message="Unexpected error occurred while fetching metric's tags.", response=ApiError.class)})
    public void getAvailabilityMetricTags(@Suspended AsyncResponse asyncResponse, @PathParam(value="id") String id) {
        this.metricsService.getMetricTags(this.tenantId, MetricType.AVAILABILITY, new MetricId(id)).subscribe(optional -> asyncResponse.resume((Object)ApiUtils.valueToResponse((Optional)optional)), t -> asyncResponse.resume((Object)ApiUtils.serverError((Throwable)t)));
    }

    @PUT
    @Path(value="/{id}/tags")
    @ApiOperation(value="Update tags associated with the metric definition.")
    @ApiResponses(value={@ApiResponse(code=200, message="Metric's tags were successfully updated."), @ApiResponse(code=500, message="Unexpected error occurred while updating metric's tags.", response=ApiError.class)})
    public void updateAvailabilityMetricTags(@Suspended AsyncResponse asyncResponse, @PathParam(value="id") String id, @ApiParam(required=true) Map<String, String> tags) {
        Availability metric = new Availability(this.tenantId, new MetricId(id));
        this.metricsService.addTags((Metric)metric, tags).subscribe((Observer)new ResultSetObserver(asyncResponse));
    }

    @DELETE
    @Path(value="/{id}/tags/{tags}")
    @ApiOperation(value="Delete tags associated with the metric definition.")
    @ApiResponses(value={@ApiResponse(code=200, message="Metric's tags were successfully deleted."), @ApiResponse(code=400, message="Invalid tags", response=ApiError.class), @ApiResponse(code=500, message="Unexpected error occurred while trying to delete metric's tags.", response=ApiError.class)})
    public void deleteAvailabilityMetricTags(@Suspended AsyncResponse asyncResponse, @PathParam(value="id") String id, @ApiParam(value="Tag list") @PathParam(value="tags") Tags tags) {
        Availability metric = new Availability(this.tenantId, new MetricId(id));
        this.metricsService.deleteTags((Metric)metric, tags.getTags()).subscribe((Observer)new ResultSetObserver(asyncResponse));
    }

    @POST
    @Path(value="/{id}/data")
    @ApiOperation(value="Add data for a single availability metric.")
    @ApiResponses(value={@ApiResponse(code=200, message="Adding data succeeded."), @ApiResponse(code=400, message="Missing or invalid payload", response=ApiError.class), @ApiResponse(code=500, message="Unexpected error happened while storing the data", response=ApiError.class)})
    public void addAvailabilityForMetric(@Suspended AsyncResponse asyncResponse, @PathParam(value="id") String id, @ApiParam(value="List of availability datapoints", required=true) List<AvailabilityData> data) {
        if (data == null) {
            asyncResponse.resume((Object)ApiUtils.emptyPayload());
        } else {
            Availability metric = new Availability(this.tenantId, new MetricId(id));
            metric.getData().addAll(data);
            this.metricsService.addAvailabilityData(Collections.singletonList(metric)).subscribe((Observer)new ResultSetObserver(asyncResponse));
        }
    }

    @POST
    @Path(value="/data")
    @ApiOperation(value="Add metric data for multiple availability metrics in a single call.")
    @ApiResponses(value={@ApiResponse(code=200, message="Adding data succeeded."), @ApiResponse(code=500, message="Unexpected error happened while storing the data", response=ApiError.class)})
    public void addAvailabilityData(@Suspended AsyncResponse asyncResponse, @ApiParam(value="List of availability metrics", required=true) List<Availability> metrics) {
        if (metrics.isEmpty()) {
            asyncResponse.resume((Object)Response.ok().build());
        } else {
            metrics.forEach(m -> m.setTenantId(this.tenantId));
            this.metricsService.addAvailabilityData(metrics).subscribe((Observer)new ResultSetObserver(asyncResponse));
        }
    }

    @GET
    @Path(value="/")
    @ApiOperation(value="Find availabilities metrics data by their tags.", response=Map.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=200, message="Successfully fetched data."), @ApiResponse(code=204, message="No matching data found."), @ApiResponse(code=400, message="Missing or invalid tags query", response=ApiError.class), @ApiResponse(code=500, message="Any error in the query.", response=ApiError.class)})
    public void findAvailabilityDataByTags(@Suspended AsyncResponse asyncResponse, @ApiParam(value="Tag list", required=true) @QueryParam(value="tags") Tags tags) {
        if (tags == null) {
            asyncResponse.resume((Object)ApiUtils.badRequest((ApiError)new ApiError("Missing tags query")));
        } else {
            this.metricsService.findAvailabilityByTags(this.tenantId, tags.getTags()).subscribe(m -> {
                if (m.isEmpty()) {
                    asyncResponse.resume((Object)Response.noContent().build());
                } else {
                    asyncResponse.resume((Object)Response.ok((Object)m).build());
                }
            }, t -> asyncResponse.resume((Object)Response.serverError().entity((Object)new ApiError(t.getMessage())).build()));
        }
    }

    @GET
    @Path(value="/{id}/data")
    @ApiOperation(value="Retrieve availability data. When buckets or bucketDuration query parameter is used, the time range between start and end will be divided in buckets of equal duration, and availability statistics will be computed for each bucket.", response=List.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Successfully fetched availability data."), @ApiResponse(code=204, message="No availability data was found."), @ApiResponse(code=400, message="buckets or bucketDuration parameter is invalid, or both are used.", response=ApiError.class), @ApiResponse(code=500, message="Unexpected error occurred while fetching availability data.", response=ApiError.class)})
    public void findAvailabilityData(@Suspended AsyncResponse asyncResponse, @PathParam(value="id") String id, @ApiParam(value="Defaults to now - 8 hours") @QueryParam(value="start") Long start, @ApiParam(value="Defaults to now") @QueryParam(value="end") Long end, @ApiParam(value="Total number of buckets") @QueryParam(value="buckets") Integer bucketsCount, @ApiParam(value="Bucket duration") @QueryParam(value="bucketDuration") Duration bucketDuration, @ApiParam(value="Set to true to return only distinct, contiguous values") @QueryParam(value="distinct") @DefaultValue(value="false") Boolean distinct) {
        long now = System.currentTimeMillis();
        Long startTime = start == null ? now - EIGHT_HOURS : start;
        Long endTime = end == null ? now : end;
        Availability metric = new Availability(this.tenantId, new MetricId(id));
        if (bucketsCount == null && bucketDuration == null) {
            this.metricsService.findAvailabilityData(this.tenantId, metric.getId(), startTime.longValue(), endTime.longValue(), distinct.booleanValue()).toList().map(ApiUtils::collectionToResponse).subscribe(r -> asyncResponse.resume(r), t -> ApiUtils.serverError((Throwable)t));
        } else if (bucketsCount != null && bucketDuration != null) {
            asyncResponse.resume((Object)ApiUtils.badRequest((ApiError)new ApiError("Both buckets and bucketDuration parameters are used")));
        } else {
            Buckets buckets;
            try {
                buckets = bucketsCount != null ? Buckets.fromCount((long)startTime, (long)endTime, (int)bucketsCount) : Buckets.fromStep((long)startTime, (long)endTime, (long)bucketDuration.toMillis());
            }
            catch (IllegalArgumentException e) {
                asyncResponse.resume((Object)ApiUtils.badRequest((ApiError)new ApiError("Bucket: " + e.getMessage())));
                return;
            }
            this.metricsService.findAvailabilityStats(metric, startTime.longValue(), endTime.longValue(), buckets).map(BucketedOutput::getData).map(ApiUtils::collectionToResponse).subscribe(r -> asyncResponse.resume(r), t -> ApiUtils.serverError((Throwable)t));
        }
    }

    @POST
    @Path(value="/{id}/tag")
    @ApiOperation(value="Add or update availability metric's tags.")
    @ApiResponses(value={@ApiResponse(code=200, message="Tags were modified successfully.")})
    public void tagAvailabilityData(@Suspended AsyncResponse asyncResponse, @PathParam(value="id") String id, @ApiParam(required=true) TagRequest params) {
        Availability metric = new Availability(this.tenantId, new MetricId(id));
        Observable resultSetObservable = params.getTimestamp() != null ? this.metricsService.tagAvailabilityData(metric, params.getTags(), params.getTimestamp().longValue()) : this.metricsService.tagAvailabilityData(metric, params.getTags(), params.getStart().longValue(), params.getEnd().longValue());
        resultSetObservable.subscribe((Observer)new ResultSetObserver(asyncResponse));
    }

    @GET
    @Path(value="/tags/{tags}")
    @ApiOperation(value="Find availability metric data with given tags.", response=Map.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=200, message="Availability values fetched successfully"), @ApiResponse(code=204, message="No matching data found."), @ApiResponse(code=400, message="Invalid tags", response=ApiError.class), @ApiResponse(code=500, message="Any error while fetching data.", response=ApiError.class)})
    public void findTaggedAvailabilityData(@Suspended AsyncResponse asyncResponse, @ApiParam(value="Tag list") @PathParam(value="tags") Tags tags) {
        this.metricsService.findAvailabilityByTags(this.tenantId, tags.getTags()).subscribe(m -> {
            if (m.isEmpty()) {
                asyncResponse.resume((Object)Response.noContent().build());
            } else {
                asyncResponse.resume((Object)Response.ok((Object)m).build());
            }
        }, t -> asyncResponse.resume((Object)Response.serverError().entity((Object)new ApiError(t.getMessage())).build()));
    }
}

