/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.api.jaxrs.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.InjectionPoint;
import org.hawkular.metrics.api.jaxrs.config.Configurable;
import org.hawkular.metrics.api.jaxrs.config.ConfigurationKey;
import org.hawkular.metrics.api.jaxrs.config.ConfigurationProperty;

@ApplicationScoped
public class ConfigurableProducer {
    static final String METRICS_CONF = "metrics.conf";
    private ConcurrentMap<String, Optional<String>> effectiveConfiguration;

    @PostConstruct
    void init() {
        this.effectiveConfiguration = new ConcurrentHashMap(ConfigurationKey.values().length);
        Properties defaultProperties = this.defaultProperties();
        Properties fileProperties = this.configurationFile().map(arg_0 -> this.configurationFileProperties(arg_0)).orElse(new Properties());
        for (ConfigurationKey configurationKey : ConfigurationKey.values()) {
            String k = configurationKey.getExternalForm();
            String v = System.getProperty(k);
            if (v == null && (v = fileProperties.getProperty(k)) == null) {
                v = defaultProperties.getProperty(k);
            }
            this.effectiveConfiguration.put(k, Optional.ofNullable(v));
        }
    }

    @Produces
    @Configurable
    String getConfigurationPropertyAsString(InjectionPoint injectionPoint) {
        ConfigurationProperty configProp = (ConfigurationProperty)injectionPoint.getAnnotated().getAnnotation(ConfigurationProperty.class);
        if (configProp == null) {
            String message = "Any field or parameter annotated with @Configurable must also be annotated with @ConfigurationProperty";
            throw new IllegalArgumentException(message);
        }
        String propertyName = configProp.value().getExternalForm();
        return this.lookupConfigurationProperty(propertyName);
    }

    private String lookupConfigurationProperty(String propertyName) {
        return ((Optional)this.effectiveConfiguration.get(propertyName)).orElse(null);
    }

    private Optional<File> configurationFile() {
        String configurationFilePath = System.getProperty(METRICS_CONF);
        if (configurationFilePath != null) {
            File file = new File(configurationFilePath);
            this.checkExplicitConfigurationFile(file);
            return Optional.of(file);
        }
        File file = new File(System.getProperty("user.home"), ".metrics.conf");
        if (!file.exists()) {
            return Optional.empty();
        }
        this.checkConfigurationFile(file);
        return Optional.of(file);
    }

    private void checkExplicitConfigurationFile(File file) {
        if (!file.exists()) {
            throw new IllegalArgumentException(file + " does not exist");
        }
        this.checkConfigurationFile(file);
    }

    private void checkConfigurationFile(File file) {
        if (!file.isFile()) {
            throw new IllegalArgumentException(file + " is not a regular file");
        }
        if (!file.canRead()) {
            throw new IllegalArgumentException(file + " is not readable");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Properties defaultProperties() {
        try (InputStream input = this.getClass().getClassLoader().getResourceAsStream("META-INF/metrics.conf");){
            Properties properties = new Properties();
            properties.load(input);
            Properties properties2 = properties;
            return properties2;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Properties configurationFileProperties(File file) {
        try (FileInputStream input = new FileInputStream(file);){
            Properties properties = new Properties();
            properties.load(input);
            Properties properties2 = properties;
            return properties2;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

