/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.api.jaxrs;

import com.google.common.base.Function;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.hawkular.metrics.api.jaxrs.ApiError;
import org.hawkular.metrics.api.jaxrs.callback.MetricCreatedCallback;
import org.hawkular.metrics.api.jaxrs.callback.NoDataCallback;
import org.hawkular.metrics.api.jaxrs.callback.SimpleDataCallback;
import org.hawkular.metrics.api.jaxrs.param.Duration;
import org.hawkular.metrics.api.jaxrs.param.Tags;
import org.hawkular.metrics.api.jaxrs.util.ApiUtils;
import org.hawkular.metrics.core.api.Availability;
import org.hawkular.metrics.core.api.AvailabilityMetric;
import org.hawkular.metrics.core.api.BucketedOutput;
import org.hawkular.metrics.core.api.Buckets;
import org.hawkular.metrics.core.api.Counter;
import org.hawkular.metrics.core.api.Metric;
import org.hawkular.metrics.core.api.MetricId;
import org.hawkular.metrics.core.api.MetricType;
import org.hawkular.metrics.core.api.MetricsService;
import org.hawkular.metrics.core.api.NumericData;
import org.hawkular.metrics.core.api.NumericMetric;
import org.hawkular.metrics.core.impl.request.TagRequest;

@Path(value="/")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Api(value="/", description="Metrics related REST interface")
public class MetricHandler {
    private static final long EIGHT_HOURS = TimeUnit.MILLISECONDS.convert(8L, TimeUnit.HOURS);
    @Inject
    private MetricsService metricsService;

    @POST
    @Path(value="/{tenantId}/metrics/numeric")
    @ApiOperation(value="Create numeric metric definition.", notes="Clients are not required to explicitly create a metric before storing data. Doing so however allows clients to prevent naming collisions and to specify tags and data retention.")
    @ApiResponses(value={@ApiResponse(code=201, message="Metric definition created successfully"), @ApiResponse(code=400, message="Missing or invalid payload", response=ApiError.class), @ApiResponse(code=409, message="Numeric metric with given id already exists", response=ApiError.class), @ApiResponse(code=500, message="Metric definition creation failed due to an unexpected error", response=ApiError.class)})
    public void createNumericMetric(@Suspended AsyncResponse asyncResponse, @PathParam(value="tenantId") String tenantId, @ApiParam(required=true) NumericMetric metric, @Context UriInfo uriInfo) {
        if (metric == null) {
            Response response = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new ApiError("Payload is empty")).build();
            asyncResponse.resume((Object)response);
            return;
        }
        metric.setTenantId(tenantId);
        ListenableFuture future = this.metricsService.createMetric((Metric)metric);
        URI created = uriInfo.getBaseUriBuilder().path("/{tenantId}/metrics/numeric/{id}").build(new Object[]{tenantId, metric.getId().getName()});
        MetricCreatedCallback metricCreatedCallback = new MetricCreatedCallback(asyncResponse, created);
        Futures.addCallback((ListenableFuture)future, (FutureCallback)metricCreatedCallback);
    }

    @POST
    @Path(value="/{tenantId}/metrics/availability")
    @ApiOperation(value="Create availability metric definition. Same notes as creating numeric metric apply.")
    @ApiResponses(value={@ApiResponse(code=201, message="Metric definition created successfully"), @ApiResponse(code=400, message="Missing or invalid payload", response=ApiError.class), @ApiResponse(code=409, message="Numeric metric with given id already exists", response=ApiError.class), @ApiResponse(code=500, message="Metric definition creation failed due to an unexpected error", response=ApiError.class)})
    public void createAvailabilityMetric(@Suspended AsyncResponse asyncResponse, @PathParam(value="tenantId") String tenantId, @ApiParam(required=true) AvailabilityMetric metric, @Context UriInfo uriInfo) {
        if (metric == null) {
            Response response = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new ApiError("Payload is empty")).build();
            asyncResponse.resume((Object)response);
            return;
        }
        metric.setTenantId(tenantId);
        ListenableFuture future = this.metricsService.createMetric((Metric)metric);
        URI created = uriInfo.getBaseUriBuilder().path("/{tenantId}/metrics/availability/{id}").build(new Object[]{tenantId, metric.getId().getName()});
        MetricCreatedCallback metricCreatedCallback = new MetricCreatedCallback(asyncResponse, created);
        Futures.addCallback((ListenableFuture)future, (FutureCallback)metricCreatedCallback);
    }

    @GET
    @Path(value="/{tenantId}/metrics/numeric/{id}/tags")
    @ApiOperation(value="Retrieve tags associated with the metric definition.", response=Metric.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Metric's tags were successfully retrieved."), @ApiResponse(code=204, message="Query was successful, but no metrics were found."), @ApiResponse(code=500, message="Unexpected error occurred while fetching metric's tags.", response=ApiError.class)})
    public void getNumericMetricTags(@Suspended AsyncResponse asyncResponse, @PathParam(value="tenantId") String tenantId, @PathParam(value="id") String id) {
        ApiUtils.executeAsync((AsyncResponse)asyncResponse, () -> {
            ListenableFuture future = this.metricsService.findMetric(tenantId, MetricType.NUMERIC, new MetricId(id));
            return Futures.transform((ListenableFuture)future, (Function)ApiUtils.MAP_VALUE);
        });
    }

    @PUT
    @Path(value="/{tenantId}/metrics/numeric/{id}/tags")
    @ApiOperation(value="Update tags associated with the metric definition.")
    @ApiResponses(value={@ApiResponse(code=200, message="Metric's tags were successfully updated."), @ApiResponse(code=500, message="Unexpected error occurred while updating metric's tags.", response=ApiError.class)})
    public void updateNumericMetricTags(@Suspended AsyncResponse asyncResponse, @PathParam(value="tenantId") String tenantId, @PathParam(value="id") String id, @ApiParam(required=true) Map<String, String> tags) {
        ApiUtils.executeAsync((AsyncResponse)asyncResponse, () -> {
            NumericMetric metric = new NumericMetric(tenantId, new MetricId(id));
            ListenableFuture future = this.metricsService.addTags((Metric)metric, tags);
            return Futures.transform((ListenableFuture)future, (Function)ApiUtils.MAP_VOID);
        });
    }

    @DELETE
    @Path(value="/{tenantId}/metrics/numeric/{id}/tags/{tags}")
    @ApiOperation(value="Delete tags associated with the metric definition.")
    @ApiResponses(value={@ApiResponse(code=200, message="Metric's tags were successfully deleted."), @ApiResponse(code=400, message="Invalid tags", response=ApiError.class), @ApiResponse(code=500, message="Unexpected error occurred while trying to delete metric's tags.", response=ApiError.class)})
    public void deleteNumericMetricTags(@Suspended AsyncResponse asyncResponse, @PathParam(value="tenantId") String tenantId, @PathParam(value="id") String id, @ApiParam(value="Tag list") @PathParam(value="tags") Tags tags) {
        ApiUtils.executeAsync((AsyncResponse)asyncResponse, () -> {
            NumericMetric metric = new NumericMetric(tenantId, new MetricId(id));
            ListenableFuture future = this.metricsService.deleteTags((Metric)metric, tags.getTags());
            return Futures.transform((ListenableFuture)future, (Function)ApiUtils.MAP_VOID);
        });
    }

    @GET
    @Path(value="/{tenantId}/metrics/availability/{id}/tags")
    @ApiOperation(value="Retrieve tags associated with the metric definition.", response=Map.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Metric's tags were successfully retrieved."), @ApiResponse(code=204, message="Query was successful, but no metrics were found."), @ApiResponse(code=500, message="Unexpected error occurred while fetching metric's tags.", response=ApiError.class)})
    public void getAvailabilityMetricTags(@Suspended AsyncResponse asyncResponse, @PathParam(value="tenantId") String tenantId, @PathParam(value="id") String id) {
        ApiUtils.executeAsync((AsyncResponse)asyncResponse, () -> {
            ListenableFuture future = this.metricsService.findMetric(tenantId, MetricType.AVAILABILITY, new MetricId(id));
            return Futures.transform((ListenableFuture)future, (Function)ApiUtils.MAP_VALUE);
        });
    }

    @PUT
    @Path(value="/{tenantId}/metrics/availability/{id}/tags")
    @ApiOperation(value="Update tags associated with the metric definition.")
    @ApiResponses(value={@ApiResponse(code=200, message="Metric's tags were successfully updated."), @ApiResponse(code=500, message="Unexpected error occurred while updating metric's tags.", response=ApiError.class)})
    public void updateAvailabilityMetricTags(@Suspended AsyncResponse asyncResponse, @PathParam(value="tenantId") String tenantId, @PathParam(value="id") String id, @ApiParam(required=true) Map<String, String> tags) {
        ApiUtils.executeAsync((AsyncResponse)asyncResponse, () -> {
            AvailabilityMetric metric = new AvailabilityMetric(tenantId, new MetricId(id));
            ListenableFuture future = this.metricsService.addTags((Metric)metric, tags);
            return Futures.transform((ListenableFuture)future, (Function)ApiUtils.MAP_VOID);
        });
    }

    @DELETE
    @Path(value="/{tenantId}/metrics/availability/{id}/tags/{tags}")
    @ApiOperation(value="Delete tags associated with the metric definition.")
    @ApiResponses(value={@ApiResponse(code=200, message="Metric's tags were successfully deleted."), @ApiResponse(code=400, message="Invalid tags", response=ApiError.class), @ApiResponse(code=500, message="Unexpected error occurred while trying to delete metric's tags.", response=ApiError.class)})
    public void deleteAvailabilityMetricTags(@Suspended AsyncResponse asyncResponse, @PathParam(value="tenantId") String tenantId, @PathParam(value="id") String id, @ApiParam(value="Tag list") @PathParam(value="tags") Tags tags) {
        ApiUtils.executeAsync((AsyncResponse)asyncResponse, () -> {
            AvailabilityMetric metric = new AvailabilityMetric(tenantId, new MetricId(id));
            ListenableFuture future = this.metricsService.deleteTags((Metric)metric, tags.getTags());
            return Futures.transform((ListenableFuture)future, (Function)ApiUtils.MAP_VOID);
        });
    }

    @POST
    @Path(value="/{tenantId}/metrics/numeric/{id}/data")
    @ApiOperation(value="Add data for a single numeric metric.")
    @ApiResponses(value={@ApiResponse(code=200, message="Adding data succeeded."), @ApiResponse(code=400, message="Missing or invalid payload", response=ApiError.class), @ApiResponse(code=500, message="Unexpected error happened while storing the data", response=ApiError.class)})
    public void addDataForMetric(@Suspended AsyncResponse asyncResponse, @PathParam(value="tenantId") String tenantId, @PathParam(value="id") String id, @ApiParam(value="List of datapoints containing timestamp and value", required=true) List<NumericData> data) {
        ApiUtils.executeAsync((AsyncResponse)asyncResponse, () -> {
            if (data == null) {
                return ApiUtils.emptyPayload();
            }
            NumericMetric metric = new NumericMetric(tenantId, new MetricId(id));
            metric.getData().addAll(data);
            ListenableFuture future = this.metricsService.addNumericData(Collections.singletonList(metric));
            return Futures.transform((ListenableFuture)future, (Function)ApiUtils.MAP_VOID);
        });
    }

    @POST
    @Path(value="/{tenantId}/metrics/availability/{id}/data")
    @ApiOperation(value="Add data for a single availability metric.")
    @ApiResponses(value={@ApiResponse(code=200, message="Adding data succeeded."), @ApiResponse(code=400, message="Missing or invalid payload", response=ApiError.class), @ApiResponse(code=500, message="Unexpected error happened while storing the data", response=ApiError.class)})
    public void addAvailabilityForMetric(@Suspended AsyncResponse asyncResponse, @PathParam(value="tenantId") String tenantId, @PathParam(value="id") String id, @ApiParam(value="List of availability datapoints", required=true) List<Availability> data) {
        ApiUtils.executeAsync((AsyncResponse)asyncResponse, () -> {
            if (data == null) {
                return ApiUtils.emptyPayload();
            }
            AvailabilityMetric metric = new AvailabilityMetric(tenantId, new MetricId(id));
            metric.getData().addAll(data);
            ListenableFuture future = this.metricsService.addAvailabilityData(Collections.singletonList(metric));
            return Futures.transform((ListenableFuture)future, (Function)ApiUtils.MAP_VOID);
        });
    }

    @POST
    @Path(value="/{tenantId}/metrics/numeric/data")
    @ApiOperation(value="Add metric data for multiple numeric metrics in a single call.")
    @ApiResponses(value={@ApiResponse(code=200, message="Adding data succeeded."), @ApiResponse(code=500, message="Unexpected error happened while storing the data", response=ApiError.class)})
    public void addNumericData(@Suspended AsyncResponse asyncResponse, @PathParam(value="tenantId") String tenantId, @ApiParam(value="List of metrics", required=true) List<NumericMetric> metrics) {
        ApiUtils.executeAsync((AsyncResponse)asyncResponse, () -> {
            if (metrics.isEmpty()) {
                return Futures.immediateFuture((Object)Response.ok().build());
            }
            metrics.forEach(m -> m.setTenantId(tenantId));
            ListenableFuture future = this.metricsService.addNumericData(metrics);
            return Futures.transform((ListenableFuture)future, (Function)ApiUtils.MAP_VOID);
        });
    }

    @POST
    @Path(value="/{tenantId}/metrics/availability/data")
    @ApiOperation(value="Add metric data for multiple availability metrics in a single call.")
    @ApiResponses(value={@ApiResponse(code=200, message="Adding data succeeded."), @ApiResponse(code=500, message="Unexpected error happened while storing the data", response=ApiError.class)})
    public void addAvailabilityData(@Suspended AsyncResponse asyncResponse, @PathParam(value="tenantId") String tenantId, @ApiParam(value="List of availability metrics", required=true) List<AvailabilityMetric> metrics) {
        ApiUtils.executeAsync((AsyncResponse)asyncResponse, () -> {
            if (metrics.isEmpty()) {
                return Futures.immediateFuture((Object)Response.ok().build());
            }
            metrics.forEach(m -> m.setTenantId(tenantId));
            ListenableFuture future = this.metricsService.addAvailabilityData(metrics);
            return Futures.transform((ListenableFuture)future, (Function)ApiUtils.MAP_VOID);
        });
    }

    @GET
    @Path(value="/{tenantId}/numeric")
    @ApiOperation(value="Find numeric metrics data by their tags.", response=Map.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=200, message="Successfully fetched data."), @ApiResponse(code=204, message="No matching data found."), @ApiResponse(code=400, message="Missing or invalid tags query", response=ApiError.class), @ApiResponse(code=500, message="Any error in the query.", response=ApiError.class)})
    public void findNumericDataByTags(@Suspended AsyncResponse asyncResponse, @PathParam(value="tenantId") String tenantId, @ApiParam(value="Tag list", required=true) @QueryParam(value="tags") Tags tags) {
        ApiUtils.executeAsync((AsyncResponse)asyncResponse, () -> {
            if (tags == null) {
                return ApiUtils.badRequest((ApiError)new ApiError("Missing tags query"));
            }
            ListenableFuture future = this.metricsService.findNumericDataByTags(tenantId, tags.getTags());
            return Futures.transform((ListenableFuture)future, (Function)ApiUtils.MAP_MAP);
        });
    }

    @GET
    @Path(value="/{tenantId}/availability")
    @ApiOperation(value="Find availabilities metrics data by their tags.", response=Map.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=200, message="Successfully fetched data."), @ApiResponse(code=204, message="No matching data found."), @ApiResponse(code=400, message="Missing or invalid tags query", response=ApiError.class), @ApiResponse(code=500, message="Any error in the query.", response=ApiError.class)})
    public void findAvailabilityDataByTags(@Suspended AsyncResponse asyncResponse, @PathParam(value="tenantId") String tenantId, @ApiParam(value="Tag list", required=true) @QueryParam(value="tags") Tags tags) {
        ApiUtils.executeAsync((AsyncResponse)asyncResponse, () -> {
            if (tags == null) {
                return ApiUtils.badRequest((ApiError)new ApiError("Missing tags query"));
            }
            ListenableFuture future = this.metricsService.findAvailabilityByTags(tenantId, tags.getTags());
            return Futures.transform((ListenableFuture)future, (Function)ApiUtils.MAP_MAP);
        });
    }

    @GET
    @Path(value="/{tenantId}/metrics/numeric/{id}/data")
    @ApiOperation(value="Retrieve numeric data. When buckets or bucketDuration query parameter is used, the time range between start and end will be divided in buckets of equal duration, and metric statistics will be computed for each bucket.", response=List.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Successfully fetched numeric data."), @ApiResponse(code=204, message="No numeric data was found."), @ApiResponse(code=400, message="buckets or bucketDuration parameter is invalid, or both are used.", response=ApiError.class), @ApiResponse(code=500, message="Unexpected error occurred while fetching numeric data.", response=ApiError.class)})
    public void findNumericData(@Suspended AsyncResponse asyncResponse, @PathParam(value="tenantId") String tenantId, @PathParam(value="id") String id, @ApiParam(value="Defaults to now - 8 hours") @QueryParam(value="start") Long start, @ApiParam(value="Defaults to now") @QueryParam(value="end") Long end, @ApiParam(value="Total number of buckets") @QueryParam(value="buckets") Integer bucketsCount, @ApiParam(value="Bucket duration") @QueryParam(value="bucketDuration") Duration bucketDuration) {
        ApiUtils.executeAsync((AsyncResponse)asyncResponse, () -> {
            Buckets buckets;
            long now = System.currentTimeMillis();
            long startTime = start == null ? now - EIGHT_HOURS : start;
            long endTime = end == null ? now : end;
            NumericMetric metric = new NumericMetric(tenantId, new MetricId(id));
            if (bucketsCount == null && bucketDuration == null) {
                ListenableFuture dataFuture = this.metricsService.findNumericData(tenantId, new MetricId(id), Long.valueOf(startTime), Long.valueOf(endTime));
                return Futures.transform((ListenableFuture)dataFuture, (Function)ApiUtils.MAP_COLLECTION);
            }
            if (bucketsCount != null && bucketDuration != null) {
                return ApiUtils.badRequest((ApiError)new ApiError("Both buckets and bucketDuration parameters are used"));
            }
            try {
                buckets = bucketsCount != null ? Buckets.fromCount((long)startTime, (long)endTime, (int)bucketsCount) : Buckets.fromStep((long)startTime, (long)endTime, (long)bucketDuration.toMillis());
            }
            catch (IllegalArgumentException e) {
                return ApiUtils.badRequest((ApiError)new ApiError("Bucket: " + e.getMessage()));
            }
            ListenableFuture dataFuture = this.metricsService.findNumericStats(metric, startTime, endTime, buckets);
            ListenableFuture outputFuture = Futures.transform((ListenableFuture)dataFuture, BucketedOutput::getData);
            return Futures.transform((ListenableFuture)outputFuture, (Function)ApiUtils.MAP_COLLECTION);
        });
    }

    @GET
    @Path(value="/{tenantId}/metrics/numeric/{id}/periods")
    @ApiOperation(value="Retrieve periods for which the condition holds true for each consecutive data point.", response=List.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Successfully fetched periods."), @ApiResponse(code=204, message="No numeric data was found."), @ApiResponse(code=400, message="Missing or invalid query parameters")})
    public void findPeriods(@Suspended AsyncResponse asyncResponse, @PathParam(value="tenantId") String tenantId, @PathParam(value="id") String id, @ApiParam(value="Defaults to now - 8 hours", required=false) @QueryParam(value="start") Long start, @ApiParam(value="Defaults to now", required=false) @QueryParam(value="end") Long end, @ApiParam(value="A threshold against which values are compared", required=true) @QueryParam(value="threshold") double threshold, @ApiParam(value="A comparison operation to perform between values and the threshold. Supported operations include ge, gte, lt, lte, and eq", required=true) @QueryParam(value="op") String operator) {
        ApiUtils.executeAsync((AsyncResponse)asyncResponse, () -> {
            Predicate<Double> predicate;
            long now = System.currentTimeMillis();
            Long startTime = start;
            Long endTime = end;
            if (start == null) {
                startTime = now - EIGHT_HOURS;
            }
            if (end == null) {
                endTime = now;
            }
            switch (operator) {
                case "lt": {
                    predicate = d2 -> d2 < threshold;
                    break;
                }
                case "lte": {
                    predicate = d2 -> d2 <= threshold;
                    break;
                }
                case "eq": {
                    predicate = d2 -> d2 == threshold;
                    break;
                }
                case "neq": {
                    predicate = d2 -> d2 != threshold;
                    break;
                }
                case "gt": {
                    predicate = d2 -> d2 > threshold;
                    break;
                }
                case "gte": {
                    predicate = d2 -> d2 >= threshold;
                    break;
                }
                default: {
                    predicate = null;
                }
            }
            if (predicate == null) {
                return ApiUtils.badRequest((ApiError)new ApiError("Invalid value for op parameter. Supported values are lt, lte, eq, gt, gte."));
            }
            ListenableFuture future = this.metricsService.getPeriods(tenantId, new MetricId(id), predicate, startTime.longValue(), endTime.longValue());
            return Futures.transform((ListenableFuture)future, (Function)ApiUtils.MAP_COLLECTION);
        });
    }

    @GET
    @Path(value="/{tenantId}/metrics/availability/{id}/data")
    @ApiOperation(value="Retrieve availability data. When buckets or bucketDuration query parameter is used, the time range between start and end will be divided in buckets of equal duration, and availability statistics will be computed for each bucket.", response=List.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Successfully fetched availability data."), @ApiResponse(code=204, message="No availability data was found."), @ApiResponse(code=400, message="buckets or bucketDuration parameter is invalid, or both are used.", response=ApiError.class), @ApiResponse(code=500, message="Unexpected error occurred while fetching availability data.", response=ApiError.class)})
    public void findAvailabilityData(@Suspended AsyncResponse asyncResponse, @PathParam(value="tenantId") String tenantId, @PathParam(value="id") String id, @ApiParam(value="Defaults to now - 8 hours") @QueryParam(value="start") Long start, @ApiParam(value="Defaults to now") @QueryParam(value="end") Long end, @ApiParam(value="Total number of buckets") @QueryParam(value="buckets") Integer bucketsCount, @ApiParam(value="Bucket duration") @QueryParam(value="bucketDuration") Duration bucketDuration) {
        ApiUtils.executeAsync((AsyncResponse)asyncResponse, () -> {
            Buckets buckets;
            long now = System.currentTimeMillis();
            Long startTime = start == null ? now - EIGHT_HOURS : start;
            Long endTime = end == null ? now : end;
            AvailabilityMetric metric = new AvailabilityMetric(tenantId, new MetricId(id));
            if (bucketsCount == null && bucketDuration == null) {
                ListenableFuture dataFuture = this.metricsService.findAvailabilityData(tenantId, metric.getId(), startTime.longValue(), endTime.longValue());
                return Futures.transform((ListenableFuture)dataFuture, (Function)ApiUtils.MAP_COLLECTION);
            }
            if (bucketsCount != null && bucketDuration != null) {
                return ApiUtils.badRequest((ApiError)new ApiError("Both buckets and bucketDuration parameters are used"));
            }
            try {
                buckets = bucketsCount != null ? Buckets.fromCount((long)startTime, (long)endTime, (int)bucketsCount) : Buckets.fromStep((long)startTime, (long)endTime, (long)bucketDuration.toMillis());
            }
            catch (IllegalArgumentException e) {
                return ApiUtils.badRequest((ApiError)new ApiError("Bucket: " + e.getMessage()));
            }
            ListenableFuture dataFuture = this.metricsService.findAvailabilityStats(metric, startTime.longValue(), endTime.longValue(), buckets);
            ListenableFuture outputFuture = Futures.transform((ListenableFuture)dataFuture, BucketedOutput::getData);
            return Futures.transform((ListenableFuture)outputFuture, (Function)ApiUtils.MAP_COLLECTION);
        });
    }

    @POST
    @Path(value="/{tenantId}/metrics/numeric/{id}/tag")
    @ApiOperation(value="Add or update numeric metric's tags.")
    @ApiResponses(value={@ApiResponse(code=200, message="Tags were modified successfully.")})
    public void tagNumericData(@Suspended AsyncResponse asyncResponse, @PathParam(value="tenantId") String tenantId, @PathParam(value="id") String id, @ApiParam(required=true) TagRequest params) {
        ApiUtils.executeAsync((AsyncResponse)asyncResponse, () -> {
            NumericMetric metric = new NumericMetric(tenantId, new MetricId(id));
            ListenableFuture future = params.getTimestamp() != null ? this.metricsService.tagNumericData(metric, params.getTags(), params.getTimestamp().longValue()) : this.metricsService.tagNumericData(metric, params.getTags(), params.getStart().longValue(), params.getEnd().longValue());
            return Futures.transform((ListenableFuture)future, data -> Response.ok().build());
        });
    }

    @POST
    @Path(value="/{tenantId}/metrics/availability/{id}/tag")
    @ApiOperation(value="Add or update availability metric's tags.")
    @ApiResponses(value={@ApiResponse(code=200, message="Tags were modified successfully.")})
    public void tagAvailabilityData(@Suspended AsyncResponse asyncResponse, @PathParam(value="tenantId") String tenantId, @PathParam(value="id") String id, @ApiParam(required=true) TagRequest params) {
        ApiUtils.executeAsync((AsyncResponse)asyncResponse, () -> {
            AvailabilityMetric metric = new AvailabilityMetric(tenantId, new MetricId(id));
            ListenableFuture future = params.getTimestamp() != null ? this.metricsService.tagAvailabilityData(metric, params.getTags(), params.getTimestamp().longValue()) : this.metricsService.tagAvailabilityData(metric, params.getTags(), params.getStart().longValue(), params.getEnd().longValue());
            return Futures.transform((ListenableFuture)future, data -> Response.ok().build());
        });
    }

    @GET
    @Path(value="/{tenantId}/tags/numeric/{tags}")
    @ApiOperation(value="Find numeric metric data with given tags.", response=Map.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=200, message="Numeric values fetched successfully"), @ApiResponse(code=204, message="No matching data found."), @ApiResponse(code=400, message="Invalid tags", response=ApiError.class), @ApiResponse(code=500, message="Any error while fetching data.", response=ApiError.class)})
    public void findTaggedNumericData(@Suspended AsyncResponse asyncResponse, @PathParam(value="tenantId") String tenantId, @ApiParam(value="Tag list") @PathParam(value="tags") Tags tags) {
        ApiUtils.executeAsync((AsyncResponse)asyncResponse, () -> {
            ListenableFuture queryFuture = this.metricsService.findNumericDataByTags(tenantId, tags.getTags());
            ListenableFuture resultFuture = Futures.transform((ListenableFuture)queryFuture, (Function)new /* Unavailable Anonymous Inner Class!! */);
            return Futures.transform((ListenableFuture)resultFuture, (Function)ApiUtils.MAP_MAP);
        });
    }

    @GET
    @Path(value="/{tenantId}/tags/availability/{tags}")
    @ApiOperation(value="Find availability metric data with given tags.", response=Map.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=200, message="Availability values fetched successfully"), @ApiResponse(code=204, message="No matching data found."), @ApiResponse(code=400, message="Invalid tags", response=ApiError.class), @ApiResponse(code=500, message="Any error while fetching data.", response=ApiError.class)})
    public void findTaggedAvailabilityData(@Suspended AsyncResponse asyncResponse, @PathParam(value="tenantId") String tenantId, @ApiParam(value="Tag list") @PathParam(value="tags") Tags tags) {
        ApiUtils.executeAsync((AsyncResponse)asyncResponse, () -> {
            ListenableFuture future = this.metricsService.findAvailabilityByTags(tenantId, tags.getTags());
            return Futures.transform((ListenableFuture)future, (Function)ApiUtils.MAP_MAP);
        });
    }

    @POST
    @Path(value="/counters")
    @ApiOperation(value="List of counter definitions", hidden=true)
    public void updateCountersForGroups(@Suspended AsyncResponse asyncResponse, Collection<Counter> counters) {
        ListenableFuture future = this.metricsService.updateCounters(counters);
        Futures.addCallback((ListenableFuture)future, (FutureCallback)new NoDataCallback(asyncResponse));
    }

    @POST
    @Path(value="/counters/{group}")
    @ApiOperation(value="Update multiple counters in a single counter group", hidden=true)
    public void updateCounterForGroup(@Suspended AsyncResponse asyncResponse, @PathParam(value="group") String group, Collection<Counter> counters) {
        for (Counter counter : counters) {
            counter.setGroup(group);
        }
        ListenableFuture future = this.metricsService.updateCounters(counters);
        Futures.addCallback((ListenableFuture)future, (FutureCallback)new NoDataCallback(asyncResponse));
    }

    @POST
    @Path(value="/counters/{group}/{counter}")
    @ApiOperation(value="Increase value of a counter", hidden=true)
    public void updateCounter(@Suspended AsyncResponse asyncResponse, @PathParam(value="group") String group, @PathParam(value="counter") String counter) {
        ListenableFuture future = this.metricsService.updateCounter(new Counter("test", group, counter, 1L));
        Futures.addCallback((ListenableFuture)future, (FutureCallback)new NoDataCallback(asyncResponse));
    }

    @POST
    @Path(value="/counters/{group}/{counter}/{value}")
    @ApiOperation(value="Update value of a counter", hidden=true)
    public void updateCounter(@Suspended AsyncResponse asyncResponse, @PathParam(value="group") String group, @PathParam(value="counter") String counter, @PathParam(value="value") Long value) {
        ListenableFuture future = this.metricsService.updateCounter(new Counter("test", group, counter, value.longValue()));
        Futures.addCallback((ListenableFuture)future, (FutureCallback)new NoDataCallback(asyncResponse));
    }

    @GET
    @Path(value="/counters/{group}")
    @ApiOperation(value="Retrieve a list of counter values in this group", hidden=true, response=Counter.class, responseContainer="List")
    @Produces(value={"application/json"})
    public void getCountersForGroup(@Suspended AsyncResponse asyncResponse, @PathParam(value="group") String group) {
        ListenableFuture future = this.metricsService.findCounters(group);
        Futures.addCallback((ListenableFuture)future, (FutureCallback)new SimpleDataCallback(asyncResponse));
    }

    @GET
    @Path(value="/counters/{group}/{counter}")
    @ApiOperation(value="Retrieve value of a counter", hidden=true, response=Counter.class, responseContainer="List")
    public void getCounter(@Suspended AsyncResponse asyncResponse, @PathParam(value="group") String group, @PathParam(value="counter") String counter) {
        ListenableFuture future = this.metricsService.findCounters(group, Collections.singletonList(counter));
        Futures.addCallback((ListenableFuture)future, (FutureCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    @GET
    @Path(value="/{tenantId}/metrics")
    @ApiOperation(value="Find tenant's metric definitions.", notes="Does not include any metric values. ", response=List.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=200, message="Successfully retrieved at least one metric definition."), @ApiResponse(code=204, message="No metrics found."), @ApiResponse(code=400, message="Given type is not a valid type.", response=ApiError.class), @ApiResponse(code=500, message="Failed to retrieve metrics due to unexpected error.", response=ApiError.class)})
    public void findMetrics(@Suspended AsyncResponse asyncResponse, @PathParam(value="tenantId") String tenantId, @ApiParam(value="Queried metric type", required=true, allowableValues="[num, avail, log]") @QueryParam(value="type") String type) {
        ApiUtils.executeAsync((AsyncResponse)asyncResponse, () -> {
            MetricType metricType = null;
            try {
                metricType = MetricType.fromTextCode((String)type);
            }
            catch (IllegalArgumentException e) {
                return ApiUtils.badRequest((ApiError)new ApiError("[" + type + "] is not a valid type. Accepted values are num|avail|log"));
            }
            ListenableFuture future = this.metricsService.findMetrics(tenantId, metricType);
            return Futures.transform((ListenableFuture)future, (Function)ApiUtils.MAP_COLLECTION);
        });
    }
}

