/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.api.jaxrs;

import com.codahale.metrics.JmxReporter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MetricRegistryListener;
import com.codahale.metrics.ObjectNameFactory;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.HostDistance;
import com.datastax.driver.core.JdkSSLOptions;
import com.datastax.driver.core.PoolingOptions;
import com.datastax.driver.core.QueryOptions;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.SSLOptions;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.SocketOptions;
import com.datastax.driver.core.policies.DCAwareRoundRobinPolicy;
import com.datastax.driver.core.policies.LoadBalancingPolicy;
import com.datastax.driver.core.policies.TokenAwarePolicy;
import com.google.common.base.Charsets;
import com.google.common.base.Throwables;
import com.google.common.hash.Hashing;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.Uninterruptibles;
import java.lang.management.ManagementFactory;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Initialized;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.net.ssl.SSLContext;
import org.hawkular.metrics.api.jaxrs.DistributedLock;
import org.hawkular.metrics.api.jaxrs.MetricsServiceLifecycle;
import org.hawkular.metrics.api.jaxrs.ServiceReady;
import org.hawkular.metrics.api.jaxrs.ServiceReadyEvent;
import org.hawkular.metrics.api.jaxrs.config.Configurable;
import org.hawkular.metrics.api.jaxrs.config.ConfigurationKey;
import org.hawkular.metrics.api.jaxrs.config.ConfigurationProperty;
import org.hawkular.metrics.api.jaxrs.dropwizard.RESTMetrics;
import org.hawkular.metrics.api.jaxrs.log.RestLogger;
import org.hawkular.metrics.api.jaxrs.log.RestLogging;
import org.hawkular.metrics.api.jaxrs.util.CassandraClusterNotUpException;
import org.hawkular.metrics.api.jaxrs.util.JobSchedulerFactory;
import org.hawkular.metrics.api.jaxrs.util.ManifestInformation;
import org.hawkular.metrics.api.jaxrs.util.MetricRegistryProvider;
import org.hawkular.metrics.core.dropwizard.CassandraDriverMetrics;
import org.hawkular.metrics.core.dropwizard.DropWizardReporter;
import org.hawkular.metrics.core.dropwizard.HawkularMetricRegistry;
import org.hawkular.metrics.core.dropwizard.HawkularMetricsRegistryListener;
import org.hawkular.metrics.core.dropwizard.HawkularObjectNameFactory;
import org.hawkular.metrics.core.dropwizard.MetricNameService;
import org.hawkular.metrics.core.jobs.JobsService;
import org.hawkular.metrics.core.jobs.JobsServiceImpl;
import org.hawkular.metrics.core.service.DataAccess;
import org.hawkular.metrics.core.service.DataAccessImpl;
import org.hawkular.metrics.core.service.MetricsService;
import org.hawkular.metrics.core.service.MetricsServiceImpl;
import org.hawkular.metrics.core.util.GCGraceSecondsManager;
import org.hawkular.metrics.model.CassandraStatus;
import org.hawkular.metrics.scheduler.api.Scheduler;
import org.hawkular.metrics.scheduler.impl.TestScheduler;
import org.hawkular.metrics.schema.SchemaService;
import org.hawkular.metrics.sysconfig.Configuration;
import org.hawkular.metrics.sysconfig.ConfigurationService;
import org.hawkular.rx.cassandra.driver.RxSession;
import org.hawkular.rx.cassandra.driver.RxSessionImpl;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;

@ApplicationScoped
public class MetricsServiceLifecycle {
    private static final RestLogger log = RestLogging.getRestLogger(MetricsServiceLifecycle.class);
    private MetricsServiceImpl metricsService;
    private final ScheduledExecutorService lifecycleExecutor;
    private Scheduler scheduler;
    private JobsServiceImpl jobsService;
    @Inject
    @Configurable
    @ConfigurationProperty(value=ConfigurationKey.CASSANDRA_CQL_PORT)
    private String cqlPort;
    @Inject
    @Configurable
    @ConfigurationProperty(value=ConfigurationKey.CASSANDRA_NODES)
    private String nodes;
    @Inject
    @Configurable
    @ConfigurationProperty(value=ConfigurationKey.CASSANDRA_KEYSPACE)
    private String keyspace;
    @Inject
    @Configurable
    @ConfigurationProperty(value=ConfigurationKey.CASSANDRA_CLUSTER_CONNECTION_ATTEMPTS)
    private String clusterConnectionAttempts;
    @Inject
    @Configurable
    @ConfigurationProperty(value=ConfigurationKey.CASSANDRA_CLUSTER_CONNECTION_MAX_DELAY)
    private String clusterConnectionDelay;
    @Inject
    @Configurable
    @ConfigurationProperty(value=ConfigurationKey.CASSANDRA_REPLICATION_FACTOR)
    private String replicationFactorProp;
    @Inject
    @Configurable
    @ConfigurationProperty(value=ConfigurationKey.CASSANDRA_RESETDB)
    private String resetDb;
    @Inject
    @Configurable
    @ConfigurationProperty(value=ConfigurationKey.CASSANDRA_MAX_CONN_HOST)
    private String maxConnectionsPerHost;
    @Inject
    @Configurable
    @ConfigurationProperty(value=ConfigurationKey.CASSANDRA_MAX_REQUEST_CONN)
    private String maxRequestsPerConnection;
    @Inject
    @Configurable
    @ConfigurationProperty(value=ConfigurationKey.CASSANDRA_MAX_QUEUE_SIZE)
    private String maxQueueSize;
    @Inject
    @Configurable
    @ConfigurationProperty(value=ConfigurationKey.CASSANDRA_REQUEST_TIMEOUT)
    private String requestTimeout;
    @Inject
    @Configurable
    @ConfigurationProperty(value=ConfigurationKey.CASSANDRA_CONNECTION_TIMEOUT)
    private String connectionTimeout;
    @Inject
    @Configurable
    @ConfigurationProperty(value=ConfigurationKey.WAIT_FOR_SERVICE)
    private String waitForService;
    @Inject
    @Configurable
    @ConfigurationProperty(value=ConfigurationKey.CASSANDRA_USESSL)
    private String cassandraUseSSL;
    @Inject
    @Configurable
    @ConfigurationProperty(value=ConfigurationKey.CASSANDRA_SCHEMA_REFRESH_INTERVAL)
    private String schemaRefreshInterval;
    @Inject
    @Configurable
    @ConfigurationProperty(value=ConfigurationKey.DEFAULT_TTL)
    private String defaultTTL;
    @Inject
    @Configurable
    @ConfigurationProperty(value=ConfigurationKey.JMX_REPORTING_ENABLED)
    private String jmxReportingEnabled;
    @Inject
    @Configurable
    @ConfigurationProperty(value=ConfigurationKey.ADMIN_TOKEN)
    private String adminToken;
    @Inject
    @Configurable
    @ConfigurationProperty(value=ConfigurationKey.ADMIN_TENANT)
    private String adminTenant;
    @Inject
    @Configurable
    @ConfigurationProperty(value=ConfigurationKey.INGEST_MAX_RETRIES)
    private String ingestMaxRetries;
    @Inject
    @Configurable
    @ConfigurationProperty(value=ConfigurationKey.INGEST_MAX_RETRY_DELAY)
    private String ingestMaxRetryDelay;
    @Inject
    @Configurable
    @ConfigurationProperty(value=ConfigurationKey.PAGE_SIZE)
    private String pageSize;
    @Inject
    @Configurable
    @ConfigurationProperty(value=ConfigurationKey.COMPRESSION_QUERY_PAGE_SIZE)
    private String compressionPageSize;
    @Inject
    @Configurable
    @ConfigurationProperty(value=ConfigurationKey.COMPRESSION_JOB_ENABLED)
    private String compressionJobEnabled;
    @Inject
    @Configurable
    @ConfigurationProperty(value=ConfigurationKey.METRICS_REPORTING_HOSTNAME)
    private String metricsReportingHostname;
    @Inject
    @Configurable
    @ConfigurationProperty(value=ConfigurationKey.METRICS_REPORTING_ENABLED)
    private String metricsReportingEnabled;
    @Inject
    @Configurable
    @ConfigurationProperty(value=ConfigurationKey.METRICS_REPORTING_COLLECTION_INTERVAL)
    private String collectionIntervalConfig;
    @Inject
    @Configurable
    @ConfigurationProperty(value=ConfigurationKey.METRICS_EXPIRATION_DELAY)
    private String metricExpirationDelay;
    @Inject
    @Configurable
    @ConfigurationProperty(value=ConfigurationKey.METRICS_EXPIRATION_JOB_FREQUENCY)
    private String metricsExpirationJobFrequency;
    @Inject
    @Configurable
    @ConfigurationProperty(value=ConfigurationKey.METRICS_EXPIRATION_JOB_ENABLED)
    private String metricsExpirationJobEnabled;
    @Inject
    @ServiceReady
    Event<ServiceReadyEvent> metricsServiceReady;
    @Inject
    private ManifestInformation manifestInfo;
    @Resource(lookup="java:jboss/infinispan/cache/hawkular-metrics/locks")
    private Cache<String, String> locksCache;
    @Inject
    RESTMetrics restMetrics;
    private volatile State state;
    private int connectionAttempts;
    private Session session;
    private JmxReporter jmxReporter;
    private ConfigurationService configurationService;
    private DataAccess dataAcces;
    private GCGraceSecondsManager gcGraceSecondsManager;

    MetricsServiceLifecycle() {
        ThreadFactory threadFactory = r -> {
            Thread thread = Executors.defaultThreadFactory().newThread(r);
            thread.setName(MetricsService.class.getSimpleName().toLowerCase(Locale.ROOT) + "-lifecycle-thread");
            return thread;
        };
        this.lifecycleExecutor = Executors.newSingleThreadScheduledExecutor(threadFactory);
        this.state = State.STARTING;
    }

    public State getState() {
        return this.state;
    }

    public List<CassandraStatus> getCassandraStatus() {
        return this.session.getCluster().getMetadata().getAllHosts().stream().map(host -> {
            CassandraStatus status = host.isUp() ? new CassandraStatus(host.getAddress().getHostName(), "up") : new CassandraStatus(host.getAddress().getHostName(), "down");
            return status;
        }).collect(Collectors.toList());
    }

    void eagerInit(@Observes @Initialized(value=ApplicationScoped.class) Object event) {
    }

    @PostConstruct
    void init() {
        log.infof("Hawkular Metrics version: %s", this.manifestInfo.getAttributes().get("Implementation-Version"));
        this.lifecycleExecutor.submit(() -> this.startMetricsService());
        if (Boolean.parseBoolean(this.waitForService) || "embedded_cassandra".equals(System.getProperty("hawkular.backend"))) {
            long start = System.nanoTime();
            while (this.state == State.STARTING && TimeUnit.NANOSECONDS.convert(1L, TimeUnit.MINUTES) > System.nanoTime() - start) {
                Uninterruptibles.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.SECONDS);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startMetricsService() {
        if (this.state != State.STARTING) {
            return;
        }
        log.infoInitializing();
        ++this.connectionAttempts;
        try {
            this.session = this.createSession();
        }
        catch (Exception t) {
            Throwable rootCause = Throwables.getRootCause((Throwable)t);
            if (rootCause.getLocalizedMessage().equals(this.nodes + ": unknown error")) {
                log.warnCouldNotConnectToCassandra("Could not resolve hostname: " + rootCause.getLocalizedMessage());
            } else {
                log.warnCouldNotConnectToCassandra(rootCause.getLocalizedMessage());
            }
            long delay = 1L + ((long)this.connectionAttempts - 1L) % 4L;
            log.warnRetryingConnectingToCassandra(Integer.valueOf(this.connectionAttempts), Long.valueOf(delay));
            this.lifecycleExecutor.schedule(() -> this.startMetricsService(), delay, TimeUnit.SECONDS);
            return;
        }
        try {
            this.waitForAllNodesToBeUp();
            this.initSchema();
            this.dataAcces = new DataAccessImpl(this.session);
            this.configurationService = new ConfigurationService();
            this.configurationService.init((RxSession)new RxSessionImpl(this.session));
            this.persistAdminToken();
            this.updateIngestionConfiguration();
            this.updateCompressionJobConfiguration();
            this.metricsService = new MetricsServiceImpl();
            this.metricsService.setDataAccess(this.dataAcces);
            this.metricsService.setConfigurationService(this.configurationService);
            this.metricsService.setDefaultTTL(this.getDefaultTTL());
            MetricNameService metricNameService = this.metricsReportingHostname == null ? new MetricNameService(this.adminTenant) : new MetricNameService(this.metricsReportingHostname, this.adminTenant);
            HawkularMetricRegistry metricRegistry = MetricRegistryProvider.INSTANCE.getMetricRegistry();
            metricRegistry.setMetricNameService(metricNameService);
            this.restMetrics.setMetricNameService(metricNameService);
            this.restMetrics.initMetrics();
            this.metricsService.setMetricNameService(metricNameService);
            this.metricsService.startUp(this.session, this.keyspace, false, false, metricRegistry);
            HawkularMetricsRegistryListener metricsRegistryListener = new HawkularMetricsRegistryListener();
            metricsRegistryListener.setMetricNameService(metricNameService);
            metricsRegistryListener.setMetricRegistry(metricRegistry);
            metricsRegistryListener.setMetricsService((MetricsService)this.metricsService);
            metricRegistry.addListener((MetricRegistryListener)metricsRegistryListener);
            new CassandraDriverMetrics(this.session, metricRegistry).registerAll();
            if (Boolean.valueOf(this.metricsReportingEnabled).booleanValue()) {
                DropWizardReporter reporter = new DropWizardReporter(metricRegistry, metricNameService, (MetricsService)this.metricsService);
                int interval = Integer.getInteger(this.collectionIntervalConfig, 180);
                reporter.start((long)interval, TimeUnit.SECONDS);
            }
            this.metricsServiceReady.fire((Object)new ServiceReadyEvent(this.metricsService.insertedDataEvents()));
            this.initJobsService();
            this.initGCGraceSecondsManager();
            if (Boolean.parseBoolean(this.jmxReportingEnabled)) {
                HawkularObjectNameFactory JMXObjNameFactory = new HawkularObjectNameFactory(metricRegistry);
                JmxReporter jmxReporter = JmxReporter.forRegistry((MetricRegistry)metricRegistry).inDomain("org.hawkular.metrics").createsObjectNamesWith((ObjectNameFactory)JMXObjNameFactory).build();
                jmxReporter.start();
            }
            this.state = State.STARTED;
            log.infoServiceStarted();
        }
        catch (CassandraClusterNotUpException e) {
            log.fatal((Object)"It appears that some nodes in the Cassandra cluster are not up. Start up cannot proceed");
            this.state = State.FAILED;
        }
        catch (Exception e) {
            log.fatalCannotConnectToCassandra(e);
            this.state = State.FAILED;
        }
        finally {
            if (this.state != State.STARTED && this.metricsService != null) {
                try {
                    this.metricsService.shutdown();
                }
                catch (Exception e) {
                    log.errorCouldNotCloseServiceInstance(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Session createSession() {
        int driverMaxQueueSize;
        int driverPageSize;
        int driverSchemaRefreshInterval;
        int driverConnectionTimeout;
        int driverRequestTimeout;
        int newMaxRequests;
        int newMaxConnections;
        int port;
        Cluster.Builder clusterBuilder = new Cluster.Builder();
        try {
            port = Integer.parseInt(this.cqlPort);
        }
        catch (NumberFormatException nfe) {
            String defaultPort = ConfigurationKey.CASSANDRA_CQL_PORT.defaultValue();
            log.warnInvalidCqlPort(this.cqlPort, defaultPort);
            port = Integer.parseInt(defaultPort);
        }
        clusterBuilder.withPort(port);
        Arrays.stream(this.nodes.split(",")).forEach(arg_0 -> ((Cluster.Builder)clusterBuilder).addContactPoint(arg_0));
        if (Boolean.parseBoolean(this.cassandraUseSSL)) {
            JdkSSLOptions sslOptions = null;
            try {
                String[] defaultCipherSuites = new String[]{"TLS_RSA_WITH_AES_128_CBC_SHA", "TLS_RSA_WITH_AES_256_CBC_SHA"};
                sslOptions = JdkSSLOptions.builder().withSSLContext(SSLContext.getDefault()).withCipherSuites(defaultCipherSuites).build();
                clusterBuilder.withSSL((SSLOptions)sslOptions);
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException("SSL support is required but is not available in the JVM.", e);
            }
        }
        clusterBuilder.withoutJMXReporting();
        try {
            newMaxConnections = Integer.parseInt(this.maxConnectionsPerHost);
        }
        catch (NumberFormatException nfe) {
            String defaultMaxConnections = ConfigurationKey.CASSANDRA_MAX_CONN_HOST.defaultValue();
            log.warnInvalidMaxConnections(this.maxConnectionsPerHost, defaultMaxConnections);
            newMaxConnections = Integer.parseInt(defaultMaxConnections);
        }
        try {
            newMaxRequests = Integer.parseInt(this.maxRequestsPerConnection);
        }
        catch (NumberFormatException nfe) {
            String defaultMaxRequests = ConfigurationKey.CASSANDRA_MAX_REQUEST_CONN.defaultValue();
            log.warnInvalidMaxRequests(this.maxRequestsPerConnection, defaultMaxRequests);
            newMaxRequests = Integer.parseInt(defaultMaxRequests);
        }
        try {
            driverRequestTimeout = Integer.parseInt(this.requestTimeout);
        }
        catch (NumberFormatException e) {
            driverRequestTimeout = Integer.parseInt(ConfigurationKey.CASSANDRA_REQUEST_TIMEOUT.defaultValue());
            log.warnInvalidRequestTimeout(this.requestTimeout, ConfigurationKey.CASSANDRA_REQUEST_TIMEOUT.defaultValue());
        }
        try {
            driverConnectionTimeout = Integer.parseInt(this.connectionTimeout);
        }
        catch (NumberFormatException e) {
            driverConnectionTimeout = Integer.parseInt(ConfigurationKey.CASSANDRA_CONNECTION_TIMEOUT.defaultValue());
            log.warnInvalidConnectionTimeout(this.connectionTimeout, ConfigurationKey.CASSANDRA_CONNECTION_TIMEOUT.defaultValue());
        }
        try {
            driverSchemaRefreshInterval = Integer.parseInt(this.schemaRefreshInterval);
        }
        catch (NumberFormatException e) {
            driverSchemaRefreshInterval = Integer.parseInt(ConfigurationKey.CASSANDRA_SCHEMA_REFRESH_INTERVAL.defaultValue());
            log.warnInvalidSchemaRefreshInterval(this.schemaRefreshInterval, ConfigurationKey.CASSANDRA_SCHEMA_REFRESH_INTERVAL.defaultValue());
        }
        try {
            driverPageSize = this.pageSize == null ? Integer.parseInt(ConfigurationKey.PAGE_SIZE.defaultValue()) : Integer.parseInt(this.pageSize);
        }
        catch (NumberFormatException e) {
            driverPageSize = Integer.parseInt(ConfigurationKey.PAGE_SIZE.defaultValue());
        }
        try {
            driverMaxQueueSize = Integer.parseInt(this.maxQueueSize);
        }
        catch (NumberFormatException e) {
            log.warnf("Invalid value [%s] for Cassandra driver max queue size", (Object)this.maxQueueSize);
            driverMaxQueueSize = Integer.parseInt(ConfigurationKey.CASSANDRA_MAX_QUEUE_SIZE.defaultValue());
        }
        clusterBuilder.withPoolingOptions(new PoolingOptions().setMaxConnectionsPerHost(HostDistance.LOCAL, newMaxConnections).setCoreConnectionsPerHost(HostDistance.LOCAL, newMaxConnections).setMaxConnectionsPerHost(HostDistance.REMOTE, newMaxConnections).setCoreConnectionsPerHost(HostDistance.REMOTE, newMaxConnections).setMaxRequestsPerConnection(HostDistance.LOCAL, newMaxRequests).setMaxRequestsPerConnection(HostDistance.REMOTE, newMaxRequests).setMaxQueueSize(driverMaxQueueSize)).withSocketOptions(new SocketOptions().setReadTimeoutMillis(driverRequestTimeout).setConnectTimeoutMillis(driverConnectionTimeout)).withQueryOptions(new QueryOptions().setFetchSize(driverPageSize).setRefreshSchemaIntervalMillis(driverSchemaRefreshInterval)).withLoadBalancingPolicy((LoadBalancingPolicy)new TokenAwarePolicy((LoadBalancingPolicy)DCAwareRoundRobinPolicy.builder().build(), false));
        Cluster cluster = clusterBuilder.build();
        cluster.init();
        Session createdSession = null;
        try {
            Session session = createdSession = cluster.connect("system");
            return session;
        }
        finally {
            if (createdSession == null) {
                cluster.close();
            }
        }
    }

    private void waitForAllNodesToBeUp() throws CassandraClusterNotUpException {
        boolean isReady = false;
        int attempts = Integer.parseInt(ConfigurationKey.CASSANDRA_CLUSTER_CONNECTION_ATTEMPTS.defaultValue());
        long delay = 2000L;
        long maxDelay = Long.parseLong(ConfigurationKey.CASSANDRA_CLUSTER_CONNECTION_MAX_DELAY.defaultValue());
        try {
            attempts = Integer.parseInt(this.clusterConnectionAttempts);
        }
        catch (NumberFormatException e) {
            log.infof("Invalid value for %s. Using default of %d", (Object)ConfigurationKey.CASSANDRA_CLUSTER_CONNECTION_ATTEMPTS.name(), (Object)attempts);
        }
        try {
            maxDelay = Long.parseLong(this.clusterConnectionDelay);
        }
        catch (NumberFormatException e) {
            log.infof("Invalid value for %s. Using default of %d", (Object)ConfigurationKey.CASSANDRA_CLUSTER_CONNECTION_MAX_DELAY.name(), (Object)delay);
        }
        block6: while (!isReady && !Thread.currentThread().isInterrupted() && attempts-- >= 0) {
            isReady = true;
            for (Host host : this.session.getCluster().getMetadata().getAllHosts()) {
                if (host.isUp()) continue;
                isReady = false;
                log.warnf("Cassandra node %s may not be up yet. Waiting %s ms for node to come up", (Object)host, (Object)delay);
                try {
                    Thread.sleep(delay);
                    delay = Math.min(delay * 2L, maxDelay);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                continue block6;
            }
        }
        if (!isReady) {
            throw new CassandraClusterNotUpException("It appears that not all nodes in the Cassandra cluster are up after " + attempts + " checks. Schema updates cannot proceed without all nodes being up.");
        }
    }

    private void initSchema() {
        AtomicReference<Integer> replicationFactor = new AtomicReference<Integer>();
        try {
            replicationFactor.set(Integer.parseInt(this.replicationFactorProp));
        }
        catch (NumberFormatException e) {
            log.warnf("Invalid value [%s] for Cassandra replication_factor. Using default value of 1", (Object)this.replicationFactorProp);
            replicationFactor.set(1);
        }
        AdvancedCache cache = this.locksCache.getAdvancedCache();
        DistributedLock schemaLock = new DistributedLock(cache, "cassalog");
        schemaLock.lockAndThen(30000L, () -> {
            SchemaService schemaService = new SchemaService();
            schemaService.run(this.session, this.keyspace, Boolean.parseBoolean(this.resetDb), ((Integer)replicationFactor.get()).intValue());
            this.session.execute("USE " + this.keyspace);
            this.logReplicationFactor();
        });
    }

    private void logReplicationFactor() {
        ResultSet resultSet = this.session.execute("SELECT replication FROM system_schema.keyspaces WHERE keyspace_name = '" + this.keyspace + "'");
        if (resultSet.isExhausted()) {
            log.warnf("Unable to determine replication_factor for keyspace %s", (Object)this.keyspace);
        }
        Map replication = resultSet.one().getMap(0, String.class, String.class);
        log.infof("The keyspace %s is using a replication_factor of %s", (Object)this.keyspace, replication.get("replication_factor"));
    }

    private void initGCGraceSecondsManager() {
        this.gcGraceSecondsManager = new GCGraceSecondsManager((RxSession)new RxSessionImpl(this.session), this.keyspace, this.configurationService);
        this.gcGraceSecondsManager.maybeUpdateGCGraceSeconds();
    }

    private int getDefaultTTL() {
        try {
            return Integer.parseInt(this.defaultTTL);
        }
        catch (NumberFormatException e) {
            log.warnInvalidDefaultTTL(this.defaultTTL, ConfigurationKey.DEFAULT_TTL.defaultValue());
            return Integer.parseInt(ConfigurationKey.DEFAULT_TTL.defaultValue());
        }
    }

    private int parseIntConfig(String value, ConfigurationKey configKey) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return Integer.parseInt(configKey.defaultValue());
        }
    }

    private boolean parseBooleanConfig(String value, ConfigurationKey configKey) {
        try {
            return Boolean.parseBoolean(value);
        }
        catch (NumberFormatException e) {
            return Boolean.parseBoolean(configKey.defaultValue());
        }
    }

    private void initJobsService() {
        RxSessionImpl rxSession = new RxSessionImpl(this.session);
        this.jobsService = new JobsServiceImpl(this.parseIntConfig(this.metricExpirationDelay, ConfigurationKey.METRICS_EXPIRATION_DELAY), this.parseIntConfig(this.metricsExpirationJobFrequency, ConfigurationKey.METRICS_EXPIRATION_JOB_FREQUENCY), this.parseBooleanConfig(this.metricsExpirationJobEnabled, ConfigurationKey.METRICS_EXPIRATION_JOB_ENABLED));
        this.jobsService.setMetricsService((MetricsService)this.metricsService);
        this.jobsService.setConfigurationService(this.configurationService);
        this.jobsService.setSession((RxSession)rxSession);
        this.scheduler = new JobSchedulerFactory().getJobScheduler((RxSession)rxSession);
        this.jobsService.setScheduler(this.scheduler);
        DistributedLock jobsLock = new DistributedLock(this.locksCache.getAdvancedCache(), "background-jobs");
        jobsLock.lockAndThen(() -> ((JobsServiceImpl)this.jobsService).start());
        this.registerMBean("JobsService", (Object)this.jobsService);
    }

    private void registerMBean(String name, Object service) {
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            String fullName = String.format("%s:type=%s", service.getClass().getPackage().getName(), name);
            ObjectName serviceName = new ObjectName(fullName);
            mbs.registerMBean(service, serviceName);
        }
        catch (InstanceAlreadyExistsException | MBeanRegistrationException | MalformedObjectNameException | NotCompliantMBeanException e) {
            log.error((Object)"Could not initialize JMX MBean", (Throwable)e);
        }
    }

    private void persistAdminToken() {
        if (this.adminToken != null && !this.adminToken.trim().isEmpty()) {
            String hashedAdminToken = Hashing.sha256().newHasher().putString((CharSequence)this.adminToken, Charsets.UTF_8).hash().toString();
            this.configurationService.save("org.hawkular.metrics", "admin.token", hashedAdminToken);
        }
    }

    private void updateIngestionConfiguration() {
        HashMap<String, String> properties = new HashMap<String, String>();
        if (this.ingestMaxRetries != null) {
            try {
                Integer.parseInt(this.ingestMaxRetries);
                properties.put("ingestion.retry.max-retries", this.ingestMaxRetries);
            }
            catch (NumberFormatException e) {
                log.warnInvalidIngestMaxRetries(this.ingestMaxRetries);
            }
        }
        if (this.ingestMaxRetryDelay != null) {
            try {
                Long.parseLong(this.ingestMaxRetryDelay);
                properties.put("ingestion.retry.max-delay", this.ingestMaxRetryDelay);
            }
            catch (NumberFormatException e) {
                log.warnInvalidIngestMaxRetryDelay(this.ingestMaxRetryDelay);
            }
        }
        if (!properties.isEmpty()) {
            Configuration config = new Configuration("org.hawkular.metrics", properties);
            this.configurationService.save(config).toCompletable().await(10L, TimeUnit.SECONDS);
        }
    }

    private void updateCompressionJobConfiguration() {
        if (this.compressionPageSize != null) {
            this.configurationService.save("org.hawkular.metrics.jobs.COMPRESS_DATA", "page-size", this.compressionPageSize).toCompletable().await(10L, TimeUnit.SECONDS);
        } else {
            String pageSizeConfig = (String)this.configurationService.load("org.hawkular.metrics.jobs.COMPRESS_DATA", "page-size").toBlocking().firstOrDefault(null);
            if (pageSizeConfig == null) {
                this.configurationService.save("org.hawkular.metrics.jobs.COMPRESS_DATA", "page-size", ConfigurationKey.COMPRESSION_QUERY_PAGE_SIZE.defaultValue()).toCompletable().await(10L, TimeUnit.SECONDS);
            }
        }
        if (this.compressionJobEnabled != null) {
            this.configurationService.save("org.hawkular.metrics.jobs.COMPRESS_DATA", "enabled", this.compressionJobEnabled);
        }
    }

    @Produces
    @ApplicationScoped
    public MetricsService getMetricsService() {
        return this.metricsService;
    }

    @Produces
    @ApplicationScoped
    public JobsService getJobsService() {
        return this.jobsService;
    }

    @Produces
    @ApplicationScoped
    public ConfigurationService getConfigurationService() {
        return this.configurationService;
    }

    @Produces
    @ApplicationScoped
    public TestScheduler getTestScheduler() {
        if (this.scheduler instanceof TestScheduler) {
            return (TestScheduler)this.scheduler;
        }
        throw new RuntimeException(TestScheduler.class.getName() + " is not available in this deployment");
    }

    @PreDestroy
    void destroy() {
        Future<?> stopFuture = this.lifecycleExecutor.submit(() -> this.stopServices());
        try {
            Futures.get(stopFuture, (long)1L, (TimeUnit)TimeUnit.MINUTES, Exception.class);
        }
        catch (Exception e) {
            log.errorShutdownProblem(e);
        }
        this.lifecycleExecutor.shutdown();
    }

    private void stopServices() {
        this.state = State.STOPPING;
        try {
            if (this.jobsService != null) {
                this.jobsService.shutdown();
            }
            if (this.metricsService != null) {
                this.metricsService.shutdown();
            }
            if (this.jmxReporter != null) {
                this.jmxReporter.stop();
            }
        }
        finally {
            this.state = State.STOPPED;
        }
    }
}

