/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.api.jaxrs.util;

import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.inject.Inject;
import org.hawkular.metrics.api.jaxrs.config.Configurable;
import org.hawkular.metrics.api.jaxrs.config.ConfigurationKey;
import org.hawkular.metrics.api.jaxrs.config.ConfigurationProperty;
import org.hawkular.metrics.scheduler.api.Scheduler;
import org.hawkular.metrics.scheduler.impl.SchedulerImpl;
import org.hawkular.rx.cassandra.driver.RxSession;

public class JobSchedulerFactory {
    @Inject
    @Configurable
    @ConfigurationProperty(value=ConfigurationKey.METRICS_REPORTING_HOSTNAME)
    private String metricsHostname;

    public Scheduler getJobScheduler(RxSession session) {
        try {
            if (this.metricsHostname == null) {
                this.metricsHostname = InetAddress.getLocalHost().getHostName();
            }
            return new SchedulerImpl(session, this.metricsHostname);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }
}

