/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.api.jaxrs.filter;

import java.io.IOException;
import javax.inject.Inject;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import org.hawkular.metrics.api.jaxrs.config.Configurable;
import org.hawkular.metrics.api.jaxrs.config.ConfigurationKey;
import org.hawkular.metrics.api.jaxrs.config.ConfigurationProperty;
import org.hawkular.metrics.api.jaxrs.util.OriginValidation;

@Provider
public class CorsResponseFilter
implements ContainerResponseFilter {
    @Inject
    OriginValidation validator;
    @Inject
    @Configurable
    @ConfigurationProperty(value=ConfigurationKey.ALLOWED_CORS_ACCESS_CONTROL_ALLOW_HEADERS)
    String extraAccesControlAllowHeaders;

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        String requestOrigin = requestContext.getHeaderString("Origin");
        if (requestOrigin == null) {
            return;
        }
        if (this.validator.isAllowedOrigin(requestOrigin)) {
            MultivaluedMap responseHeaders = responseContext.getHeaders();
            responseHeaders.add((Object)"Access-Control-Allow-Origin", (Object)requestOrigin);
            responseHeaders.add((Object)"Access-Control-Allow-Credentials", (Object)"true");
            responseHeaders.add((Object)"Access-Control-Allow-Methods", (Object)"GET, POST, PUT, DELETE, OPTIONS, HEAD");
            responseHeaders.add((Object)"Access-Control-Max-Age", (Object)259200);
            if (this.extraAccesControlAllowHeaders != null) {
                responseHeaders.add((Object)"Access-Control-Allow-Headers", (Object)("origin,accept,content-type,hawkular-tenant," + this.extraAccesControlAllowHeaders.trim()));
            } else {
                responseHeaders.add((Object)"Access-Control-Allow-Headers", (Object)"origin,accept,content-type,hawkular-tenant");
            }
        } else {
            responseContext.setStatus(Response.Status.BAD_REQUEST.getStatusCode());
        }
    }
}

