/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.api.jaxrs;

import java.util.ArrayList;
import org.infinispan.AdvancedCache;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachemanagerlistener.annotation.ViewChanged;
import org.infinispan.notifications.cachemanagerlistener.event.ViewChangedEvent;
import org.infinispan.remoting.transport.Address;
import org.jboss.logging.Logger;

@Listener
public class DistributedLock {
    private static Logger log = Logger.getLogger(DistributedLock.class);
    public static final long DEFAULT_RETRY_DELAY = 10000L;
    private final AdvancedCache<String, String> locksCache;
    private final String key;

    public DistributedLock(AdvancedCache<String, String> locksCache, String key) {
        this.key = key;
        this.locksCache = locksCache;
        this.locksCache.getCacheManager().addListener((Object)this);
    }

    private boolean isLocked() {
        if (this.isDistributed()) {
            return this.getLockValue().equals(this.locksCache.get((Object)this.key));
        }
        return false;
    }

    public boolean lock() {
        if (this.isDistributed()) {
            if (this.isLocked()) {
                return true;
            }
            return this.locksCache.putIfAbsent((Object)this.key, (Object)this.getLockValue()) == null;
        }
        return true;
    }

    public boolean release() {
        if (this.isDistributed() && this.isLocked()) {
            return this.locksCache.remove((Object)this.key, (Object)this.getLockValue());
        }
        return true;
    }

    public void lockAndThen(Runnable runnable) {
        this.lockAndThen(10000L, runnable);
    }

    public void lockAndThen(long retryDelay, Runnable runnable) {
        try {
            while (!this.lock()) {
                log.debugf("Failed to acquire [%s] lock. Trying again in [%d] ms", (Object)this.key, (Object)retryDelay);
                Thread.sleep(retryDelay);
                this.lock();
            }
            runnable.run();
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        finally {
            this.release();
        }
    }

    @ViewChanged
    public void viewChanged(ViewChangedEvent event) {
        log.debugf("view changed: %s", (Object)event);
        ArrayList old = new ArrayList(event.getOldMembers());
        old.removeAll(event.getNewMembers());
        for (Address address : old) {
            this.locksCache.remove((Object)this.key, (Object)address.toString());
        }
    }

    private boolean isDistributed() {
        return this.locksCache.getCacheManager().getTransport() != null;
    }

    private String getLockValue() {
        return this.locksCache.getCacheManager().getAddress().toString();
    }
}

