/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.api.jaxrs.handler;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.regex.PatternSyntaxException;
import javax.enterprise.context.ApplicationScoped;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.hawkular.metrics.api.jaxrs.QueryRequest;
import org.hawkular.metrics.api.jaxrs.handler.MetricsServiceHandler;
import org.hawkular.metrics.api.jaxrs.handler.observer.MetricCreatedObserver;
import org.hawkular.metrics.api.jaxrs.handler.observer.ResultSetObserver;
import org.hawkular.metrics.api.jaxrs.handler.template.IMetricsHandler;
import org.hawkular.metrics.api.jaxrs.handler.transformer.MinMaxTimestampTransformer;
import org.hawkular.metrics.api.jaxrs.param.TimeAndBucketParams;
import org.hawkular.metrics.api.jaxrs.param.TimeAndSortParams;
import org.hawkular.metrics.api.jaxrs.util.ApiUtils;
import org.hawkular.metrics.core.service.Functions;
import org.hawkular.metrics.core.service.MetricsService;
import org.hawkular.metrics.core.service.Order;
import org.hawkular.metrics.model.ApiError;
import org.hawkular.metrics.model.AvailabilityBucketPoint;
import org.hawkular.metrics.model.AvailabilityType;
import org.hawkular.metrics.model.Buckets;
import org.hawkular.metrics.model.DataPoint;
import org.hawkular.metrics.model.Metric;
import org.hawkular.metrics.model.MetricId;
import org.hawkular.metrics.model.MetricType;
import org.hawkular.metrics.model.param.BucketConfig;
import org.hawkular.metrics.model.param.Duration;
import org.hawkular.metrics.model.param.TagNames;
import org.hawkular.metrics.model.param.Tags;
import org.hawkular.metrics.model.param.TimeRange;
import rx.Observable;
import rx.Observer;
import rx.Subscriber;
import rx.schedulers.Schedulers;

@Path(value="/availability")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Api(tags={"Availability"})
@ApplicationScoped
public class AvailabilityHandler
extends MetricsServiceHandler
implements IMetricsHandler<AvailabilityType> {
    @POST
    @Path(value="/")
    @ApiOperation(value="Create availability metric.", notes="Same notes as creating gauge metric apply.")
    @ApiResponses(value={@ApiResponse(code=201, message="Metric created successfully"), @ApiResponse(code=400, message="Missing or invalid payload", response=ApiError.class), @ApiResponse(code=409, message="Availability metric with given id already exists", response=ApiError.class), @ApiResponse(code=500, message="Metric creation failed due to an unexpected error", response=ApiError.class)})
    public void createMetric(@Suspended AsyncResponse asyncResponse, @ApiParam(required=true) Metric<AvailabilityType> metric, @ApiParam(value="Overwrite previously created metric configuration if it exists. Only data retention and tags are overwriten; existing data points are unnafected. Defaults to false.", required=false) @DefaultValue(value="false") @QueryParam(value="overwrite") Boolean overwrite, @Context UriInfo uriInfo) {
        if (metric.getType() != null && MetricType.UNDEFINED != metric.getType() && MetricType.AVAILABILITY != metric.getType()) {
            asyncResponse.resume((Object)ApiUtils.badRequest((ApiError)new ApiError("Metric type does not match " + MetricType.AVAILABILITY.getText())));
        }
        URI location = uriInfo.getBaseUriBuilder().path("/availability/{id}").build(new Object[]{metric.getId()});
        metric = new Metric(new MetricId(this.getTenant(), MetricType.AVAILABILITY, metric.getMetricId().getName()), metric.getTags(), metric.getDataRetention());
        this.metricsService.createMetric(metric, overwrite.booleanValue()).subscribe((Observer)new MetricCreatedObserver(asyncResponse, location));
    }

    @GET
    @Path(value="/")
    @ApiOperation(value="Find tenant's metric definitions.", notes="Does not include any metric values. ", response=Metric.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=200, message="Successfully retrieved at least one metric definition."), @ApiResponse(code=204, message="No metrics found."), @ApiResponse(code=400, message="Invalid type parameter type.", response=ApiError.class), @ApiResponse(code=500, message="Failed to retrieve metrics due to unexpected error.", response=ApiError.class)})
    public void getMetrics(@Suspended AsyncResponse asyncResponse, @ApiParam(value="List of tags filters", required=false) @QueryParam(value="tags") Tags tags) {
        Observable metricObservable = tags == null ? this.metricsService.findMetrics(this.getTenant(), MetricType.AVAILABILITY) : this.metricsService.findMetricIdentifiersWithFilters(this.getTenant(), MetricType.AVAILABILITY, tags.getTags()).flatMap(arg_0 -> ((MetricsService)this.metricsService).findMetric(arg_0));
        metricObservable.compose((Observable.Transformer)new MinMaxTimestampTransformer(this.metricsService)).toList().map(ApiUtils::collectionToResponse).subscribe(arg_0 -> ((AsyncResponse)asyncResponse).resume(arg_0), t -> {
            if (t instanceof PatternSyntaxException) {
                asyncResponse.resume((Object)ApiUtils.badRequest((Throwable)t));
            } else {
                asyncResponse.resume((Object)ApiUtils.serverError((Throwable)t));
            }
        });
    }

    @GET
    @Path(value="/{id}")
    @ApiOperation(value="Retrieve single metric definition.", response=Metric.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Metric's definition was successfully retrieved."), @ApiResponse(code=204, message="Query was successful, but no metrics definition is set."), @ApiResponse(code=500, message="Unexpected error occurred while fetching metric's definition.", response=ApiError.class)})
    public void getMetric(@Suspended AsyncResponse asyncResponse, @PathParam(value="id") String id) {
        this.metricsService.findMetric(new MetricId(this.getTenant(), MetricType.AVAILABILITY, id)).compose((Observable.Transformer)new MinMaxTimestampTransformer(this.metricsService)).map(metric -> Response.ok((Object)metric).build()).switchIfEmpty(Observable.just((Object)ApiUtils.noContent())).subscribe(arg_0 -> ((AsyncResponse)asyncResponse).resume(arg_0), t -> asyncResponse.resume((Object)ApiUtils.serverError((Throwable)t)));
    }

    @GET
    @Path(value="/tags/{tags}")
    @ApiOperation(value="Retrieve availability type's tag values", response=Map.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Tags successfully retrieved."), @ApiResponse(code=204, message="No matching tags were found"), @ApiResponse(code=500, message="Unexpected error occurred while fetching tags.", response=ApiError.class)})
    public void getTags(@Suspended AsyncResponse asyncResponse, @ApiParam(value="Tag query") @PathParam(value="tags") Tags tags) {
        this.metricsService.getTagValues(this.getTenant(), MetricType.AVAILABILITY, tags.getTags()).map(ApiUtils::mapToResponse).subscribe(arg_0 -> ((AsyncResponse)asyncResponse).resume(arg_0), t -> asyncResponse.resume((Object)ApiUtils.serverError((Throwable)t)));
    }

    @GET
    @Path(value="/{id}/tags")
    @ApiOperation(value="Retrieve tags associated with the metric definition.", response=String.class, responseContainer="Map")
    @ApiResponses(value={@ApiResponse(code=200, message="Metric's tags were successfully retrieved."), @ApiResponse(code=204, message="Query was successful, but no metrics were found."), @ApiResponse(code=500, message="Unexpected error occurred while fetching metric's tags.", response=ApiError.class)})
    public void getMetricTags(@Suspended AsyncResponse asyncResponse, @PathParam(value="id") String id) {
        this.metricsService.getMetricTags(new MetricId(this.getTenant(), MetricType.AVAILABILITY, id)).map(ApiUtils::mapToResponse).subscribe(arg_0 -> ((AsyncResponse)asyncResponse).resume(arg_0), t -> asyncResponse.resume((Object)ApiUtils.serverError((Throwable)t)));
    }

    @PUT
    @Path(value="/{id}/tags")
    @ApiOperation(value="Update tags associated with the metric definition.")
    @ApiResponses(value={@ApiResponse(code=200, message="Metric's tags were successfully updated."), @ApiResponse(code=500, message="Unexpected error occurred while updating metric's tags.", response=ApiError.class)})
    public void updateMetricTags(@Suspended AsyncResponse asyncResponse, @PathParam(value="id") String id, @ApiParam(required=true) Map<String, String> tags) {
        Metric metric = new Metric(new MetricId(this.getTenant(), MetricType.AVAILABILITY, id));
        this.metricsService.addTags(metric, tags).subscribe((Observer)new ResultSetObserver(asyncResponse));
    }

    @DELETE
    @Path(value="/{id}/tags/{tags}")
    @ApiOperation(value="Delete tags associated with the metric definition.")
    @ApiResponses(value={@ApiResponse(code=200, message="Metric's tags were successfully deleted."), @ApiResponse(code=400, message="Invalid tags", response=ApiError.class), @ApiResponse(code=500, message="Unexpected error occurred while trying to delete metric's tags.", response=ApiError.class)})
    public void deleteMetricTags(@Suspended AsyncResponse asyncResponse, @PathParam(value="id") String id, @ApiParam(value="Tag names", allowableValues="Comma-separated list of tag names") @PathParam(value="tags") TagNames tags) {
        Metric metric = new Metric(new MetricId(this.getTenant(), MetricType.AVAILABILITY, id));
        this.metricsService.deleteTags(metric, tags.getNames()).subscribe((Observer)new ResultSetObserver(asyncResponse));
    }

    @POST
    @Path(value="/{id}/raw")
    @ApiOperation(value="Add data for a single availability metric.")
    @ApiResponses(value={@ApiResponse(code=200, message="Adding data succeeded."), @ApiResponse(code=400, message="Missing or invalid payload", response=ApiError.class), @ApiResponse(code=500, message="Unexpected error happened while storing the data", response=ApiError.class)})
    public void addMetricData(@Suspended AsyncResponse asyncResponse, @PathParam(value="id") String id, @ApiParam(value="List of availability datapoints", required=true) List<DataPoint<AvailabilityType>> data) {
        Observable metrics = Functions.dataPointToObservable((String)this.getTenant(), (String)id, data, (MetricType)MetricType.AVAILABILITY);
        Observable observable = this.metricsService.addDataPoints(MetricType.AVAILABILITY, metrics);
        observable.subscribe((Observer)new ResultSetObserver(asyncResponse));
    }

    @Deprecated
    @POST
    @Path(value="/{id}/data")
    @ApiOperation(value="Deprecated. Please use /raw endpoint.")
    public void deprecatedAddAvailabilityForMetric(@Suspended AsyncResponse asyncResponse, @PathParam(value="id") String id, @ApiParam(value="List of availability datapoints", required=true) List<DataPoint<AvailabilityType>> data) {
        this.addMetricData(asyncResponse, id, data);
    }

    @POST
    @Path(value="/raw")
    @ApiOperation(value="Add metric data for multiple availability metrics in a single call.")
    @ApiResponses(value={@ApiResponse(code=200, message="Adding data succeeded."), @ApiResponse(code=400, message="Missing or invalid payload", response=ApiError.class), @ApiResponse(code=500, message="Unexpected error happened while storing the data", response=ApiError.class)})
    public void addData(@Suspended AsyncResponse asyncResponse, @ApiParam(value="List of availability metrics", required=true) @JsonDeserialize List<Metric<AvailabilityType>> availabilities) {
        Observable metrics = Functions.metricToObservable((String)this.getTenant(), availabilities, (MetricType)MetricType.AVAILABILITY);
        Observable observable = this.metricsService.addDataPoints(MetricType.AVAILABILITY, metrics);
        observable.subscribe((Observer)new ResultSetObserver(asyncResponse));
    }

    @POST
    @Path(value="/raw/query")
    @ApiOperation(value="Fetch raw data points for multiple metrics. This endpoint is experimental and may undergo non-backwards compatible changes in future releases.")
    @ApiResponses(value={@ApiResponse(code=200, message="Successfully fetched metric data points."), @ApiResponse(code=204, message="Query was successful, but no data was found."), @ApiResponse(code=400, message="No metric ids are specified", response=ApiError.class), @ApiResponse(code=500, message="Unexpected error occurred while fetching metric data.", response=ApiError.class)})
    public void getData(@Suspended AsyncResponse asyncResponse, @ApiParam(required=true, value="Query parameters that minimally must include a list of metric ids or tags. The standard start, end, order, and limit query parameters are supported as well.") QueryRequest query) {
        this.findMetricsByNameOrTag(query.getIds(), query.getTags(), MetricType.AVAILABILITY).toList().flatMap(metricIds -> TimeAndSortParams.deferredBuilder((String)query.getStart(), (String)query.getEnd()).fromEarliest(query.getFromEarliest(), metricIds, (arg_0, arg_1, arg_2, arg_3) -> ((AvailabilityHandler)this).findTimeRange(arg_0, arg_1, arg_2, arg_3)).sortOptions(query.getLimit(), query.getOrder()).toObservable().flatMap(p -> this.metricsService.findDataPoints(metricIds, p.getTimeRange().getStart(), p.getTimeRange().getEnd(), p.getLimit(), p.getOrder()).observeOn(Schedulers.io()))).subscribe((Subscriber)this.createNamedDataPointObserver(MetricType.AVAILABILITY));
    }

    @Deprecated
    @POST
    @Path(value="/data")
    @ApiOperation(value="Deprecated. Please use /raw endpoint.")
    public void deprecatedAddAvailabilityData(@Suspended AsyncResponse asyncResponse, @ApiParam(value="List of availability metrics", required=true) @JsonDeserialize List<Metric<AvailabilityType>> availabilities) {
        this.addData(asyncResponse, availabilities);
    }

    @Deprecated
    @GET
    @Path(value="/{id}/data")
    @ApiOperation(value="Deprecated. Please use /raw or /stats endpoints.", response=DataPoint.class, responseContainer="List")
    public void deprecatedFindAvailabilityData(@Suspended AsyncResponse asyncResponse, @PathParam(value="id") String id, @ApiParam(value="Defaults to now - 8 hours") @QueryParam(value="start") String start, @ApiParam(value="Defaults to now") @QueryParam(value="end") String end, @ApiParam(value="Total number of buckets") @QueryParam(value="buckets") Integer bucketsCount, @ApiParam(value="Bucket duration") @QueryParam(value="bucketDuration") Duration bucketDuration, @ApiParam(value="Set to true to return only distinct, contiguous values") @QueryParam(value="distinct") @DefaultValue(value="false") Boolean distinct, @ApiParam(value="Limit the number of data points returned") @QueryParam(value="limit") Integer limit, @ApiParam(value="Data point sort order, based on timestamp") @QueryParam(value="order") Order order) {
        if (!(bucketsCount == null && bucketDuration == null || limit == null && order == null)) {
            asyncResponse.resume((Object)ApiUtils.badRequest((ApiError)new ApiError("Limit and order cannot be used with bucketed results")));
            return;
        }
        TimeRange timeRange = new TimeRange(start, end);
        if (!timeRange.isValid()) {
            asyncResponse.resume((Object)ApiUtils.badRequest((ApiError)new ApiError(timeRange.getProblem())));
            return;
        }
        BucketConfig bucketConfig = new BucketConfig(bucketsCount, bucketDuration, timeRange);
        if (!bucketConfig.isValid()) {
            asyncResponse.resume((Object)ApiUtils.badRequest((ApiError)new ApiError(bucketConfig.getProblem())));
            return;
        }
        MetricId metricId = new MetricId(this.getTenant(), MetricType.AVAILABILITY, id);
        Buckets buckets = bucketConfig.getBuckets();
        if (buckets == null) {
            if (limit == null) {
                limit = 0;
            }
            if (order == null) {
                order = Order.defaultValue((int)limit, (Object)start, (Object)end);
            }
            this.metricsService.findAvailabilityData(metricId, timeRange.getStart(), timeRange.getEnd(), distinct.booleanValue(), limit.intValue(), order).toList().map(ApiUtils::collectionToResponse).subscribe(arg_0 -> ((AsyncResponse)asyncResponse).resume(arg_0), t -> asyncResponse.resume((Object)ApiUtils.serverError((Throwable)t)));
        } else {
            this.metricsService.findAvailabilityStats(metricId, timeRange.getStart(), timeRange.getEnd(), buckets).map(ApiUtils::collectionToResponse).subscribe(arg_0 -> ((AsyncResponse)asyncResponse).resume(arg_0), t -> asyncResponse.resume((Object)ApiUtils.serverError((Throwable)t)));
        }
    }

    @GET
    @Path(value="/{id}/raw")
    @ApiOperation(value="Retrieve availability data.", response=DataPoint.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=200, message="Successfully fetched availability data."), @ApiResponse(code=204, message="No availability data was found."), @ApiResponse(code=400, message="buckets or bucketDuration parameter is invalid, or both are used.", response=ApiError.class), @ApiResponse(code=500, message="Unexpected error occurred while fetching availability data.", response=ApiError.class)})
    public void getMetricData(@Suspended AsyncResponse asyncResponse, @PathParam(value="id") String id, @ApiParam(value="Defaults to now - 8 hours") @QueryParam(value="start") String start, @ApiParam(value="Defaults to now") @QueryParam(value="end") String end, @ApiParam(value="Use data from earliest received, subject to retention period") @QueryParam(value="fromEarliest") Boolean fromEarliest, @ApiParam(value="Set to true to return only distinct, contiguous values") @QueryParam(value="distinct") @DefaultValue(value="false") Boolean distinct, @ApiParam(value="Limit the number of data points returned") @QueryParam(value="limit") Integer limit, @ApiParam(value="Data point sort order, based on timestamp") @QueryParam(value="order") Order order) {
        MetricId metricId = new MetricId(this.getTenant(), MetricType.AVAILABILITY, id);
        TimeAndSortParams.deferredBuilder((String)start, (String)end).fromEarliest(fromEarliest, metricId, (arg_0, arg_1, arg_2, arg_3) -> ((AvailabilityHandler)this).findTimeRange(arg_0, arg_1, arg_2, arg_3)).sortOptions(limit, order).toObservable().flatMap(p -> this.metricsService.findAvailabilityData(metricId, p.getTimeRange().getStart(), p.getTimeRange().getEnd(), distinct.booleanValue(), p.getLimit(), p.getOrder())).toList().map(ApiUtils::collectionToResponse).subscribe(arg_0 -> ((AsyncResponse)asyncResponse).resume(arg_0), t -> asyncResponse.resume((Object)ApiUtils.error((Throwable)t)));
    }

    @GET
    @Path(value="/{id}/stats")
    @ApiOperation(value="Retrieve availability data.", notes="Based on buckets or bucketDuration query parameter, the time range between start and end will be divided in buckets of equal duration, and availability statistics will be computed for each bucket.", response=AvailabilityBucketPoint.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=200, message="Successfully fetched availability data."), @ApiResponse(code=204, message="No availability data was found."), @ApiResponse(code=400, message="buckets or bucketDuration parameter is invalid, or both are used.", response=ApiError.class), @ApiResponse(code=500, message="Unexpected error occurred while fetching availability data.", response=ApiError.class)})
    public void getMetricStats(@Suspended AsyncResponse asyncResponse, @PathParam(value="id") String id, @ApiParam(value="Defaults to now - 8 hours") @QueryParam(value="start") String start, @ApiParam(value="Defaults to now") @QueryParam(value="end") String end, @ApiParam(value="Use data from earliest received, subject to retention period") @QueryParam(value="fromEarliest") Boolean fromEarliest, @ApiParam(value="Total number of buckets") @QueryParam(value="buckets") Integer bucketsCount, @ApiParam(value="Bucket duration") @QueryParam(value="bucketDuration") Duration bucketDuration) {
        MetricId metricId = new MetricId(this.getTenant(), MetricType.AVAILABILITY, id);
        TimeAndBucketParams.deferredBuilder((String)start, (String)end).fromEarliest(fromEarliest, metricId, (arg_0, arg_1, arg_2, arg_3) -> ((AvailabilityHandler)this).findTimeRange(arg_0, arg_1, arg_2, arg_3)).bucketConfig(bucketsCount, bucketDuration).toObservable().flatMap(p -> this.metricsService.findAvailabilityStats(metricId, p.getTimeRange().getStart(), p.getTimeRange().getEnd(), p.getBucketConfig().getBuckets())).flatMap(Observable::from).skipWhile(bucket -> Boolean.TRUE.equals(fromEarliest) && bucket.isEmpty()).toList().map(ApiUtils::collectionToResponse).subscribe(arg_0 -> ((AsyncResponse)asyncResponse).resume(arg_0), t -> asyncResponse.resume((Object)ApiUtils.error((Throwable)t)));
    }
}

