/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.api.jaxrs.log;

import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.ValidIdRange;

@MessageLogger(projectCode="HAWKMETRICS")
@ValidIdRange(min=200000, max=209999)
public interface RestLogger
extends BasicLogger {
    @LogMessage(level=Logger.Level.INFO)
    @Message(id=200001, value="Hawkular Metrics starting")
    public void infoAppStarting();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=200002, value="Initializing metrics service")
    public void infoInitializing();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=200003, value="Could not connect to Cassandra cluster - assuming its not up yet: %s")
    public void warnCouldNotConnectToCassandra(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=200004, value="[%d] Retrying connecting to Cassandra cluster in [%d]s...")
    public void warnRetryingConnectingToCassandra(Integer var1, Long var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=200005, value="Metrics service started")
    public void infoServiceStarted();

    @LogMessage(level=Logger.Level.FATAL)
    @Message(id=200006, value="An error occurred trying to connect to the Cassandra cluster")
    public void fatalCannotConnectToCassandra(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=200007, value="Could not shutdown the Metrics service instance")
    public void errorCouldNotCloseServiceInstance(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=200008, value="Invalid CQL port %s, not a number. Will use a default of %s")
    public void warnInvalidCqlPort(String var1, String var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=200009, value="Unexcepted exception while shutting down")
    public void errorShutdownProblem(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=200010, value="Failed to process request")
    public void errorRequestProblem(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=200011, value="Invalid value [%s] for default TTL. Will use a default of %s days")
    public void warnInvalidDefaultTTL(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=200012, value="Invalid value [%s] for max connections per host. Will use a default of %s")
    public void warnInvalidMaxConnections(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=200013, value="Invalid value [%s] for max requests per connection. Will use a default of %s")
    public void warnInvalidMaxRequests(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=200014, value="Invalid value [%s] for Cassandra driver request timeout. Will use default value of %s")
    public void warnInvalidRequestTimeout(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=200015, value="Invalid value [%s] for Cassandra driver connection timeout. Will use default value of %s")
    public void warnInvalidConnectionTimeout(String var1, String var2);
}

