/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.api.jaxrs.handler;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import org.hawkular.metrics.api.jaxrs.handler.observer.ResultSetObserver;
import org.hawkular.metrics.api.jaxrs.util.ApiUtils;
import org.hawkular.metrics.core.service.Functions;
import org.hawkular.metrics.core.service.MetricsService;
import org.hawkular.metrics.core.service.Order;
import org.hawkular.metrics.model.ApiError;
import org.hawkular.metrics.model.DataPoint;
import org.hawkular.metrics.model.Metric;
import org.hawkular.metrics.model.MetricId;
import org.hawkular.metrics.model.MetricType;
import org.hawkular.metrics.model.param.TimeRange;
import rx.Observable;
import rx.Observer;

@Path(value="/strings")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Api(tags={"String"}, description="This resource is experimental and changes may be made to it in subsequent releases that are not backwards compatible.")
public class StringHandler {
    @Inject
    private MetricsService metricsService;
    @HeaderParam(value="Hawkular-Tenant")
    private String tenantId;

    @POST
    @Path(value="/{id}/raw")
    @ApiOperation(value="Add data for a single string metric.")
    @ApiResponses(value={@ApiResponse(code=200, message="Adding data succeeded."), @ApiResponse(code=400, message="Missing or invalid payload", response=ApiError.class), @ApiResponse(code=500, message="Unexpected error happened while storing the data", response=ApiError.class)})
    public void addStringForMetric(@Suspended AsyncResponse asyncResponse, @PathParam(value="id") String id, @ApiParam(value="List of string datapoints", required=true) List<DataPoint<String>> data) {
        Observable metrics = Functions.dataPointToObservable((String)this.tenantId, (String)id, data, (MetricType)MetricType.STRING);
        Observable observable = this.metricsService.addDataPoints(MetricType.STRING, metrics);
        observable.subscribe((Observer)new ResultSetObserver(asyncResponse));
    }

    @POST
    @Path(value="/raw")
    @ApiOperation(value="Add metric data for multiple string metrics in a single call.")
    @ApiResponses(value={@ApiResponse(code=200, message="Adding data succeeded."), @ApiResponse(code=400, message="Missing or invalid payload", response=ApiError.class), @ApiResponse(code=500, message="Unexpected error happened while storing the data", response=ApiError.class)})
    public void addStringData(@Suspended AsyncResponse asyncResponse, @ApiParam(value="List of string metrics", required=true) @JsonDeserialize List<Metric<String>> availabilities) {
        Observable metrics = Functions.metricToObservable((String)this.tenantId, availabilities, (MetricType)MetricType.STRING);
        Observable observable = this.metricsService.addDataPoints(MetricType.STRING, metrics);
        observable.subscribe((Observer)new ResultSetObserver(asyncResponse));
    }

    @GET
    @Path(value="/{id}/raw")
    @ApiOperation(value="Retrieve string data.", response=DataPoint.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=200, message="Successfully fetched string data."), @ApiResponse(code=204, message="No string data was found."), @ApiResponse(code=500, message="Unexpected error occurred while fetching string data.", response=ApiError.class)})
    public void findRawStringData(@Suspended AsyncResponse asyncResponse, @PathParam(value="id") String id, @ApiParam(value="Defaults to now - 8 hours") @QueryParam(value="start") Long start, @ApiParam(value="Defaults to now") @QueryParam(value="end") Long end, @ApiParam(value="Set to true to return only distinct, contiguous values") @QueryParam(value="distinct") @DefaultValue(value="false") Boolean distinct, @ApiParam(value="Limit the number of data points returned") @QueryParam(value="limit") Integer limit, @ApiParam(value="Data point sort order, based on timestamp") @QueryParam(value="order") Order order) {
        TimeRange timeRange = new TimeRange(start, end);
        if (!timeRange.isValid()) {
            asyncResponse.resume((Object)ApiUtils.badRequest((ApiError)new ApiError(timeRange.getProblem())));
            return;
        }
        MetricId metricId = new MetricId(this.tenantId, MetricType.STRING, id);
        if (limit != null) {
            if (order == null) {
                order = start == null && end != null ? Order.DESC : (start != null && end == null ? Order.ASC : Order.DESC);
            }
        } else {
            limit = 0;
        }
        if (order == null) {
            order = Order.DESC;
        }
        this.metricsService.findStringData(metricId, timeRange.getStart(), timeRange.getEnd(), distinct.booleanValue(), limit.intValue(), order).toList().map(ApiUtils::collectionToResponse).subscribe(arg_0 -> ((AsyncResponse)asyncResponse).resume(arg_0), t -> asyncResponse.resume((Object)ApiUtils.serverError((Throwable)t)));
    }
}

