/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.api.jaxrs.handler;

import com.google.common.base.Strings;
import com.google.common.collect.ObjectArrays;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.regex.PatternSyntaxException;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.hawkular.metrics.api.jaxrs.handler.observer.MetricCreatedObserver;
import org.hawkular.metrics.api.jaxrs.util.ApiUtils;
import org.hawkular.metrics.api.jaxrs.util.MetricTypeTextConverter;
import org.hawkular.metrics.core.service.Functions;
import org.hawkular.metrics.core.service.MetricsService;
import org.hawkular.metrics.model.ApiError;
import org.hawkular.metrics.model.Metric;
import org.hawkular.metrics.model.MetricId;
import org.hawkular.metrics.model.MetricType;
import org.hawkular.metrics.model.MixedMetricsRequest;
import org.hawkular.metrics.model.param.Tags;
import rx.Observable;
import rx.Observer;
import rx.functions.Func1;

@Path(value="/metrics")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Api(tags={"Metric"})
public class MetricHandler {
    @Inject
    private MetricsService metricsService;
    @HeaderParam(value="Hawkular-Tenant")
    private String tenantId;

    @POST
    @Path(value="/")
    @ApiOperation(value="Create metric.", notes="Clients are not required to explicitly create a metric before storing data. Doing so however allows clients to prevent naming collisions and to specify tags and data retention.")
    @ApiResponses(value={@ApiResponse(code=201, message="Metric created successfully"), @ApiResponse(code=400, message="Missing or invalid payload", response=ApiError.class), @ApiResponse(code=409, message="Metric with given id already exists", response=ApiError.class), @ApiResponse(code=500, message="Metric creation failed due to an unexpected error", response=ApiError.class)})
    public <T> void createMetric(@Suspended AsyncResponse asyncResponse, @ApiParam(required=true) Metric<T> metric, @ApiParam(value="Overwrite previously created metric if it exists. Defaults to false.", required=false) @DefaultValue(value="false") @QueryParam(value="overwrite") Boolean overwrite, @Context UriInfo uriInfo) {
        if (metric.getType() == null || !metric.getType().isUserType()) {
            asyncResponse.resume((Object)ApiUtils.badRequest((ApiError)new ApiError("Metric type is invalid")));
        }
        MetricId id = new MetricId(this.tenantId, metric.getMetricId().getType(), metric.getId());
        metric = new Metric(id, metric.getTags(), metric.getDataRetention());
        URI location = uriInfo.getBaseUriBuilder().path("/{type}/{id}").build(new Object[]{MetricTypeTextConverter.getLongForm((MetricType)id.getType()), id.getName()});
        this.metricsService.createMetric(metric, overwrite.booleanValue()).subscribe((Observer)new MetricCreatedObserver(asyncResponse, location));
    }

    @GET
    @Path(value="/tags/{tags}")
    @ApiOperation(value="Retrieve metrics' tag values", response=Map.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Tags successfully retrieved."), @ApiResponse(code=204, message="No matching tags were found"), @ApiResponse(code=500, message="Unexpected error occurred while fetching tags.", response=ApiError.class)})
    public <T> void getTags(@Suspended AsyncResponse asyncResponse, @ApiParam(value="Queried metric type", allowableValues="gauge, availability, counter") @QueryParam(value="type") MetricType<T> metricType, @ApiParam(value="Tag query") @PathParam(value="tags") Tags tags) {
        this.metricsService.getTagValues(this.tenantId, metricType, tags.getTags()).map(ApiUtils::mapToResponse).subscribe(arg_0 -> ((AsyncResponse)asyncResponse).resume(arg_0), t -> asyncResponse.resume((Object)ApiUtils.serverError((Throwable)t)));
    }

    @GET
    @Path(value="/")
    @ApiOperation(value="Find tenant's metric definitions.", notes="Does not include any metric values. ", response=Metric.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=200, message="Successfully retrieved at least one metric definition."), @ApiResponse(code=204, message="No metrics found."), @ApiResponse(code=400, message="Invalid type parameter type.", response=ApiError.class), @ApiResponse(code=500, message="Failed to retrieve metrics due to unexpected error.", response=ApiError.class)})
    public <T> void findMetrics(@Suspended AsyncResponse asyncResponse, @ApiParam(value="Queried metric type", required=false, allowableValues="gauge, availability, counter") @QueryParam(value="type") MetricType<T> metricType, @ApiParam(value="List of tags filters", required=false) @QueryParam(value="tags") Tags tags, @ApiParam(value="Regexp to match metricId, requires tags filtering", required=false) @QueryParam(value="id") String id) {
        if (metricType != null && !metricType.isUserType()) {
            asyncResponse.resume((Object)ApiUtils.badRequest((ApiError)new ApiError("Incorrect type param " + metricType.toString())));
            return;
        }
        Object[] metricFuncs = (Func1[])ObjectArrays.newArray(Func1.class, (int)0);
        if (!Strings.isNullOrEmpty((String)id)) {
            metricFuncs = (Func1[])ObjectArrays.concat((Object[])metricFuncs, (Object)this.metricsService.idFilter(id));
        }
        Observable metricObservable = tags == null ? this.metricsService.findMetrics(this.tenantId, metricType) : this.metricsService.findMetricsWithFilters(this.tenantId, metricType, tags.getTags(), (Func1[])metricFuncs);
        metricObservable.toList().map(ApiUtils::collectionToResponse).subscribe(arg_0 -> ((AsyncResponse)asyncResponse).resume(arg_0), t -> {
            if (t instanceof PatternSyntaxException) {
                asyncResponse.resume((Object)ApiUtils.badRequest((Throwable)t));
            } else {
                asyncResponse.resume((Object)ApiUtils.serverError((Throwable)t));
            }
        });
    }

    @Deprecated
    @POST
    @Path(value="/data")
    @ApiOperation(value="Deprecated. Please use /raw endpoint.")
    public void deprecatedAddMetricsData(@Suspended AsyncResponse asyncResponse, @ApiParam(value="List of metrics", required=true) MixedMetricsRequest metricsRequest) {
        this.addMetricsData(asyncResponse, metricsRequest);
    }

    @POST
    @Path(value="/raw")
    @ApiOperation(value="Add data points for multiple metrics in a single call.")
    @ApiResponses(value={@ApiResponse(code=200, message="Adding data points succeeded."), @ApiResponse(code=400, message="Missing or invalid payload.", response=ApiError.class), @ApiResponse(code=500, message="Unexpected error happened while storing the data", response=ApiError.class)})
    public void addMetricsData(@Suspended AsyncResponse asyncResponse, @ApiParam(value="List of metrics", required=true) MixedMetricsRequest metricsRequest) {
        if (metricsRequest.isEmpty()) {
            asyncResponse.resume((Object)ApiUtils.emptyPayload());
            return;
        }
        Observable gauges = Functions.metricToObservable((String)this.tenantId, (List)metricsRequest.getGauges(), (MetricType)MetricType.GAUGE);
        Observable availabilities = Functions.metricToObservable((String)this.tenantId, (List)metricsRequest.getAvailabilities(), (MetricType)MetricType.AVAILABILITY);
        Observable counters = Functions.metricToObservable((String)this.tenantId, (List)metricsRequest.getCounters(), (MetricType)MetricType.COUNTER);
        Observable strings = Functions.metricToObservable((String)this.tenantId, (List)metricsRequest.getStrings(), (MetricType)MetricType.STRING);
        this.metricsService.addDataPoints(MetricType.GAUGE, gauges).mergeWith(this.metricsService.addDataPoints(MetricType.AVAILABILITY, availabilities)).mergeWith(this.metricsService.addDataPoints(MetricType.COUNTER, counters)).mergeWith(this.metricsService.addDataPoints(MetricType.STRING, strings)).subscribe(aVoid -> {}, t -> asyncResponse.resume((Object)ApiUtils.serverError((Throwable)t)), () -> asyncResponse.resume((Object)Response.ok().build()));
    }
}

