/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.api.jaxrs.util;

import com.google.common.collect.ImmutableList;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.enterprise.context.ApplicationScoped;
import javax.servlet.ServletContext;
import org.hawkular.metrics.api.jaxrs.util.Eager;

@ApplicationScoped
@Eager
public class ManifestInformation {
    private static final List<String> VERSION_ATTRIBUTES = ImmutableList.of((Object)"Implementation-Version", (Object)"Built-From-Git-SHA1");

    public Map<String, String> getFrom(ServletContext servletContext) {
        HashMap<String, String> manifestInformation = new HashMap<String, String>();
        try (InputStream inputStream = servletContext.getResourceAsStream("/META-INF/MANIFEST.MF");){
            Manifest manifest = new Manifest(inputStream);
            Attributes attr = manifest.getMainAttributes();
            for (String attribute : VERSION_ATTRIBUTES) {
                manifestInformation.put(attribute, attr.getValue(attribute));
            }
        }
        catch (Exception e) {
            for (String attribute : VERSION_ATTRIBUTES) {
                if (manifestInformation.get(attribute) != null) continue;
                manifestInformation.put(attribute, "Unknown");
            }
        }
        return manifestInformation;
    }
}

