/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.api.jaxrs.handler;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.hawkular.metrics.api.jaxrs.util.ApiUtils;
import org.hawkular.metrics.api.jaxrs.util.TestClock;
import org.hawkular.metrics.api.jaxrs.util.VirtualClock;
import org.hawkular.metrics.model.param.Duration;
import org.hawkular.metrics.tasks.api.TaskScheduler;
import org.jboss.logging.Logger;
import rx.Subscriber;
import rx.observers.TestSubscriber;
import rx.schedulers.Schedulers;

@Path(value="/clock")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class VirtualClockHandler {
    private static Logger log = Logger.getLogger(VirtualClockHandler.class);
    public static final String PATH = "/clock";
    @Inject
    @TestClock
    private VirtualClock virtualClock;
    @Inject
    private TaskScheduler taskScheduler;

    @GET
    public Response getTime() {
        return Response.ok((Object)ImmutableMap.of((Object)"now", (Object)this.virtualClock.now())).build();
    }

    @PUT
    public Response setTime(Map<String, Object> params) {
        Long time = (Long)params.get("time");
        this.virtualClock.advanceTimeTo(time.longValue());
        return Response.ok().build();
    }

    @POST
    public Response incrementTime(Duration duration) {
        this.virtualClock.advanceTimeBy(duration.getValue(), duration.getTimeUnit());
        return Response.ok().build();
    }

    @GET
    @Path(value="/wait")
    public Response waitForDuration(@QueryParam(value="duration") Duration duration) {
        int numMinutes = (int)TimeUnit.MINUTES.convert(duration.getValue(), duration.getTimeUnit());
        TestSubscriber timeSlicesSubscriber = new TestSubscriber();
        this.taskScheduler.getFinishedTimeSlices().take(numMinutes).observeOn(Schedulers.immediate()).subscribe((Subscriber)timeSlicesSubscriber);
        try {
            this.virtualClock.advanceTimeBy((long)numMinutes, TimeUnit.MINUTES);
            long timeout = Long.parseLong(System.getProperty("hawkular.terminal-event.timeout", "10"));
            timeSlicesSubscriber.awaitTerminalEvent(timeout, TimeUnit.SECONDS);
            timeSlicesSubscriber.assertNoErrors();
            timeSlicesSubscriber.assertTerminalEvent();
            return Response.ok().build();
        }
        catch (Exception e) {
            log.warn((Object)("Failed to wait " + numMinutes + " minutes for task scheduler to complete work"), (Throwable)e);
            return ApiUtils.serverError((Throwable)e);
        }
    }
}

