/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.api.jaxrs.handler;

import com.google.common.collect.ObjectArrays;
import java.net.URI;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.hawkular.metrics.api.jaxrs.util.ApiUtils;
import org.hawkular.metrics.api.jaxrs.util.MetricTypeTextConverter;
import org.hawkular.metrics.core.service.Functions;
import org.hawkular.metrics.core.service.MetricsService;
import org.hawkular.metrics.model.ApiError;
import org.hawkular.metrics.model.Metric;
import org.hawkular.metrics.model.MetricId;
import org.hawkular.metrics.model.MetricType;
import org.hawkular.metrics.model.MixedMetricsRequest;
import org.hawkular.metrics.model.exception.MetricAlreadyExistsException;
import org.hawkular.metrics.model.param.Tags;
import rx.Observable;
import rx.functions.Func1;

@Path(value="/metrics")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class MetricHandler {
    @Inject
    private MetricsService metricsService;
    @HeaderParam(value="Hawkular-Tenant")
    private String tenantId;

    @POST
    @Path(value="/")
    public <T> Response createMetric(Metric<T> metric, @Context UriInfo uriInfo) {
        if (metric.getType() == null || !metric.getType().isUserType()) {
            return ApiUtils.badRequest((ApiError)new ApiError("Metric type is invalid"));
        }
        MetricId id = new MetricId(this.tenantId, metric.getMetricId().getType(), metric.getId());
        metric = new Metric(id, metric.getTags(), metric.getDataRetention());
        URI location = uriInfo.getBaseUriBuilder().path("/{type}/{id}").build(new Object[]{MetricTypeTextConverter.getLongForm((MetricType)id.getType()), id.getName()});
        try {
            Observable observable = this.metricsService.createMetric(metric);
            observable.toBlocking().lastOrDefault(null);
            return Response.created((URI)location).build();
        }
        catch (MetricAlreadyExistsException e) {
            String message = "A metric with name [" + e.getMetric().getMetricId().getName() + "] already exists";
            return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)new ApiError(message)).build();
        }
        catch (Exception e) {
            return ApiUtils.serverError((Throwable)e);
        }
    }

    @GET
    @Path(value="/")
    public <T> Response findMetrics(@QueryParam(value="type") MetricType<T> metricType, @QueryParam(value="tags") Tags tags, @QueryParam(value="id") String id) {
        if (metricType != null && !metricType.isUserType()) {
            return ApiUtils.badRequest((ApiError)new ApiError("Incorrect type param " + metricType.toString()));
        }
        Object[] metricFuncs = (Func1[])ObjectArrays.newArray(Func1.class, (int)0);
        if (id != null) {
            metricFuncs = (Func1[])ObjectArrays.concat((Object[])metricFuncs, (Object)this.metricsService.idFilter(id));
        }
        Observable metricObservable = tags == null ? this.metricsService.findMetrics(this.tenantId, metricType) : this.metricsService.findMetricsWithFilters(this.tenantId, metricType, tags.getTags(), (Func1[])metricFuncs);
        try {
            return (Response)metricObservable.toList().map(ApiUtils::collectionToResponse).toBlocking().lastOrDefault(null);
        }
        catch (PatternSyntaxException e) {
            return ApiUtils.badRequest((Throwable)e);
        }
        catch (Exception e) {
            return ApiUtils.serverError((Throwable)e);
        }
    }

    @POST
    @Path(value="/data")
    public Response addMetricsData(MixedMetricsRequest metricsRequest) {
        if (metricsRequest.isEmpty()) {
            return ApiUtils.emptyPayload();
        }
        Observable gauges = Functions.metricToObservable((String)this.tenantId, (List)metricsRequest.getGauges(), (MetricType)MetricType.GAUGE);
        Observable availabilities = Functions.metricToObservable((String)this.tenantId, (List)metricsRequest.getAvailabilities(), (MetricType)MetricType.AVAILABILITY);
        Observable counters = Functions.metricToObservable((String)this.tenantId, (List)metricsRequest.getCounters(), (MetricType)MetricType.COUNTER);
        try {
            this.metricsService.addDataPoints(MetricType.GAUGE, gauges).mergeWith(this.metricsService.addDataPoints(MetricType.AVAILABILITY, availabilities)).mergeWith(this.metricsService.addDataPoints(MetricType.COUNTER, counters)).toBlocking().lastOrDefault(null);
            return Response.ok().build();
        }
        catch (Exception e) {
            return ApiUtils.serverError((Throwable)e);
        }
    }
}

