/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.api.jaxrs.handler;

import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.regex.PatternSyntaxException;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.hawkular.metrics.api.jaxrs.util.ApiUtils;
import org.hawkular.metrics.core.service.Functions;
import org.hawkular.metrics.core.service.MetricsService;
import org.hawkular.metrics.core.service.Order;
import org.hawkular.metrics.model.ApiError;
import org.hawkular.metrics.model.AvailabilityType;
import org.hawkular.metrics.model.Buckets;
import org.hawkular.metrics.model.DataPoint;
import org.hawkular.metrics.model.Metric;
import org.hawkular.metrics.model.MetricId;
import org.hawkular.metrics.model.MetricType;
import org.hawkular.metrics.model.exception.MetricAlreadyExistsException;
import org.hawkular.metrics.model.param.BucketConfig;
import org.hawkular.metrics.model.param.Duration;
import org.hawkular.metrics.model.param.Tags;
import org.hawkular.metrics.model.param.TimeRange;
import rx.Observable;
import rx.functions.Func1;

@Path(value="/availability")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class AvailabilityHandler {
    @Inject
    private MetricsService metricsService;
    @HeaderParam(value="Hawkular-Tenant")
    private String tenantId;

    @POST
    @Path(value="/")
    public Response createAvailabilityMetric(Metric<AvailabilityType> metric, @Context UriInfo uriInfo) {
        if (metric.getType() != null && MetricType.UNDEFINED != metric.getType() && MetricType.AVAILABILITY != metric.getType()) {
            return ApiUtils.badRequest((ApiError)new ApiError("Metric type does not match " + MetricType.AVAILABILITY.getText()));
        }
        URI location = uriInfo.getBaseUriBuilder().path("/availability/{id}").build(new Object[]{metric.getId()});
        metric = new Metric(new MetricId(this.tenantId, MetricType.AVAILABILITY, metric.getId()), metric.getTags(), metric.getDataRetention());
        try {
            Observable observable = this.metricsService.createMetric(metric);
            observable.toBlocking().lastOrDefault(null);
            return Response.created((URI)location).build();
        }
        catch (MetricAlreadyExistsException e) {
            String message = "A metric with name [" + e.getMetric().getMetricId().getName() + "] already exists";
            return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)new ApiError(message)).build();
        }
        catch (Exception e) {
            return ApiUtils.serverError((Throwable)e);
        }
    }

    @GET
    @Path(value="/")
    public Response findAvailabilityMetrics(@QueryParam(value="tags") Tags tags) {
        Observable metricObservable = tags == null ? this.metricsService.findMetrics(this.tenantId, MetricType.AVAILABILITY) : this.metricsService.findMetricsWithFilters(this.tenantId, MetricType.AVAILABILITY, tags.getTags(), new Func1[0]);
        try {
            return (Response)metricObservable.toList().map(ApiUtils::collectionToResponse).toBlocking().lastOrDefault(null);
        }
        catch (PatternSyntaxException e) {
            return ApiUtils.badRequest((Throwable)e);
        }
        catch (Exception e) {
            return ApiUtils.serverError((Throwable)e);
        }
    }

    @GET
    @Path(value="/{id}")
    public Response getAvailabilityMetric(@PathParam(value="id") String id) {
        try {
            return (Response)this.metricsService.findMetric(new MetricId(this.tenantId, MetricType.AVAILABILITY, id)).map(metricDef -> Response.ok((Object)metricDef).build()).switchIfEmpty(Observable.just((Object)ApiUtils.noContent())).toBlocking().firstOrDefault(null);
        }
        catch (Exception e) {
            return ApiUtils.serverError((Throwable)e);
        }
    }

    @GET
    @Path(value="/{id}/tags")
    public Response getMetricTags(@PathParam(value="id") String id) {
        Observable something = this.metricsService.getMetricTags(new MetricId(this.tenantId, MetricType.AVAILABILITY, id));
        try {
            return (Response)something.map(ApiUtils::valueToResponse).toBlocking().lastOrDefault(null);
        }
        catch (Exception e) {
            return ApiUtils.serverError((Throwable)e);
        }
    }

    @PUT
    @Path(value="/{id}/tags")
    public Response updateMetricTags(@PathParam(value="id") String id, Map<String, String> tags) {
        Metric metric = new Metric(new MetricId(this.tenantId, MetricType.AVAILABILITY, id));
        try {
            this.metricsService.addTags(metric, tags).toBlocking().lastOrDefault(null);
            return Response.ok().build();
        }
        catch (IllegalArgumentException e1) {
            return ApiUtils.badRequest((ApiError)new ApiError(e1.getMessage()));
        }
        catch (Exception e) {
            return ApiUtils.serverError((Throwable)e);
        }
    }

    @DELETE
    @Path(value="/{id}/tags/{tags}")
    public Response deleteMetricTags(@PathParam(value="id") String id, @PathParam(value="tags") Tags tags) {
        Metric metric = new Metric(new MetricId(this.tenantId, MetricType.AVAILABILITY, id));
        try {
            this.metricsService.deleteTags(metric, tags.getTags()).toBlocking().lastOrDefault(null);
            return Response.ok().build();
        }
        catch (Exception e) {
            return ApiUtils.serverError((Throwable)e);
        }
    }

    @POST
    @Path(value="/{id}/data")
    public Response addAvailabilityForMetric(@PathParam(value="id") String id, List<DataPoint<AvailabilityType>> data) {
        Observable metrics = Functions.dataPointToObservable((String)this.tenantId, (String)id, data, (MetricType)MetricType.AVAILABILITY);
        try {
            this.metricsService.addDataPoints(MetricType.AVAILABILITY, metrics).toBlocking().lastOrDefault(null);
            return Response.ok().build();
        }
        catch (Exception e) {
            return ApiUtils.serverError((Throwable)e);
        }
    }

    @POST
    @Path(value="/data")
    public Response addAvailabilityData(List<Metric<AvailabilityType>> availabilities) {
        Observable metrics = Functions.metricToObservable((String)this.tenantId, availabilities, (MetricType)MetricType.AVAILABILITY);
        try {
            this.metricsService.addDataPoints(MetricType.AVAILABILITY, metrics).toBlocking().lastOrDefault(null);
            return Response.ok().build();
        }
        catch (Exception e) {
            return ApiUtils.serverError((Throwable)e);
        }
    }

    @GET
    @Path(value="/{id}/data")
    public Response findAvailabilityData(@PathParam(value="id") String id, @QueryParam(value="start") Long start, @QueryParam(value="end") Long end, @QueryParam(value="buckets") Integer bucketsCount, @QueryParam(value="bucketDuration") Duration bucketDuration, @QueryParam(value="distinct") @DefaultValue(value="false") Boolean distinct, @QueryParam(value="limit") Integer limit, @QueryParam(value="order") Order order) {
        if (!(bucketsCount == null && bucketDuration == null || limit == null && order == null)) {
            return ApiUtils.badRequest((ApiError)new ApiError("Limit and order cannot be used with bucketed results"));
        }
        TimeRange timeRange = new TimeRange(start, end);
        if (!timeRange.isValid()) {
            return ApiUtils.badRequest((ApiError)new ApiError(timeRange.getProblem()));
        }
        BucketConfig bucketConfig = new BucketConfig(bucketsCount, bucketDuration, timeRange);
        if (!bucketConfig.isValid()) {
            return ApiUtils.badRequest((ApiError)new ApiError(bucketConfig.getProblem()));
        }
        MetricId metricId = new MetricId(this.tenantId, MetricType.AVAILABILITY, id);
        Buckets buckets = bucketConfig.getBuckets();
        try {
            if (buckets == null) {
                if (limit != null) {
                    if (order == null) {
                        order = start == null && end != null ? Order.DESC : (start != null && end == null ? Order.ASC : Order.DESC);
                    }
                } else {
                    limit = 0;
                }
                if (order == null) {
                    order = Order.DESC;
                }
                return (Response)this.metricsService.findAvailabilityData(metricId, timeRange.getStart(), timeRange.getEnd(), distinct.booleanValue(), limit.intValue(), order).toList().map(ApiUtils::collectionToResponse).toBlocking().lastOrDefault(null);
            }
            return (Response)this.metricsService.findAvailabilityStats(metricId, timeRange.getStart(), timeRange.getEnd(), buckets).map(ApiUtils::collectionToResponse).toBlocking().lastOrDefault(null);
        }
        catch (Exception e) {
            return ApiUtils.serverError((Throwable)e);
        }
    }
}

