/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.datamining.rest.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@WebFilter(asyncSupported=true, urlPatterns={"/*"})
public class CorsFilter
implements Filter {
    private static final String PREFLIGHT_METHOD = "OPTIONS";
    public static final String ACCESS_CONTROL_ALLOW_CREDENTIALS = "Access-Control-Allow-Credentials";
    public static final String ACCESS_CONTROL_ALLOW_HEADERS = "Access-Control-Allow-Headers";
    public static final String ACCESS_CONTROL_ALLOW_METHODS = "Access-Control-Allow-Methods";
    public static final String ACCESS_CONTROL_ALLOW_ORIGIN = "Access-Control-Allow-Origin";
    public static final String ACCESS_CONTROL_MAX_AGE = "Access-Control-Max-Age";
    public static final String ACCESS_CONTROL_REQUEST_METHOD = "Access-Control-Request-Method";
    public static final String ORIGIN = "Origin";
    public static final String DEFAULT_CORS_ACCESS_CONTROL_ALLOW_METHODS = "GET, POST, PUT, DELETE, OPTIONS, HEAD";
    public static final String DEFAULT_CORS_ACCESS_CONTROL_ALLOW_HEADERS = "origin,accept,content-type,hawkular-tenant, authorization,  hawkular-persona";
    public static final String ALLOW_ALL_ORIGIN = "*";

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        String requestOrigin = httpRequest.getHeader(ORIGIN);
        if (requestOrigin == null) {
            chain.doFilter(request, response);
            return;
        }
        httpResponse.addHeader(ACCESS_CONTROL_ALLOW_ORIGIN, requestOrigin);
        httpResponse.addHeader(ACCESS_CONTROL_ALLOW_CREDENTIALS, "true");
        httpResponse.addHeader(ACCESS_CONTROL_ALLOW_METHODS, DEFAULT_CORS_ACCESS_CONTROL_ALLOW_METHODS);
        httpResponse.addHeader(ACCESS_CONTROL_MAX_AGE, "259200");
        httpResponse.addHeader(ACCESS_CONTROL_ALLOW_HEADERS, DEFAULT_CORS_ACCESS_CONTROL_ALLOW_HEADERS);
        if (!this.isPreflightRequest((HttpServletRequest)request)) {
            chain.doFilter(request, response);
        }
    }

    private boolean isPreflightRequest(HttpServletRequest request) {
        return request.getHeader(ACCESS_CONTROL_REQUEST_METHOD) != null && request.getMethod() != null && request.getMethod().equalsIgnoreCase(PREFLIGHT_METHOD);
    }

    public void init(FilterConfig config) throws ServletException {
    }

    public void destroy() {
    }
}

