/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.datamining.rest;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.hawkular.datamining.api.SubscriptionManager;
import org.hawkular.datamining.forecast.DataPoint;
import org.hawkular.datamining.forecast.Forecaster;
import org.hawkular.datamining.rest.ApiError;

@Path(value="/")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Api(value="/metrics", description="Learn and predict.", tags={"Forecaster"})
public class RestForecaster {
    @HeaderParam(value="Hawkular-Tenant")
    private String tenant;
    @Inject
    private SubscriptionManager subscriptionManager;

    @GET
    @Path(value="/metrics/{metricId}/forecaster/forecast")
    @ApiOperation(value="Predict future values of given metric.")
    @ApiResponses(value={@ApiResponse(code=200, message="Success, predictions returned"), @ApiResponse(code=404, message="Subscription of given metric not found", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response predict(@PathParam(value="metricId") String metricId, @DefaultValue(value="1") @QueryParam(value="ahead") int ahead) {
        List dataPoints = this.subscriptionManager.subscription(this.tenant, metricId).forecaster().forecast(ahead);
        return Response.ok().entity((Object)dataPoints).build();
    }

    @POST
    @Path(value="/metrics/{metricId}/forecaster/learn")
    @ApiOperation(value="Learn model based on inserted values.")
    @ApiResponses(value={@ApiResponse(code=201, message="Success, learning successfully processed"), @ApiResponse(code=400, message="Missing or invalid payload", response=ApiError.class), @ApiResponse(code=404, message="Subscription of given metric not found", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response learn(@PathParam(value="metricId") String metricId, List<DataPoint> data) {
        this.subscriptionManager.subscription(this.tenant, metricId).forecaster().learn(data);
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    @PUT
    @Path(value="/metrics/{metricId}/forecaster")
    @ApiOperation(value="Change forecaster configuration.")
    @ApiResponses(value={@ApiResponse(code=201, message="Success, prediction successfully enabled"), @ApiResponse(code=400, message="Missing or invalid payload", response=ApiError.class), @ApiResponse(code=404, message="Subscription of given metric not found", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response updateForecaster(@PathParam(value="metricId") String metricId, @ApiParam(required=true) Forecaster.Update update) {
        this.subscriptionManager.updateForecaster(this.tenant, metricId, update);
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }
}

