/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.datamining.dist.integration.metrics;

import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.hawkular.alerts.bus.api.MetricDataMessage;
import org.hawkular.bus.common.ConnectionContextFactory;
import org.hawkular.bus.common.Endpoint;
import org.hawkular.bus.common.MessageProcessor;
import org.hawkular.bus.common.consumer.AbstractBasicMessageListener;
import org.hawkular.bus.common.consumer.BasicMessageListener;
import org.hawkular.bus.common.consumer.ConsumerConnectionContext;
import org.hawkular.datamining.api.SubscriptionManager;
import org.hawkular.datamining.dist.Logger;
import org.hawkular.datamining.forecast.DataPoint;

public class JMSMetricDataListener
extends BasicMessageListener<MetricDataMessage> {
    private final SubscriptionManager subscriptionManager;

    public JMSMetricDataListener(SubscriptionManager subscriptionManager) {
        this.subscriptionManager = subscriptionManager;
        try {
            InitialContext initialContext = new InitialContext();
            ConnectionFactory connectionFactory = (ConnectionFactory)initialContext.lookup("java:/HawkularBusConnectionFactory");
            ConnectionContextFactory factory = new ConnectionContextFactory(connectionFactory);
            Endpoint endpoint = new Endpoint(Endpoint.Type.TOPIC, "HawkularMetricData");
            ConsumerConnectionContext consumerConnectionContext = factory.createConsumerConnectionContext(endpoint);
            MessageProcessor processor = new MessageProcessor();
            processor.listen(consumerConnectionContext, (AbstractBasicMessageListener)this);
            Logger.LOGGER.connectedToTopic("HawkularMetricData");
        }
        catch (JMSException | NamingException ex) {
            Logger.LOGGER.errorf("Could not connect to: %s, exception: %s", (Object)"HawkularMetricData", (Object)ex);
        }
    }

    protected void onBasicMessage(MetricDataMessage metricDataMessage) {
        MetricDataMessage.MetricData metricData = metricDataMessage.getMetricData();
        String tenantId = metricData.getTenantId();
        for (MetricDataMessage.SingleMetric singleMetric : metricData.getData()) {
            if (singleMetric.getSource().startsWith("prediction_") || !this.subscriptionManager.isSubscribed(tenantId, singleMetric.getSource())) continue;
            DataPoint dataPoint = new DataPoint(Double.valueOf(singleMetric.getValue()), Long.valueOf(singleMetric.getTimestamp()));
            this.subscriptionManager.subscription(tenantId, singleMetric.getSource()).forecaster().learn(dataPoint);
        }
    }

    protected String convertReceivedMessageClassNameToDesiredMessageClassName(String className) {
        if (className.equals("org.hawkular.metrics.component.publish.MetricDataMessage")) {
            return MetricDataMessage.class.getCanonicalName();
        }
        return null;
    }
}

