/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.datamining.rest.filter;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;

@Provider
public class TenantFilter
implements ContainerRequestFilter {
    private static final String MISSING_TENANT_MSG;
    private static final Set<String> pathsWithoutTenantHeader;

    public void filter(ContainerRequestContext requestContext) throws IOException {
        String tenant = (String)requestContext.getHeaders().getFirst((Object)"Hawkular-Tenant");
        if (tenant != null && !tenant.trim().isEmpty()) {
            return;
        }
        if (pathsWithoutTenantHeader.contains(requestContext.getUriInfo().getPath())) {
            return;
        }
        Response response = Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)MISSING_TENANT_MSG).build();
        requestContext.abortWith(response);
    }

    static {
        pathsWithoutTenantHeader = new HashSet();
        MISSING_TENANT_MSG = "Tenant is not specified. Use 'Hawkular-Tenant' header.";
        pathsWithoutTenantHeader.add("/");
    }
}

