/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.datamining.rest;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.Collections;
import java.util.Set;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.hawkular.datamining.api.Subscription;
import org.hawkular.datamining.api.SubscriptionManager;
import org.hawkular.datamining.api.base.DataMiningForecaster;
import org.hawkular.datamining.api.base.DataMiningSubscription;
import org.hawkular.datamining.api.model.Metric;
import org.hawkular.datamining.rest.ApiError;

@Path(value="/")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Api(value="/metrics", description="Subscriptions CRUD.", tags={"Subscription"})
public class RestSubscriptions {
    @Inject
    private SubscriptionManager subscriptionManager;
    @HeaderParam(value="Hawkular-Tenant")
    private String tenant;

    @GET
    @Path(value="/metrics")
    @ApiOperation(value="Get all subscriptions of tenant.")
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=404, message="Subscription for given metric not found", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response getAll() {
        Set tenantsSubscriptions = this.subscriptionManager.subscriptionsOfTenant(this.tenant);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)tenantsSubscriptions).build();
    }

    @GET
    @Path(value="/metrics/{metricId}")
    @ApiOperation(value="Get a concrete subscription.")
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=404, message="Subscription for given metric not found", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response getOne(@PathParam(value="metricId") String metricId) {
        Subscription subscription = this.subscriptionManager.subscription(this.tenant, metricId);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)subscription).build();
    }

    @POST
    @Path(value="/metrics")
    @ApiOperation(value="Subscribe metric for prediction.")
    @ApiResponses(value={@ApiResponse(code=201, message="Success, prediction successfully enabled"), @ApiResponse(code=400, message="Missing or invalid payload", response=ApiError.class), @ApiResponse(code=409, message="Subscription for given metric already enabled", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response subscribe(@ApiParam(required=true) Metric.RestBlueprint blueprint) {
        Metric metric = new Metric(blueprint, this.tenant, null);
        DataMiningSubscription subscription = new DataMiningSubscription(new DataMiningForecaster(metric), Collections.singleton(Subscription.SubscriptionOwner.Metric));
        this.subscriptionManager.subscribe((Subscription)subscription);
        return Response.status((Response.Status)Response.Status.CREATED).build();
    }

    @PUT
    @Path(value="/metrics/{id}")
    @ApiOperation(value="Modify metric metadata.")
    @ApiResponses(value={@ApiResponse(code=201, message="Success, prediction successfully enabled"), @ApiResponse(code=400, message="Missing or invalid payload", response=ApiError.class), @ApiResponse(code=409, message="Subscription for given metric already enabled", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response updateMetric(@PathParam(value="id") String metricId, @ApiParam(required=true) Metric.Update update) {
        this.subscriptionManager.updateMetric(this.tenant, metricId, update);
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    @DELETE
    @Path(value="/metrics/{id}")
    @ApiOperation(value="Deletes subscription of given metric.")
    @ApiResponses(value={@ApiResponse(code=204, message="Success, Model successfully disabled"), @ApiResponse(code=400, message="Missing or invalid payload", response=ApiError.class), @ApiResponse(code=404, message="Model for given metric not found", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response unsubscribe(@PathParam(value="id") String metricId) {
        this.subscriptionManager.unsubscribeAll(this.tenant, metricId);
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }
}

