/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.commons.cassandra;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public class CassandraYaml {
    public static CassandraYamlBuilder builder() {
        return new CassandraYamlBuilder();
    }

    public static class StoredCassandraYamlStage {
        private final String cassandraConfigUrl;
        private final List<File> directoriesToCreate;
        private final String triggersDir;

        private StoredCassandraYamlStage(List<File> directoriesToCreate, String cassandraConfigUrl, String triggersDir) {
            this.directoriesToCreate = directoriesToCreate;
            this.cassandraConfigUrl = cassandraConfigUrl;
            this.triggersDir = triggersDir;
        }

        public StoredCassandraYamlStage mkdirs() {
            this.directoriesToCreate.stream().filter(dir -> !dir.exists()).forEach(File::mkdirs);
            return this;
        }

        public StoredCassandraYamlStage setCassandraConfigProp() {
            System.setProperty("cassandra.config", this.cassandraConfigUrl);
            return this;
        }

        public StoredCassandraYamlStage setTriggersDirProp() {
            System.setProperty("cassandra.triggers_dir", this.triggersDir);
            return this;
        }
    }

    public static enum CassandraYamlKey {
        authenticator,
        cluster_name,
        commitlog_directory,
        commitlog_sync,
        commitlog_sync_period_in_ms,
        compaction_throughput_mb_per_sec,
        data_file_directories,
        endpoint_snitch,
        hinted_handoff_enabled,
        hints_directory,
        key_cache_size_in_mb,
        listen_address("127.0.0.1"),
        native_transport_max_threads,
        native_transport_port(9042),
        num_tokens,
        partitioner,
        rpc_address,
        rpc_port(9160),
        rpc_server_type,
        saved_caches_directory,
        ssl_storage_port(7000),
        start_rpc,
        storage_port(7001);

        private static final CassandraYamlKey[] DIRECTORY_KEYS;
        private static final CassandraYamlKey[] PORT_KEYS;
        private final Object defaultValue;

        private CassandraYamlKey() {
            this.defaultValue = null;
        }

        private CassandraYamlKey(Object defaultValue) {
            this.defaultValue = defaultValue;
        }

        public <T> T getDefaultValue() {
            return (T)this.defaultValue;
        }

        static {
            DIRECTORY_KEYS = new CassandraYamlKey[]{commitlog_directory, saved_caches_directory, hints_directory};
            PORT_KEYS = new CassandraYamlKey[]{native_transport_port, rpc_port, ssl_storage_port, storage_port};
        }
    }

    public static class CassandraYamlBuilder {
        private static final Pattern DIRECTORY_SUFFIX_PATTERN = Pattern.compile("_directory$");
        private final Map<String, Object> config = new TreeMap<String, Object>();
        private File triggersDir;
        private final Yaml yaml = new Yaml(CassandraYamlBuilder.createDefaultDumperOptions());

        public static DumperOptions createDefaultDumperOptions() {
            DumperOptions result = new DumperOptions();
            result.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
            return result;
        }

        private CassandraYamlBuilder() {
        }

        public CassandraYamlBuilder baseDir(File baseDir) {
            this.config.put(CassandraYamlKey.data_file_directories.name(), Collections.singletonList(new File(baseDir, "data").getAbsolutePath()));
            Stream.of(CassandraYamlKey.DIRECTORY_KEYS).forEach(key -> {
                String keyName = key.name();
                File dir = new File(baseDir, DIRECTORY_SUFFIX_PATTERN.matcher(keyName).replaceAll(""));
                this.config.put(keyName, dir.getAbsolutePath());
            });
            this.triggersDir(new File(baseDir, "triggers"));
            return this;
        }

        public CassandraYamlBuilder triggersDir(File triggersDir) {
            this.triggersDir = triggersDir;
            return this;
        }

        public CassandraYamlBuilder clusterName(String clusterName) {
            return this.opt(CassandraYamlKey.cluster_name, clusterName);
        }

        public CassandraYamlBuilder defaultKeyCacheSize() {
            int defaultKeyCacheSize = Math.min(Math.max(1, (int)((double)Runtime.getRuntime().totalMemory() * 0.01 / 1024.0 / 1024.0)), 10);
            return this.opt(CassandraYamlKey.key_cache_size_in_mb, defaultKeyCacheSize);
        }

        public CassandraYamlBuilder defaultNativeTransportMaxThreads() {
            int defaultNativeTransportMaxThreads = Math.max(1, Runtime.getRuntime().availableProcessors() / 2);
            return this.opt(CassandraYamlKey.native_transport_max_threads, defaultNativeTransportMaxThreads);
        }

        private List<File> getDirectoriesToCreate() {
            ArrayList<File> result = new ArrayList<File>(2 + CassandraYamlKey.DIRECTORY_KEYS.length);
            Stream.of(CassandraYamlKey.DIRECTORY_KEYS).forEach(key -> {
                String keyName = key.name();
                Object path = this.config.get(keyName);
                if (path instanceof String) {
                    File dir = new File((String)path);
                    result.add(dir);
                }
            });
            Object dataDirs = this.config.get(CassandraYamlKey.data_file_directories.name());
            if (dataDirs instanceof List) {
                for (Object path : (List)dataDirs) {
                    if (!(path instanceof String)) continue;
                    File dir = new File((String)path);
                    result.add(dir);
                }
            }
            if (this.triggersDir != null) {
                result.add(this.triggersDir);
            }
            return Collections.unmodifiableList(result);
        }

        public CassandraYamlBuilder load(File file) throws IOException {
            try (FileInputStream in = new FileInputStream(file);){
                CassandraYamlBuilder cassandraYamlBuilder = this.load(in);
                return cassandraYamlBuilder;
            }
        }

        public CassandraYamlBuilder load(InputStream in) throws IOException {
            try (InputStreamReader r = new InputStreamReader(in, "utf-8");){
                Map fileValues = (Map)this.yaml.load((Reader)r);
                this.config.putAll(fileValues);
            }
            return this;
        }

        public CassandraYamlBuilder load(URL url) throws IOException {
            return this.load(url.openStream());
        }

        public CassandraYamlBuilder opt(CassandraYamlKey key, Object value) {
            this.config.put(key.name(), value);
            return this;
        }

        public CassandraYamlBuilder portOffset(int portOffset) {
            Stream.of(CassandraYamlKey.PORT_KEYS).forEach(key -> {
                String keyName = key.name();
                int defaultValue = (Integer)((CassandraYamlKey)key).defaultValue;
                this.config.put(keyName, defaultValue + portOffset);
            });
            return this;
        }

        public StoredCassandraYamlStage store(File path) throws IOException {
            File parentDir = path.getParentFile();
            if (!parentDir.exists()) {
                parentDir.mkdirs();
            }
            String cassandraConfigUrl = path.toURI().toURL().toString();
            try (OutputStreamWriter w = new OutputStreamWriter((OutputStream)new FileOutputStream(path), "utf-8");){
                this.yaml.dump(this.config, (Writer)w);
            }
            return new StoredCassandraYamlStage(this.getDirectoriesToCreate(), cassandraConfigUrl, this.triggersDir.getAbsolutePath());
        }
    }
}

