/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.cmdgw.log;

import javax.websocket.CloseReason;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.ValidIdRange;

@MessageLogger(projectCode="HAWKFEEDCOMM")
@ValidIdRange(min=1, max=5000)
public interface MsgLogger
extends BasicLogger {
    public static final MsgLogger LOG = (MsgLogger)Logger.getMessageLogger(MsgLogger.class, (String)"org.hawkular.cmdgw.command.ws");

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=3, value="Attempted to add a WebSocket session key [%s] twice for endpoint [%s]. This is a violation; closing the extra session")
    public void errorClosingDuplicateWsSession(String var1, String var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=4, value="Cannot close the duplicate WebSocket session with key [%s] of endpoint [%s]")
    public void errorCannotCloseDuplicateWsSession(String var1, String var2, @Cause Throwable var3);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=5, value="UI client [%s] (session [%s]) provided an invalid command request: [%s]")
    public void errorInvalidCommandRequestUIClient(String var1, String var2, String var3);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=6, value="Failed to process message [%s] from WebSocket session [%s] of [%s]")
    public void errorWsCommandExecutionFailure(String var1, String var2, String var3, @Cause Throwable var4);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=7, value="Cannot process an execute-operation message")
    public void errorCannotProcessExecuteOperationMessage(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=8, value="Received the following error message and stack trace from remote endpoint: %s\n%s")
    public void warnReceivedGenericErrorResponse(String var1, String var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=10, value="Failed to add message listeners for feed [%s]. Closing session [%s]")
    public void errorFailedToAddMessageListenersForFeed(String var1, String var2, @Cause Throwable var3);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=12, value="Feed [%s] session closed. Reason=[%s]")
    public void infoFeedSessionClosed(String var1, CloseReason var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=13, value="WebSocket session [%s] opened for endpoint [%s]")
    public void infoWsSessionOpened(String var1, String var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=14, value="Received message [%s] from WebSocket session [%s] of [%s]")
    public void infoReceivedWsMessage(String var1, String var2, String var3);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=15, value="WebSocket session [%s] of [%s] closed. Reason=[%s]")
    public void infoWsSessionClosed(String var1, String var2, CloseReason var3);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=16, value="Adding listeners for feed [%s]")
    public void infoAddingListenersForFeed(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=17, value="Failed to close consumer context; will keep trying to close the rest")
    public void errorFailedClosingConsumerContext(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=18, value="Removing listeners for feed [%s]")
    public void infoRemovingListenersForFeed(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=19, value="Failed to removing listeners for feed [%s]")
    public void errorFailedRemovingListenersForFeed(String var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=20, value="Received binary data from feed [%s]")
    public void infoReceivedBinaryDataFromFeed(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=21, value="Received message [%s] with binary data from WebSocket session [%s] of [%s]")
    public void infoReceivedBinaryData(String var1, String var2, String var3);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=22, value="Adding listeners for UI client [%s]")
    public void infoAddingListenersForUIClient(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=23, value="Removing listeners for UI client [%s]")
    public void infoRemovingListenersForUIClient(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=24, value="Failed to removing listeners for UI client [%s]")
    public void errorFailedRemovingListenersForUIClient(String var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=25, value="Failed to add message listeners for UI client [%s]. Closing session [%s]")
    public void errorFailedToAddMessageListenersForUIClient(String var1, String var2, @Cause Throwable var3);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=26, value="Could not process message [%s] with binary data [%b] from endpoint [%s]")
    public void errorCouldNotProcessBusMessage(String var1, boolean var2, String var3, @Cause Throwable var4);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=27, value="Cannot process an Export JDR response message")
    public void errorCannotProcessExportJdrResponseMessage(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=28, value="Failed to close WebSocket session [%s] of endpoint [%s] after authentication failureof request [%s]")
    public void errorCloseSessionAfterAuthFailure(@Cause Throwable var1, String var2, String var3, String var4);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=29, value="No WebSocket session of endpoint [%s] found for key [%s] to send a [%s]")
    public void warnNoWsSessionForKey(String var1, String var2, String var3);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=30, value="Encountered a message [%s] without a [%s] header in bus endpoint [%s]")
    public void errorMessageWithoutFeedId(String var1, String var2, String var3);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=31, value="Could not invoke [%s.%s] on session [%s] of [%s]")
    public void errorInvokingWsSessionListener(String var1, String var2, String var3, String var4, @Cause Exception var5);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=32, value="Could not close [%s] with selector [%s] for endpoint [%s]")
    public void errorCouldNotClose(String var1, String var2, String var3, @Cause Throwable var4);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=33, value="Could not add [%s] with selector [%s] to bus endpoint [%s]")
    public void errorCouldNotAddBusEndpointListener(String var1, String var2, String var3, @Cause Throwable var4);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=34, value="%s got a message [%s] without an expected header [%s] value [%s] (expected [%s]) in bus endpoint [%s]")
    public void errorListenerGotMessageWithUnexpectedHeaderValue(String var1, String var2, String var3, String var4, String var5, String var6);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=35, value="Could not destroy [%s] of endpoint [%s]")
    public void couldNotDestroy(String var1, String var2, @Cause Throwable var3);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=36, value="Failed to send error response [%s] to WebSocket client session [%s] of endpoint [%s]")
    public void errorFailedToSendErrorResponse(@Cause Throwable var1, String var2, String var3, String var4);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=37, value="Failed sending async binary data to client [%s]")
    public void errorFailedSendingAsyncBinaryData(@Cause Throwable var1, String var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=38, value="Could not close connection context factory [%s]")
    public void errorCouldNotCloseConnectionContextFactory(@Cause Throwable var1, String var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=39, value="Could not initialize [%s]")
    public void errorCouldNotInitialize(@Cause Throwable var1, String var2);

    @Message(id=40, value="Failed to lookup [%s] using name [%s] within [%d] ms")
    public String errFailedToLookupConnectionFactory(String var1, String var2, long var3);

    @Message(id=41, value="Failed to lookup [%s] using name [%s]")
    public String errFailedToLookupConnectionFactory(String var1, String var2);
}

